/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mailer.runtime;

import io.quarkus.mailer.Attachment;
import io.quarkus.mailer.Mail;
import io.quarkus.mailer.reactive.ReactiveMailer;
import io.quarkus.mailer.runtime.MockMailboxImpl;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.OpenOptions;
import io.vertx.ext.mail.MailAttachment;
import io.vertx.ext.mail.MailMessage;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.ext.mail.MailClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.reactivestreams.Publisher;

@ApplicationScoped
public class MutinyMailerImpl
implements ReactiveMailer {
    private static final Logger LOGGER = Logger.getLogger((String)"quarkus-mailer");
    @Inject
    MailClient client;
    @Inject
    Vertx vertx;
    @Inject
    MockMailboxImpl mockMailbox;
    private volatile String from;
    private volatile String bounceAddress;
    private volatile boolean mock;

    @Override
    public Uni<Void> send(Mail ... mails) {
        if (mails == null) {
            throw new IllegalArgumentException("The `mails` parameter must not be `null`");
        }
        List unis = Arrays.stream(mails).map(mail -> this.toMailMessage((Mail)mail).onItem().produceUni(mailMessage -> this.send((Mail)mail, (MailMessage)mailMessage))).collect(Collectors.toList());
        return Uni.combine().all().unis(unis).combinedWith(results -> null);
    }

    private Uni<Void> send(Mail mail, MailMessage message) {
        if (this.mock) {
            LOGGER.infof("Sending email %s from %s to %s, text body: \n%s\nhtml body: \n%s", new Object[]{message.getSubject(), message.getFrom(), message.getTo(), message.getText() == null ? "<empty>" : message.getText(), message.getHtml() == null ? "<empty>" : message.getHtml()});
            return this.mockMailbox.send(mail);
        }
        return this.client.sendMail(message).onItem().ignore().andContinueWithNull();
    }

    private Uni<MailMessage> toMailMessage(Mail mail) {
        MailMessage message = new MailMessage();
        if (mail.getBounceAddress() != null) {
            message.setBounceAddress(mail.getBounceAddress());
        } else {
            message.setBounceAddress(this.bounceAddress);
        }
        if (mail.getFrom() != null) {
            message.setFrom(mail.getFrom());
        } else {
            message.setFrom(this.from);
        }
        message.setTo(mail.getTo());
        message.setCc(mail.getCc());
        message.setBcc(mail.getBcc());
        message.setSubject(mail.getSubject());
        message.setText(mail.getText());
        message.setHtml(mail.getHtml());
        message.setHeaders(this.toMultimap(mail.getHeaders()));
        if (mail.getReplyTo() != null) {
            message.addHeader("Reply-To", mail.getReplyTo());
        }
        ArrayList<Uni> stages = new ArrayList<Uni>();
        CopyOnWriteArrayList attachments = new CopyOnWriteArrayList();
        CopyOnWriteArrayList inline = new CopyOnWriteArrayList();
        for (Attachment attachment : mail.getAttachments()) {
            if (attachment.isInlineAttachment()) {
                stages.add(this.toMailAttachment(attachment).onItem().invoke(inline::add));
                continue;
            }
            stages.add(this.toMailAttachment(attachment).onItem().invoke(attachments::add));
        }
        if (stages.isEmpty()) {
            message.setAttachment(attachments);
            message.setInlineAttachment(inline);
            return Uni.createFrom().item((Object)message);
        }
        return Uni.combine().all().unis(stages).combinedWith(res -> {
            message.setAttachment(attachments);
            message.setInlineAttachment(inline);
            return message;
        });
    }

    private MultiMap toMultimap(Map<String, List<String>> headers) {
        MultiMap mm = MultiMap.caseInsensitiveMultiMap();
        headers.forEach((arg_0, arg_1) -> ((MultiMap)mm).add(arg_0, arg_1));
        return mm;
    }

    private Uni<MailAttachment> toMailAttachment(Attachment attachment) {
        MailAttachment attach = new MailAttachment();
        attach.setName(attachment.getName());
        attach.setContentId(attachment.getContentId());
        attach.setDescription(attachment.getDescription());
        attach.setDisposition(attachment.getDisposition());
        attach.setContentType(attachment.getContentType());
        if (attachment.getFile() == null && attachment.getData() == null || attachment.getFile() != null && attachment.getData() != null) {
            throw new IllegalArgumentException("An attachment must contain either a file or a raw data");
        }
        return MutinyMailerImpl.getAttachmentStream(this.vertx, attachment).onItem().apply(arg_0 -> ((MailAttachment)attach).setData(arg_0));
    }

    public static Uni<Buffer> getAttachmentStream(Vertx vertx, Attachment attachment) {
        if (attachment.getFile() != null) {
            Uni open = vertx.fileSystem().open(attachment.getFile().getAbsolutePath(), new OpenOptions().setRead(true).setCreate(false));
            return open.flatMap(af -> af.toMulti().map(io.vertx.mutiny.core.buffer.Buffer::getDelegate).on().termination((r, f) -> af.close()).collectItems().in(Buffer::buffer, Buffer::appendBuffer));
        }
        if (attachment.getData() != null) {
            Publisher<Byte> data = attachment.getData();
            return Multi.createFrom().publisher(data).collectItems().in(Buffer::buffer, Buffer::appendByte);
        }
        return Uni.createFrom().failure((Throwable)new IllegalArgumentException("Attachment has no data"));
    }

    void configure(Optional<String> from, Optional<String> bounceAddress, boolean mock) {
        this.from = from.orElse(null);
        this.bounceAddress = bounceAddress.orElse(null);
        this.mock = mock;
    }
}

