/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mailer.runtime;

import io.quarkus.mailer.Attachment;
import io.quarkus.mailer.Mail;
import io.quarkus.mailer.reactive.ReactiveMailer;
import io.quarkus.mailer.runtime.MockMailboxImpl;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.OpenOptions;
import io.vertx.ext.mail.MailAttachment;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.mailencoder.EmailAddress;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.ext.mail.MailClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class MutinyMailerImpl
implements ReactiveMailer {
    private static final Logger LOGGER = Logger.getLogger((String)"quarkus-mailer");
    private final Vertx vertx;
    private final MailClient client;
    private final MockMailboxImpl mockMailbox;
    private final String from;
    private final String bounceAddress;
    private final boolean mock;
    private final List<Pattern> approvedRecipients;
    private final boolean logRejectedRecipients;
    private final boolean logInvalidRecipients;

    MutinyMailerImpl(Vertx vertx, MailClient client, MockMailboxImpl mockMailbox, String from, String bounceAddress, boolean mock, List<Pattern> approvedRecipients, boolean logRejectedRecipients, boolean logInvalidRecipients) {
        this.vertx = vertx;
        this.client = client;
        this.mockMailbox = mockMailbox;
        this.from = from;
        this.bounceAddress = bounceAddress;
        this.mock = mock;
        this.approvedRecipients = approvedRecipients;
        this.logRejectedRecipients = logRejectedRecipients;
        this.logInvalidRecipients = logInvalidRecipients;
    }

    @Override
    public Uni<Void> send(Mail ... mails) {
        if (mails == null) {
            throw new IllegalArgumentException("The `mails` parameter must not be `null`");
        }
        List unis = Arrays.stream(mails).map(new Function<Mail, Uni<Void>>(){

            @Override
            public Uni<Void> apply(final Mail mail) {
                return MutinyMailerImpl.this.toMailMessage(mail).chain((Function)new Function<MailMessage, Uni<? extends Void>>(){

                    @Override
                    public Uni<? extends Void> apply(MailMessage mailMessage) {
                        return MutinyMailerImpl.this.send(mail, mailMessage);
                    }
                });
            }
        }).collect(Collectors.toList());
        return Uni.combine().all().unis(unis).discardItems();
    }

    private Uni<Void> send(Mail mail, MailMessage message) {
        if (!this.approvedRecipients.isEmpty()) {
            Recipients to = this.filterApprovedRecipients(message.getTo());
            Recipients cc = this.filterApprovedRecipients(message.getCc());
            Recipients bcc = this.filterApprovedRecipients(message.getBcc());
            if (to.approved.isEmpty() && cc.approved.isEmpty() && bcc.approved.isEmpty()) {
                this.logRejectedRecipients("Email '%s' was not sent because all recipients were rejected by the configuration: %s", message.getSubject(), to.rejected, cc.rejected, bcc.rejected);
                return Uni.createFrom().voidItem();
            }
            if (!(to.rejected.isEmpty() && cc.rejected.isEmpty() && bcc.rejected.isEmpty())) {
                this.logRejectedRecipients("Email '%s' was not sent to the following recipients as they were rejected by the configuration: %s", message.getSubject(), to.rejected, cc.rejected, bcc.rejected);
            }
            if (!to.rejected.isEmpty()) {
                mail.setTo(to.approved);
                message.setTo(to.approved);
            }
            if (!cc.rejected.isEmpty()) {
                mail.setCc(cc.approved);
                message.setCc(cc.approved);
            }
            if (!bcc.rejected.isEmpty()) {
                mail.setBcc(bcc.approved);
                message.setBcc(bcc.approved);
            }
        }
        if (this.mock) {
            LOGGER.infof("Sending email %s from %s to %s (cc: %s, bcc: %s), text body: \n%s\nhtml body: \n%s", new Object[]{message.getSubject(), message.getFrom(), message.getTo(), message.getCc(), message.getBcc(), message.getText() == null ? "<empty>" : message.getText(), message.getHtml() == null ? "<empty>" : message.getHtml()});
            return this.mockMailbox.send(mail, message);
        }
        return this.client.sendMail(message).replaceWithVoid();
    }

    private Uni<MailMessage> toMailMessage(Mail mail) {
        MailMessage message = new MailMessage();
        if (mail.getBounceAddress() != null) {
            message.setBounceAddress(mail.getBounceAddress());
        } else {
            message.setBounceAddress(this.bounceAddress);
        }
        if (mail.getFrom() != null) {
            message.setFrom(mail.getFrom());
        } else {
            message.setFrom(this.from);
        }
        message.setTo(mail.getTo());
        message.setCc(mail.getCc());
        message.setBcc(mail.getBcc());
        this.validate(mail.getTo(), mail.getCc(), mail.getBcc());
        message.setSubject(mail.getSubject());
        message.setText(mail.getText());
        message.setHtml(mail.getHtml());
        message.setHeaders(this.toMultimap(mail.getHeaders()));
        if (mail.getReplyTo() != null) {
            message.addHeader("Reply-To", mail.getReplyTo());
        }
        ArrayList<Uni> stages = new ArrayList<Uni>();
        CopyOnWriteArrayList attachments = new CopyOnWriteArrayList();
        CopyOnWriteArrayList inline = new CopyOnWriteArrayList();
        for (Attachment attachment : mail.getAttachments()) {
            if (attachment.isInlineAttachment()) {
                stages.add(this.toMailAttachment(attachment).onItem().invoke(inline::add));
                continue;
            }
            stages.add(this.toMailAttachment(attachment).onItem().invoke(attachments::add));
        }
        if (stages.isEmpty()) {
            message.setAttachment(attachments);
            message.setInlineAttachment(inline);
            return Uni.createFrom().item((Object)message);
        }
        return Uni.combine().all().unis(stages).with(res -> {
            message.setAttachment(attachments);
            message.setInlineAttachment(inline);
            return message;
        });
    }

    private void validate(List<String> to, List<String> cc, List<String> bcc) {
        try {
            for (String email : to) {
                new EmailAddress(email);
            }
            for (String email : cc) {
                new EmailAddress(email);
            }
            for (String email : bcc) {
                new EmailAddress(email);
            }
        }
        catch (IllegalArgumentException e) {
            if (this.logInvalidRecipients) {
                LOGGER.warn((Object)"Unable to send an email", (Throwable)e);
                throw new IllegalArgumentException("Unable to send an email", e);
            }
            LOGGER.warn((Object)"Unable to send an email, an email address is invalid");
            throw new IllegalArgumentException("Unable to send an email, an email address is invalid");
        }
    }

    private MultiMap toMultimap(Map<String, List<String>> headers) {
        MultiMap mm = MultiMap.caseInsensitiveMultiMap();
        headers.forEach((arg_0, arg_1) -> ((MultiMap)mm).add(arg_0, arg_1));
        return mm;
    }

    private Uni<MailAttachment> toMailAttachment(Attachment attachment) {
        MailAttachment attach = MailAttachment.create();
        attach.setName(attachment.getName());
        attach.setContentId(attachment.getContentId());
        attach.setDescription(attachment.getDescription());
        attach.setDisposition(attachment.getDisposition());
        attach.setContentType(attachment.getContentType());
        if (attachment.getFile() == null && attachment.getData() == null || attachment.getFile() != null && attachment.getData() != null) {
            throw new IllegalArgumentException("An attachment must contain either a file or a raw data");
        }
        return MutinyMailerImpl.getAttachmentStream(this.vertx, attachment).onItem().transform(arg_0 -> ((MailAttachment)attach).setData(arg_0));
    }

    private Recipients filterApprovedRecipients(List<String> emails) {
        if (this.approvedRecipients.isEmpty()) {
            return new Recipients(emails, List.of());
        }
        ArrayList<String> allowedRecipients = new ArrayList<String>();
        ArrayList<String> rejectedRecipients = new ArrayList<String>();
        block0: for (String email : emails) {
            for (Pattern approvedRecipient : this.approvedRecipients) {
                if (!approvedRecipient.matcher(email).matches()) continue;
                allowedRecipients.add(email);
                continue block0;
            }
            rejectedRecipients.add(email);
        }
        return new Recipients(allowedRecipients, rejectedRecipients);
    }

    @SafeVarargs
    private void logRejectedRecipients(String logMessage, String subject, List<String> ... rejectedRecipientLists) {
        if (this.logRejectedRecipients) {
            LinkedHashSet<String> allRejectedRecipients = new LinkedHashSet<String>();
            for (List<String> rejectedRecipients : rejectedRecipientLists) {
                allRejectedRecipients.addAll(rejectedRecipients);
            }
            LOGGER.warn((Object)String.format(logMessage, subject, allRejectedRecipients));
        } else if (LOGGER.isDebugEnabled()) {
            ArrayList<String> allRejectedRecipients = new ArrayList<String>();
            for (List<String> rejectedRecipients : rejectedRecipientLists) {
                allRejectedRecipients.addAll(rejectedRecipients);
            }
            LOGGER.warn((Object)String.format(logMessage, subject, allRejectedRecipients));
        }
    }

    public static Uni<Buffer> getAttachmentStream(Vertx vertx, Attachment attachment) {
        if (attachment.getFile() != null) {
            Uni open = vertx.fileSystem().open(attachment.getFile().getAbsolutePath(), new OpenOptions().setRead(true).setCreate(false));
            return open.flatMap(af -> af.toMulti().map(io.vertx.mutiny.core.buffer.Buffer::getDelegate).onTermination().call((r, f) -> af.close()).collect().in(Buffer::buffer, Buffer::appendBuffer));
        }
        if (attachment.getData() != null) {
            Flow.Publisher<Byte> data = attachment.getData();
            return Multi.createFrom().publisher(data).collect().in(Buffer::buffer, Buffer::appendByte);
        }
        return Uni.createFrom().failure((Throwable)new IllegalArgumentException("Attachment has no data"));
    }

    private static class Recipients {
        private final List<String> approved;
        private final List<String> rejected;

        Recipients(List<String> approved, List<String> rejected) {
            this.approved = approved;
            this.rejected = rejected;
        }
    }
}

