/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mailer.runtime;

import io.quarkus.mailer.Mail;
import io.quarkus.mailer.MockMailbox;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.mailencoder.EmailAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MockMailboxImpl
implements MockMailbox {
    private Map<String, List<Mail>> sentMails = new HashMap<String, List<Mail>>();
    private Map<String, List<MailMessage>> sentMailMessages = new HashMap<String, List<MailMessage>>();
    private int sentMessagesCount;

    Uni<Void> send(Mail email, MailMessage mailMessage) {
        if (email.getTo() != null) {
            for (String to : email.getTo()) {
                this.validateEmailAddress(to);
                this.send(email, mailMessage, to);
            }
        }
        if (email.getCc() != null) {
            for (String to : email.getCc()) {
                this.validateEmailAddress(to);
                this.send(email, mailMessage, to);
            }
        }
        if (email.getBcc() != null) {
            for (String to : email.getBcc()) {
                this.validateEmailAddress(to);
                this.send(email, mailMessage, to);
            }
        }
        return Uni.createFrom().item(() -> null);
    }

    private void validateEmailAddress(String to) {
        new EmailAddress(to);
    }

    private void send(Mail sentMail, MailMessage sentMailMessage, String to) {
        this.sentMails.computeIfAbsent(to, k -> new ArrayList()).add(sentMail);
        this.sentMailMessages.computeIfAbsent(to, k -> new ArrayList()).add(sentMailMessage);
        ++this.sentMessagesCount;
    }

    @Override
    public List<Mail> getMessagesSentTo(String address) {
        return this.sentMails.getOrDefault(address, List.of());
    }

    @Override
    public List<Mail> getMailsSentTo(String address) {
        return this.sentMails.getOrDefault(address, List.of());
    }

    @Override
    public List<MailMessage> getMailMessagesSentTo(String address) {
        return this.sentMailMessages.getOrDefault(address, List.of());
    }

    @Override
    public void clear() {
        this.sentMessagesCount = 0;
        this.sentMails.clear();
        this.sentMailMessages.clear();
    }

    @Override
    public int getTotalMessagesSent() {
        return this.sentMessagesCount;
    }
}

