/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.maven.MojoLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="create-example-config", defaultPhase=LifecyclePhase.NONE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ExampleConfigMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;

    public ExampleConfigMojo() {
        MojoLogger.logSupplier = () -> ((ExampleConfigMojo)this).getLog();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File out = new File(this.project.getBasedir(), "src/main/resources/application.properties");
            out.getParentFile().mkdirs();
            Properties properties = new Properties();
            for (Object a : this.project.getArtifacts()) {
                if (!"jar".equals(a.getType())) continue;
                ZipFile zipFile = this.openZipFile((Artifact)a);
                Throwable throwable = null;
                try {
                    ZipEntry deps = zipFile.getEntry("META-INF/quarkus-descriptions.properties");
                    if (deps == null) continue;
                    InputStream in = zipFile.getInputStream(deps);
                    Throwable throwable2 = null;
                    try {
                        properties.load(in);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable2 != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (zipFile == null) continue;
                    if (throwable != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    zipFile.close();
                }
            }
            StringBuilder sb = new StringBuilder("Example quarkus config\n\n");
            for (Map.Entry entry : new TreeMap<Object, Object>(properties).entrySet()) {
                sb.append("# ").append(entry.getValue().toString().replace("\n", " ")).append("\n#").append(entry.getKey()).append("=\n\n");
            }
            this.getLog().error((CharSequence)("Creating example File at " + out));
            Throwable throwable = null;
            try (FileOutputStream f = new FileOutputStream(out);){
                f.write(sb.toString().getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable7) {
                Throwable throwable8 = throwable7;
                throw throwable7;
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to generate config", e);
        }
    }

    private ZipFile openZipFile(Artifact a) {
        File file = a.getFile();
        if (file == null) {
            throw new RuntimeException("No file for Artifact:" + a.toString());
        }
        if (!Files.isReadable(file.toPath())) {
            throw new RuntimeException("File not existing or not allowed for reading: " + file.getAbsolutePath());
        }
        try {
            return new ZipFile(file);
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening zip stream from artifact: " + a.toString());
        }
    }
}

