/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.creator.AppCreationPhase;
import io.quarkus.creator.AppCreator;
import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.phase.augment.AugmentPhase;
import io.quarkus.creator.phase.curate.CurateOutcome;
import io.quarkus.creator.phase.runnerjar.RunnerJarOutcome;
import io.quarkus.creator.phase.runnerjar.RunnerJarPhase;
import io.quarkus.maven.MojoLogger;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="build", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class BuildMojo
extends AbstractMojo {
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true, required=true)
    private List<RemoteRepository> pluginRepos;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/transformed-classes")
    private File transformedClassesDirectory;
    @Parameter(defaultValue="${project.build.directory}/wiring-classes")
    private File wiringClassesDirectory;
    @Parameter(defaultValue="${project.build.directory}")
    private File buildDir;
    @Parameter(defaultValue="${project.build.directory}/lib")
    private File libDir;
    @Parameter(defaultValue="${project.build.finalName}")
    private String finalName;
    @Parameter(defaultValue="io.quarkus.runner.GeneratedMain")
    private String mainClass;
    @Parameter(defaultValue="true")
    private boolean useStaticInit;
    @Parameter(property="uberJar", defaultValue="false")
    private boolean uberJar;

    public BuildMojo() {
        MojoLogger.logSupplier = () -> ((BuildMojo)this).getLog();
    }

    public void execute() throws MojoExecutionException {
        AppModel appModel;
        BootstrapAppModelResolver modelResolver;
        AppArtifact appArtifact = new AppArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
        try {
            modelResolver = new BootstrapAppModelResolver(MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem).setRepositorySystemSession(this.repoSession).setRemoteRepositories(this.repos).build());
            appModel = modelResolver.resolveModel(appArtifact);
        }
        catch (AppModelResolverException e) {
            throw new MojoExecutionException("Failed to resolve application model " + appArtifact + " dependencies", (Exception)((Object)e));
        }
        try (AppCreator appCreator = AppCreator.builder().addPhase((AppCreationPhase)new AugmentPhase().setAppClassesDir(this.outputDirectory.toPath()).setConfigDir(this.outputDirectory.toPath()).setTransformedClassesDir(this.transformedClassesDirectory.toPath()).setWiringClassesDir(this.wiringClassesDirectory.toPath())).addPhase((AppCreationPhase)new RunnerJarPhase().setLibDir(this.libDir.toPath()).setFinalName(this.finalName).setMainClass(this.mainClass).setUberJar(this.uberJar)).setWorkDir(this.buildDir.toPath()).build();){
            appCreator.pushOutcome((Object)CurateOutcome.builder().setAppModelResolver((AppModelResolver)modelResolver).setAppModel(appModel).build());
            appCreator.resolveOutcome(RunnerJarOutcome.class);
        }
        catch (AppCreatorException e) {
            throw new MojoExecutionException("Failed to build a runnable JAR", (Exception)((Object)e));
        }
    }
}

