/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.cli.commands.AddExtensions;
import io.quarkus.cli.commands.CreateProject;
import io.quarkus.maven.components.MavenVersionEnforcer;
import io.quarkus.maven.components.Prompter;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.templates.SourceType;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.fusesource.jansi.Ansi;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="create", requiresProject=false)
public class CreateProjectMojo
extends AbstractMojo {
    public static final String PLUGIN_KEY = MojoUtils.getPluginGroupId() + ":" + MojoUtils.getPluginArtifactId();
    private static final String DEFAULT_GROUP_ID = "org.acme.quarkus.sample";
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(property="projectGroupId")
    private String projectGroupId;
    @Parameter(property="projectArtifactId")
    private String projectArtifactId;
    @Parameter(property="projectVersion")
    private String projectVersion;
    @Parameter(property="path")
    private String path;
    @Parameter(property="className")
    private String className;
    @Parameter(property="extensions")
    private Set<String> extensions;
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Component
    private Prompter prompter;
    @Component
    private MavenVersionEnforcer mavenVersionEnforcer;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private ProjectBuilder projectBuilder;

    public void execute() throws MojoExecutionException {
        boolean success;
        this.mavenVersionEnforcer.ensureMavenVersion(this.getLog(), this.session);
        File projectRoot = new File(".");
        File pom = new File(projectRoot, "pom.xml");
        if (pom.isFile()) {
            if (!(StringUtils.isBlank((CharSequence)this.projectGroupId) && StringUtils.isBlank((CharSequence)this.projectArtifactId) && StringUtils.isBlank((CharSequence)this.projectVersion))) {
                throw new MojoExecutionException("Unable to generate the project, the `projectGroupId`, `projectArtifactId` and `projectVersion` parameters are not supported when applied to an existing `pom.xml` file");
            }
            this.projectGroupId = this.project.getGroupId();
            this.projectArtifactId = this.project.getArtifactId();
            this.projectVersion = this.project.getVersion();
        } else {
            this.askTheUserForMissingValues();
            if (!this.isDirectoryEmpty(projectRoot) && (projectRoot = new File(this.projectArtifactId)).exists()) {
                throw new MojoExecutionException("Unable to create the project - the current directory is not empty and the directory " + this.projectArtifactId + " exists");
            }
        }
        try {
            SourceType sourceType = this.determineSourceType(this.extensions);
            this.sanitizeOptions(sourceType);
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("path", this.path);
            success = new CreateProject(projectRoot).groupId(this.projectGroupId).artifactId(this.projectArtifactId).version(this.projectVersion).sourceType(sourceType).className(this.className).doCreateProject(context);
            File createdPomFile = new File(projectRoot, "pom.xml");
            if (success) {
                new AddExtensions(createdPomFile).addExtensions(this.extensions);
            }
            this.createMavenWrapper(createdPomFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        if (success) {
            this.printUserInstructions(projectRoot);
        }
    }

    private void createMavenWrapper(File createdPomFile) {
        try {
            MavenProject newProject = this.projectBuilder.build(createdPomFile, (ProjectBuildingRequest)new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest())).getProject();
            MavenExecutionRequest newExecutionRequest = DefaultMavenExecutionRequest.copy((MavenExecutionRequest)this.session.getRequest());
            newExecutionRequest.setBaseDirectory(createdPomFile.getParentFile());
            MavenSession newSession = new MavenSession(this.session.getContainer(), this.session.getRepositorySession(), newExecutionRequest, this.session.getResult());
            newSession.setCurrentProject(newProject);
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"io.takari"), (String)MojoExecutor.artifactId((String)"maven"), (String)MojoExecutor.version((String)MojoUtils.getMavenWrapperVersion())), (String)MojoExecutor.goal((String)"wrapper"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"maven"), (String)MojoUtils.getProposedMavenVersion())}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)newProject, (MavenSession)newSession, (BuildPluginManager)this.pluginManager));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Unable to install the Maven wrapper (./mvnw) in the project", (Throwable)e);
        }
    }

    private SourceType determineSourceType(Set<String> extensions) {
        return extensions.stream().anyMatch(e -> e.toLowerCase().contains("kotlin")) ? SourceType.KOTLIN : SourceType.JAVA;
    }

    private void askTheUserForMissingValues() throws MojoExecutionException {
        if (!this.session.getRequest().isInteractiveMode() || this.shouldUseDefaults()) {
            if (StringUtils.isBlank((CharSequence)this.projectGroupId)) {
                this.projectGroupId = DEFAULT_GROUP_ID;
            }
            if (StringUtils.isBlank((CharSequence)this.projectArtifactId)) {
                this.projectArtifactId = "my-quarkus-project";
            }
            if (StringUtils.isBlank((CharSequence)this.projectVersion)) {
                this.projectVersion = "1.0-SNAPSHOT";
            }
            return;
        }
        try {
            if (StringUtils.isBlank((CharSequence)this.projectGroupId)) {
                this.projectGroupId = this.prompter.promptWithDefaultValue("Set the project groupId", DEFAULT_GROUP_ID);
            }
            if (StringUtils.isBlank((CharSequence)this.projectArtifactId)) {
                this.projectArtifactId = this.prompter.promptWithDefaultValue("Set the project artifactId", "my-quarkus-project");
            }
            if (StringUtils.isBlank((CharSequence)this.projectVersion)) {
                this.projectVersion = this.prompter.promptWithDefaultValue("Set the project version", "1.0-SNAPSHOT");
            }
            if (StringUtils.isBlank((CharSequence)this.className)) {
                String answer = this.prompter.promptWithDefaultValue("Do you want to create a REST resource? (y/n)", "no");
                if (this.isTrueOrYes(answer)) {
                    String defaultResourceName = this.projectGroupId.replace("-", ".").replace("_", ".") + ".HelloResource";
                    this.className = this.prompter.promptWithDefaultValue("Set the resource classname", defaultResourceName);
                    if (StringUtils.isBlank((CharSequence)this.path)) {
                        this.path = this.prompter.promptWithDefaultValue("Set the resource path ", "/hello");
                    }
                } else {
                    this.className = null;
                    this.path = null;
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to get user input", (Exception)e);
        }
    }

    private boolean shouldUseDefaults() {
        return this.projectArtifactId != null;
    }

    private boolean isTrueOrYes(String answer) {
        if (answer == null) {
            return false;
        }
        String content = answer.trim().toLowerCase();
        return "true".equalsIgnoreCase(content) || "yes".equalsIgnoreCase(content) || "y".equalsIgnoreCase(content);
    }

    private void sanitizeOptions(SourceType sourceType) {
        if (this.className != null) {
            this.className = sourceType.stripExtensionFrom(this.className);
            if (!this.className.contains(".")) {
                this.className = this.projectGroupId.replace("-", ".").replace("_", ".") + "." + this.className;
            }
            if (StringUtils.isBlank((CharSequence)this.path)) {
                this.path = "/hello";
            }
            if (!this.path.startsWith("/")) {
                this.path = "/" + this.path;
            }
        }
        this.extensions = this.extensions.stream().map(String::trim).collect(Collectors.toSet());
    }

    private void printUserInstructions(File root) {
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"========================================================================================");
        this.getLog().info((CharSequence)Ansi.ansi().a("Your new application has been created in ").bold().a(root.getAbsolutePath()).boldOff().toString());
        this.getLog().info((CharSequence)Ansi.ansi().a("Navigate into this directory and launch your application with ").bold().fg(Ansi.Color.CYAN).a("mvn compile quarkus:dev").reset().toString());
        this.getLog().info((CharSequence)Ansi.ansi().a("Your application will be accessible on ").bold().fg(Ansi.Color.CYAN).a("http://localhost:8080").reset().toString());
        this.getLog().info((CharSequence)"========================================================================================");
        this.getLog().info((CharSequence)"");
    }

    private boolean isDirectoryEmpty(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("The specified file must be a directory: " + dir.getAbsolutePath());
        }
        String[] children = dir.list();
        if (children == null) {
            throw new IllegalArgumentException("The specified directory cannot be accessed: " + dir.getAbsolutePath());
        }
        return children.length == 0;
    }
}

