/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.deployment.ApplicationInfoUtil;
import io.quarkus.dev.DevModeMain;
import io.quarkus.maven.components.MavenVersionEnforcer;
import io.quarkus.maven.utilities.MojoUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="dev", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DevMojo
extends AbstractMojo {
    private static final String RESOURCES_PROP = "quarkus-internal.undertow.resources";
    @Parameter(readonly=true, required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${debug}")
    private String debug;
    @Parameter(defaultValue="${project.build.directory}")
    private File buildDir;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private File sourceDir;
    @Parameter(defaultValue="${jvm.args}")
    private String jvmArgs;
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Parameter(defaultValue="TRUE")
    private boolean deleteDevJar;
    @Component
    private MavenVersionEnforcer mavenVersionEnforcer;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(defaultValue="${preventnoverify}")
    private boolean preventnoverify = false;
    @Component
    private ToolchainManager toolchainManager;

    public ToolchainManager getToolchainManager() {
        return this.toolchainManager;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        this.mavenVersionEnforcer.ensureMavenVersion(this.getLog(), this.session);
        boolean found = false;
        block28: for (Plugin i : this.project.getBuildPlugins()) {
            if (!i.getGroupId().equals(MojoUtils.getPluginGroupId()) || !i.getArtifactId().equals(MojoUtils.getPluginArtifactId())) continue;
            for (Object p : i.getExecutions()) {
                if (!p.getGoals().contains("build")) continue;
                found = true;
                continue block28;
            }
        }
        if (!found) {
            this.getLog().warn((CharSequence)"The quarkus-maven-plugin build goal was not configured for this project, skipping quarkus:dev as this is assumed to be a support library. If you want to run quarkus dev on this project make sure the quarkus-maven-plugin is configured with a build goal.");
            return;
        }
        if (!this.sourceDir.isDirectory()) {
            throw new MojoFailureException("The `src/main/java` directory is required, please create it.");
        }
        if (!this.buildDir.isDirectory() || !new File(this.buildDir, "classes").isDirectory()) {
            throw new MojoFailureException("The project has no output yet, run `mvn compile quarkus:dev`.");
        }
        try {
            File path;
            AppModel appModel;
            ArrayList<String> args = new ArrayList<String>();
            String javaTool = this.findJavaTool();
            this.getLog().debug((CharSequence)("Using javaTool: " + javaTool));
            args.add(javaTool);
            if (this.debug == null) {
                try {
                    Object p;
                    Socket socket = new Socket(InetAddress.getByAddress(new byte[]{127, 0, 0, 1}), 5005);
                    p = null;
                    try {
                        this.getLog().error((CharSequence)"Port 5005 in use, not starting in debug mode");
                    }
                    catch (Throwable throwable) {
                        p = throwable;
                        throw throwable;
                    }
                    finally {
                        if (socket != null) {
                            if (p != null) {
                                try {
                                    socket.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)p).addSuppressed(throwable);
                                }
                            } else {
                                socket.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    args.add("-Xdebug");
                    args.add("-Xrunjdwp:transport=dt_socket,address=5005,server=y,suspend=n");
                }
            } else if (this.debug.toLowerCase().equals("client")) {
                args.add("-Xdebug");
                args.add("-Xrunjdwp:transport=dt_socket,address=localhost:5005,server=n,suspend=n");
            } else if (this.debug.toLowerCase().equals("true")) {
                args.add("-Xdebug");
                args.add("-Xrunjdwp:transport=dt_socket,address=localhost:5005,server=y,suspend=y");
            } else if (!this.debug.toLowerCase().equals("false")) {
                try {
                    int port = Integer.parseInt(this.debug);
                    if (port <= 0) {
                        throw new MojoFailureException("The specified debug port must be greater than 0");
                    }
                    args.add("-Xdebug");
                    args.add("-Xrunjdwp:transport=dt_socket,address=" + port + ",server=y,suspend=y");
                }
                catch (NumberFormatException e) {
                    throw new MojoFailureException("Invalid value for debug parameter: " + this.debug + " must be true|false|client|{port}");
                }
            }
            if (this.jvmArgs != null) {
                args.addAll(Arrays.asList(this.jvmArgs.split(" ")));
            }
            for (Map.Entry<Object, Object> i : System.getProperties().entrySet()) {
                if (!i.getKey().toString().startsWith("quarkus.")) continue;
                args.add("-D" + i.getKey() + "=" + i.getValue());
            }
            for (Resource r : this.project.getBuild().getResources()) {
                File f = new File(r.getDirectory());
                File servletRes = new File(f, "META-INF/resources");
                if (!servletRes.exists()) continue;
                args.add("-Dquarkus-internal.undertow.resources=" + servletRes.getAbsolutePath());
                this.getLog().debug((CharSequence)("Using servlet resources: " + servletRes.getAbsolutePath()));
                break;
            }
            args.add("-XX:TieredStopAtLevel=1");
            if (!this.preventnoverify) {
                args.add("-Xverify:none");
            }
            StringBuilder classPathManifest = new StringBuilder();
            StringBuilder classPath = new StringBuilder();
            try {
                LocalProject localProject = LocalProject.resolveLocalProjectWithWorkspace((Path)LocalProject.locateCurrentProjectDir((Path)this.outputDirectory.toPath()));
                appModel = new BootstrapAppModelResolver(MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem).setRepositorySystemSession(this.repoSession).setRemoteRepositories(this.repos).setWorkspace(localProject.getWorkspace()).build()).resolveModel(localProject.getAppArtifact());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to resolve Quarkus application model", e);
            }
            for (AppDependency appDep : appModel.getAllDependencies()) {
                this.addToClassPaths(classPathManifest, classPath, appDep.getArtifact().getPath().toFile());
            }
            args.add("-Djava.util.logging.manager=org.jboss.logmanager.LogManager");
            File wiringClassesDirectory = new File(this.buildDir, "wiring-devmode");
            wiringClassesDirectory.mkdirs();
            this.addToClassPaths(classPathManifest, classPath, wiringClassesDirectory);
            URL classFile = DevModeMain.class.getClassLoader().getResource(DevModeMain.class.getName().replace('.', '/') + ".class");
            if (classFile.getProtocol().equals("jar")) {
                String jarPath = classFile.getPath().substring(0, classFile.getPath().lastIndexOf(33));
                if (jarPath.startsWith("file:")) {
                    jarPath = jarPath.substring(5);
                }
                path = new File(URLDecoder.decode(jarPath, StandardCharsets.UTF_8.name()));
            } else if (classFile.getProtocol().equals("file")) {
                String filePath = classFile.getPath().substring(0, classFile.getPath().lastIndexOf(DevModeMain.class.getName().replace('.', '/')));
                path = new File(URLDecoder.decode(filePath, StandardCharsets.UTF_8.name()));
            } else {
                throw new MojoFailureException("Unsupported DevModeMain artifact URL:" + classFile);
            }
            this.addToClassPaths(classPathManifest, classPath, path);
            File tempFile = new File(this.buildDir, this.project.getArtifactId() + "-dev.jar");
            tempFile.delete();
            if (this.deleteDevJar) {
                tempFile.deleteOnExit();
            }
            this.getLog().debug((CharSequence)("Executable jar: " + tempFile.getAbsolutePath()));
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(tempFile));
            Object object = null;
            try {
                out.putNextEntry(new ZipEntry("META-INF/"));
                Manifest manifest = new Manifest();
                manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
                manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, classPathManifest.toString());
                manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, DevModeMain.class.getName());
                out.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                manifest.write(out);
                out.putNextEntry(new ZipEntry("META-INF/dev-mode-class-path.txt"));
                out.write(classPath.toString().getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable manifest) {
                object = manifest;
                throw manifest;
            }
            finally {
                if (out != null) {
                    if (object != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable manifest) {
                            ((Throwable)object).addSuppressed(manifest);
                        }
                    } else {
                        out.close();
                    }
                }
            }
            String resources = null;
            object = this.project.getBuild().getResources().iterator();
            if (object.hasNext()) {
                Resource i = (Resource)object.next();
                resources = i.getDirectory();
            }
            this.outputDirectory.mkdirs();
            ApplicationInfoUtil.writeApplicationInfoProperties((AppArtifact)appModel.getAppArtifact(), (Path)this.outputDirectory.toPath());
            DevMojo.addProperty(args, "quarkus-internal.runner.classes", this.outputDirectory.getAbsolutePath());
            DevMojo.addProperty(args, "quarkus-internal.runner.sources", this.sourceDir.getAbsolutePath());
            if (resources != null) {
                DevMojo.addProperty(args, "quarkus-internal.runner.resources", new File(resources).getAbsolutePath());
            }
            args.add("-jar");
            args.add(tempFile.getAbsolutePath());
            args.add(this.outputDirectory.getAbsolutePath());
            args.add(wiringClassesDirectory.getAbsolutePath());
            args.add(new File(this.buildDir, "transformer-cache").getAbsolutePath());
            this.getLog().debug((CharSequence)("Launching JVM with command line: " + ((Object)args).toString()));
            ProcessBuilder pb = new ProcessBuilder(args.toArray(new String[0]));
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
            pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
            pb.directory(this.outputDirectory);
            final Process p = pb.start();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    p.destroy();
                }
            }, "Development Mode Shutdown Hook"));
            try {
                p.waitFor();
            }
            catch (Exception e) {
                p.destroy();
                throw e;
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to run", (Throwable)e);
        }
    }

    private static void addProperty(List<String> args, String name, Object value) {
        args.add("-D" + name + "=" + value);
    }

    protected String findJavaTool() {
        Toolchain toolchain;
        String java = null;
        if (this.getToolchainManager() != null && (toolchain = this.getToolchainManager().getToolchainFromBuildContext("jdk", this.getSession())) != null) {
            java = toolchain.findTool("java");
            this.getLog().debug((CharSequence)("JVM from toolchain: " + java));
        }
        if (java == null) {
            java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            File javaCheck = new File(java);
            this.getLog().debug((CharSequence)("Checking: " + javaCheck.getAbsolutePath()));
            if (!javaCheck.canExecute()) {
                this.getLog().debug((CharSequence)(javaCheck.getAbsolutePath() + " is not executable"));
                java = null;
                if (OS.determineOS() == OS.WINDOWS && System.getenv().containsKey("PATHEXT")) {
                    String[] exts;
                    String extpath = System.getenv("PATHEXT");
                    for (String ext : exts = extpath.split(";")) {
                        File winExe = new File(javaCheck.getAbsolutePath() + ext);
                        this.getLog().debug((CharSequence)("Checking: " + winExe.getAbsolutePath()));
                        if (!winExe.canExecute()) continue;
                        java = winExe.getAbsolutePath();
                        this.getLog().debug((CharSequence)("Executable: " + winExe.getAbsolutePath()));
                        break;
                    }
                }
                if (java == null) {
                    java = OS.determineOS() == OS.WINDOWS ? "java.exe" : "java";
                }
            }
        }
        this.getLog().debug((CharSequence)("findJavaTool, selected JVM: " + java));
        return java;
    }

    private void addToClassPaths(StringBuilder classPathManifest, StringBuilder classPath, File file) {
        URI uri = file.toPath().toAbsolutePath().toUri();
        String path = uri.getRawPath();
        classPathManifest.append(path);
        classPath.append(uri.toString());
        if (file.isDirectory()) {
            classPathManifest.append("/");
            classPath.append("/");
        }
        classPathManifest.append(" ");
        classPath.append(" ");
    }

    static enum OS {
        WINDOWS,
        LINUX,
        MAC,
        OTHER;

        private String version;

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        static OS determineOS() {
            OS os = OTHER;
            String osName = System.getProperty("os.name");
            os = (osName = osName.toLowerCase()).contains("windows") ? WINDOWS : (osName.contains("linux") || osName.contains("freebsd") || osName.contains("unix") || osName.contains("sunos") || osName.contains("solaris") || osName.contains("aix") ? LINUX : (osName.contains("mac os") ? MAC : OTHER));
            os.setVersion(System.getProperty("os.version"));
            return os;
        }
    }
}

