/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.cli.commands.AddExtensions;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="add-extension")
public class AddExtensionMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(property="extensions")
    Set<String> extensions;
    @Parameter(property="extension")
    String extension;

    public void execute() throws MojoExecutionException {
        if (StringUtils.isBlank((CharSequence)this.extension) && (this.extensions == null || this.extensions.isEmpty()) || !StringUtils.isBlank((CharSequence)this.extension) && this.extensions != null && !this.extensions.isEmpty()) {
            throw new MojoExecutionException("Either the `extension` or `extensions` parameter must be set");
        }
        HashSet<String> ext = new HashSet<String>();
        if (this.extensions != null && !this.extensions.isEmpty()) {
            ext.addAll(this.extensions);
        } else {
            ext.add(this.extension);
        }
        try {
            Model model = this.project.getOriginalModel().clone();
            new AddExtensions(model.getPomFile()).addExtensions(ext.stream().map(String::trim).collect(Collectors.toSet()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to update the pom.xml file", (Exception)e);
        }
    }
}

