/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.deployment.ApplicationInfoUtil;
import io.quarkus.dev.DevModeContext;
import io.quarkus.dev.DevModeMain;
import io.quarkus.maven.components.MavenVersionEnforcer;
import io.quarkus.maven.utilities.MojoUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="dev", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DevMojo
extends AbstractMojo {
    @Parameter(readonly=true, required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${debug}")
    private String debug;
    @Parameter(defaultValue="${project.build.directory}")
    private File buildDir;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private File sourceDir;
    @Parameter(defaultValue="${jvm.args}")
    private String jvmArgs;
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Parameter(defaultValue="TRUE")
    private boolean deleteDevJar;
    @Component
    private MavenVersionEnforcer mavenVersionEnforcer;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(defaultValue="${preventnoverify}")
    private boolean preventnoverify = false;
    @Component
    private ToolchainManager toolchainManager;

    public ToolchainManager getToolchainManager() {
        return this.toolchainManager;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        this.mavenVersionEnforcer.ensureMavenVersion(this.getLog(), this.session);
        boolean found = MojoUtils.checkProjectForMavenBuildPlugin((MavenProject)this.project);
        if (!found) {
            this.getLog().warn((CharSequence)"The quarkus-maven-plugin build goal was not configured for this project, skipping quarkus:dev as this is assumed to be a support library. If you want to run quarkus dev on this project make sure the quarkus-maven-plugin is configured with a build goal.");
            return;
        }
        if (!this.sourceDir.isDirectory()) {
            this.getLog().warn((CharSequence)"The `src/main/java` directory does not exist");
        }
        if (!this.buildDir.isDirectory() || !new File(this.buildDir, "classes").isDirectory()) {
            throw new MojoFailureException("The project has no output yet, run `mvn compile quarkus:dev`.");
        }
        try {
            File path;
            AppModel appModel;
            Object i;
            ArrayList<String> args = new ArrayList<String>();
            String javaTool = this.findJavaTool();
            this.getLog().debug((CharSequence)("Using javaTool: " + javaTool));
            args.add(javaTool);
            if (this.debug == null) {
                try (Socket socket = new Socket(InetAddress.getByAddress(new byte[]{127, 0, 0, 1}), 5005);){
                    this.getLog().error((CharSequence)"Port 5005 in use, not starting in debug mode");
                }
                catch (IOException e) {
                    args.add("-Xdebug");
                    args.add("-Xrunjdwp:transport=dt_socket,address=5005,server=y,suspend=n");
                }
            } else if (this.debug.toLowerCase().equals("client")) {
                args.add("-Xdebug");
                args.add("-Xrunjdwp:transport=dt_socket,address=localhost:5005,server=n,suspend=n");
            } else if (this.debug.toLowerCase().equals("true")) {
                args.add("-Xdebug");
                args.add("-Xrunjdwp:transport=dt_socket,address=localhost:5005,server=y,suspend=y");
            } else if (!this.debug.toLowerCase().equals("false")) {
                try {
                    int port = Integer.parseInt(this.debug);
                    if (port <= 0) {
                        throw new MojoFailureException("The specified debug port must be greater than 0");
                    }
                    args.add("-Xdebug");
                    args.add("-Xrunjdwp:transport=dt_socket,address=" + port + ",server=y,suspend=y");
                }
                catch (NumberFormatException e) {
                    throw new MojoFailureException("Invalid value for debug parameter: " + this.debug + " must be true|false|client|{port}");
                }
            }
            if (this.jvmArgs != null) {
                args.addAll(Arrays.asList(this.jvmArgs.split(" ")));
            }
            args.add("-XX:TieredStopAtLevel=1");
            if (!this.preventnoverify) {
                args.add("-Xverify:none");
            }
            StringBuilder classPathManifest = new StringBuilder();
            DevModeContext devModeContext = new DevModeContext();
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                devModeContext.getSystemProperties().put(entry.getKey().toString(), (String)entry.getValue());
            }
            try {
                ArrayList<AppArtifactKey> orderedProjects;
                LocalProject localProject;
                block66: {
                    boolean changed;
                    localProject = LocalProject.loadWorkspace((Path)this.outputDirectory.toPath());
                    orderedProjects = new ArrayList<AppArtifactKey>();
                    HashSet toplace = new HashSet();
                    for (Map.Entry entry : localProject.getWorkspace().getProjects().entrySet()) {
                        toplace.add(entry.getKey());
                    }
                    do {
                        changed = false;
                        Iterator iterator = toplace.iterator();
                        while (iterator.hasNext()) {
                            AppArtifactKey current = (AppArtifactKey)iterator.next();
                            LocalProject project = (LocalProject)localProject.getWorkspace().getProjects().get(current);
                            boolean canPlace = true;
                            for (Dependency dep : project.getRawModel().getDependencies()) {
                                AppArtifactKey key = new AppArtifactKey(dep.getGroupId(), dep.getArtifactId(), dep.getClassifier(), dep.getType());
                                if (!toplace.contains(key)) continue;
                                canPlace = false;
                                break;
                            }
                            if (!canPlace) continue;
                            changed = true;
                            orderedProjects.add(current);
                            iterator.remove();
                        }
                        if (toplace.isEmpty()) break block66;
                    } while (changed);
                    throw new MojoFailureException("Failed to establish partial ordering between projects " + localProject.getWorkspace().getProjects().keySet());
                }
                for (AppArtifactKey appArtifactKey : orderedProjects) {
                    Path resourcesSourcesDir;
                    Path classesDir;
                    String sourcePath = null;
                    String classesPath = null;
                    String resourcePath = null;
                    LocalProject project = (LocalProject)localProject.getWorkspace().getProjects().get(appArtifactKey);
                    Path javaSourcesDir = project.getSourcesSourcesDir();
                    if (Files.isDirectory(javaSourcesDir, new LinkOption[0])) {
                        sourcePath = javaSourcesDir.toAbsolutePath().toString();
                    }
                    if (Files.isDirectory(classesDir = project.getClassesDir(), new LinkOption[0])) {
                        classesPath = classesDir.toAbsolutePath().toString();
                    }
                    if (Files.isDirectory(resourcesSourcesDir = project.getResourcesSourcesDir(), new LinkOption[0])) {
                        resourcePath = resourcesSourcesDir.toAbsolutePath().toString();
                    }
                    DevModeContext.ModuleInfo moduleInfo = new DevModeContext.ModuleInfo(appArtifactKey.getArtifactId(), sourcePath, classesPath, resourcePath);
                    devModeContext.getModules().add(moduleInfo);
                }
                String resources = null;
                Iterator iterator = this.project.getBuild().getResources().iterator();
                if (iterator.hasNext()) {
                    i = (Resource)iterator.next();
                    resources = i.getDirectory();
                }
                appModel = new BootstrapAppModelResolver(MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem).setRepositorySystemSession(this.repoSession).setRemoteRepositories(this.repos).setWorkspace(localProject.getWorkspace()).build()).resolveModel(localProject.getAppArtifact());
            }
            catch (Exception exception) {
                throw new MojoExecutionException("Failed to resolve Quarkus application model", exception);
            }
            for (AppDependency appDep : appModel.getAllDependencies()) {
                this.addToClassPaths(classPathManifest, devModeContext, appDep.getArtifact().getPath().toFile());
            }
            args.add("-Djava.util.logging.manager=org.jboss.logmanager.LogManager");
            File file = new File(this.buildDir, "wiring-devmode");
            file.mkdirs();
            this.addToClassPaths(classPathManifest, devModeContext, file);
            URL classFile = DevModeMain.class.getClassLoader().getResource(DevModeMain.class.getName().replace('.', '/') + ".class");
            if (classFile.getProtocol().equals("jar")) {
                String jarPath = classFile.getPath().substring(0, classFile.getPath().lastIndexOf(33));
                if (jarPath.startsWith("file:")) {
                    jarPath = jarPath.substring(5);
                }
                path = new File(URLDecoder.decode(jarPath, StandardCharsets.UTF_8.name()));
            } else if (classFile.getProtocol().equals("file")) {
                String filePath = classFile.getPath().substring(0, classFile.getPath().lastIndexOf(DevModeMain.class.getName().replace('.', '/')));
                path = new File(URLDecoder.decode(filePath, StandardCharsets.UTF_8.name()));
            } else {
                throw new MojoFailureException("Unsupported DevModeMain artifact URL:" + classFile);
            }
            this.addToClassPaths(classPathManifest, devModeContext, path);
            File tempFile = new File(this.buildDir, this.project.getArtifactId() + "-dev.jar");
            tempFile.delete();
            if (this.deleteDevJar) {
                tempFile.deleteOnExit();
            }
            this.getLog().debug((CharSequence)("Executable jar: " + tempFile.getAbsolutePath()));
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(tempFile));
            i = null;
            try {
                zipOutputStream.putNextEntry(new ZipEntry("META-INF/"));
                Manifest manifest = new Manifest();
                manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
                manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, classPathManifest.toString());
                manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, DevModeMain.class.getName());
                zipOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                manifest.write(zipOutputStream);
                zipOutputStream.putNextEntry(new ZipEntry("META-INF/dev-mode-context.dat"));
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                ObjectOutputStream obj = new ObjectOutputStream(new DataOutputStream(bytes));
                obj.writeObject(devModeContext);
                obj.close();
                zipOutputStream.write(bytes.toByteArray());
            }
            catch (Throwable manifest) {
                i = manifest;
                throw manifest;
            }
            finally {
                if (zipOutputStream != null) {
                    if (i != null) {
                        try {
                            zipOutputStream.close();
                        }
                        catch (Throwable manifest) {
                            ((Throwable)i).addSuppressed(manifest);
                        }
                    } else {
                        zipOutputStream.close();
                    }
                }
            }
            this.outputDirectory.mkdirs();
            ApplicationInfoUtil.writeApplicationInfoProperties((AppArtifact)appModel.getAppArtifact(), (Path)this.outputDirectory.toPath());
            args.add("-jar");
            args.add(tempFile.getAbsolutePath());
            args.add(this.outputDirectory.getAbsolutePath());
            args.add(file.getAbsolutePath());
            args.add(new File(this.buildDir, "transformer-cache").getAbsolutePath());
            this.getLog().debug((CharSequence)("Launching JVM with command line: " + ((Object)args).toString()));
            ProcessBuilder processBuilder = new ProcessBuilder(args.toArray(new String[0]));
            processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
            processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            processBuilder.redirectInput(ProcessBuilder.Redirect.INHERIT);
            processBuilder.directory(this.outputDirectory);
            final Process p = processBuilder.start();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    p.destroy();
                }
            }, "Development Mode Shutdown Hook"));
            try {
                int ret = p.waitFor();
                if (ret != 0) {
                    throw new MojoFailureException("JVM exited with error code: " + String.valueOf(ret));
                }
            }
            catch (Exception e) {
                p.destroy();
                throw e;
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to run", (Throwable)e);
        }
    }

    private static void addProperty(List<String> args, String name, Object value) {
        args.add("-D" + name + "=" + value);
    }

    protected String findJavaTool() {
        Toolchain toolchain;
        String java = null;
        if (this.getToolchainManager() != null && (toolchain = this.getToolchainManager().getToolchainFromBuildContext("jdk", this.getSession())) != null) {
            java = toolchain.findTool("java");
            this.getLog().debug((CharSequence)("JVM from toolchain: " + java));
        }
        if (java == null) {
            java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            File javaCheck = new File(java);
            this.getLog().debug((CharSequence)("Checking: " + javaCheck.getAbsolutePath()));
            if (!javaCheck.canExecute()) {
                this.getLog().debug((CharSequence)(javaCheck.getAbsolutePath() + " is not executable"));
                java = null;
                if (OS.determineOS() == OS.WINDOWS && System.getenv().containsKey("PATHEXT")) {
                    String[] exts;
                    String extpath = System.getenv("PATHEXT");
                    for (String ext : exts = extpath.split(";")) {
                        File winExe = new File(javaCheck.getAbsolutePath() + ext);
                        this.getLog().debug((CharSequence)("Checking: " + winExe.getAbsolutePath()));
                        if (!winExe.canExecute()) continue;
                        java = winExe.getAbsolutePath();
                        this.getLog().debug((CharSequence)("Executable: " + winExe.getAbsolutePath()));
                        break;
                    }
                }
                if (java == null) {
                    java = OS.determineOS() == OS.WINDOWS ? "java.exe" : "java";
                }
            }
        }
        this.getLog().debug((CharSequence)("findJavaTool, selected JVM: " + java));
        return java;
    }

    private void addToClassPaths(StringBuilder classPathManifest, DevModeContext classPath, File file) {
        URI uri = file.toPath().toAbsolutePath().toUri();
        try {
            classPath.getClassPath().add(uri.toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String path = uri.getRawPath();
        classPathManifest.append(path);
        if (file.isDirectory()) {
            classPathManifest.append("/");
        }
        classPathManifest.append(" ");
    }

    static enum OS {
        WINDOWS,
        LINUX,
        MAC,
        OTHER;

        private String version;

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        static OS determineOS() {
            OS os = OTHER;
            String osName = System.getProperty("os.name");
            os = (osName = osName.toLowerCase()).contains("windows") ? WINDOWS : (osName.contains("linux") || osName.contains("freebsd") || osName.contains("unix") || osName.contains("sunos") || osName.contains("solaris") || osName.contains("aix") ? LINUX : (osName.contains("mac os") ? MAC : OTHER));
            os.setVersion(System.getProperty("os.version"));
            return os;
        }
    }
}

