/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.deployment.ApplicationInfoUtil;
import io.quarkus.dev.DevModeContext;
import io.quarkus.dev.DevModeMain;
import io.quarkus.maven.components.MavenVersionEnforcer;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.utilities.JavaBinFinder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="dev", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DevMojo
extends AbstractMojo {
    @Parameter(readonly=true, required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${debug}")
    private String debug;
    @Parameter(defaultValue="${project.build.directory}")
    private File buildDir;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private File sourceDir;
    @Parameter(defaultValue="${jvm.args}")
    private String jvmArgs;
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Parameter(defaultValue="TRUE")
    private boolean deleteDevJar;
    @Component
    private MavenVersionEnforcer mavenVersionEnforcer;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(defaultValue="${preventnoverify}")
    private boolean preventnoverify = false;
    @Parameter(defaultValue="${noDeps}")
    private boolean noDeps = false;
    @Component
    private ToolchainManager toolchainManager;

    public ToolchainManager getToolchainManager() {
        return this.toolchainManager;
    }

    public MavenSession getSession() {
        return this.session;
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws MojoFailureException, MojoExecutionException {
        this.mavenVersionEnforcer.ensureMavenVersion(this.getLog(), this.session);
        boolean found = MojoUtils.checkProjectForMavenBuildPlugin((MavenProject)this.project);
        if (!found) {
            this.getLog().warn((CharSequence)"The quarkus-maven-plugin build goal was not configured for this project, skipping quarkus:dev as this is assumed to be a support library. If you want to run quarkus dev on this project make sure the quarkus-maven-plugin is configured with a build goal.");
            return;
        }
        if (!this.sourceDir.isDirectory()) {
            this.getLog().warn((CharSequence)("The project's sources directory does not exist " + this.sourceDir));
        }
        if (!this.buildDir.isDirectory() || !new File(this.buildDir, "classes").isDirectory()) {
            throw new MojoFailureException("The project " + this.project.getName() + " has no output yet. Make sure it contains at least one source or resource file and then run `mvn compile quarkus:dev`.");
        }
        try {
            File path;
            AppModel appModel;
            ArrayList<String> args = new ArrayList<String>();
            String javaTool = JavaBinFinder.findBin();
            this.getLog().debug((CharSequence)("Using javaTool: " + javaTool));
            args.add(javaTool);
            if (this.debug == null) {
                try (Socket socket = new Socket(InetAddress.getByAddress(new byte[]{127, 0, 0, 1}), 5005);){
                    this.getLog().error((CharSequence)"Port 5005 in use, not starting in debug mode");
                }
                catch (IOException e) {
                    args.add("-Xdebug");
                    args.add("-Xrunjdwp:transport=dt_socket,address=5005,server=y,suspend=n");
                }
            } else if (this.debug.toLowerCase().equals("client")) {
                args.add("-Xdebug");
                args.add("-Xrunjdwp:transport=dt_socket,address=localhost:5005,server=n,suspend=n");
            } else if (this.debug.toLowerCase().equals("true")) {
                args.add("-Xdebug");
                args.add("-Xrunjdwp:transport=dt_socket,address=localhost:5005,server=y,suspend=y");
            } else if (!this.debug.toLowerCase().equals("false")) {
                try {
                    int port = Integer.parseInt(this.debug);
                    if (port <= 0) {
                        throw new MojoFailureException("The specified debug port must be greater than 0");
                    }
                    args.add("-Xdebug");
                    args.add("-Xrunjdwp:transport=dt_socket,address=" + port + ",server=y,suspend=y");
                }
                catch (NumberFormatException e) {
                    throw new MojoFailureException("Invalid value for debug parameter: " + this.debug + " must be true|false|client|{port}");
                }
            }
            if (this.jvmArgs != null) {
                args.addAll(Arrays.asList(this.jvmArgs.split(" ")));
            }
            args.add("-XX:TieredStopAtLevel=1");
            if (!this.preventnoverify) {
                args.add("-Xverify:none");
            }
            StringBuilder classPathManifest = new StringBuilder();
            DevModeContext devModeContext = new DevModeContext();
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                devModeContext.getSystemProperties().put(entry.getKey().toString(), (String)entry.getValue());
            }
            devModeContext.getBuildSystemProperties().putAll(this.project.getProperties());
            try {
                void var7_18;
                if (this.noDeps) {
                    LocalProject localProject = LocalProject.load((Path)this.outputDirectory.toPath());
                    this.addProject(devModeContext, localProject);
                } else {
                    LocalProject localProject = LocalProject.loadWorkspace((Path)this.outputDirectory.toPath());
                    for (LocalProject project : localProject.getSelfWithLocalDeps()) {
                        if (project.getClassesDir() != null && (Files.exists(project.getClassesDir().resolve("META-INF/quarkus-extension.properties"), new LinkOption[0]) || Files.exists(project.getClassesDir().resolve("META-INF/quarkus-build-steps.list"), new LinkOption[0]))) continue;
                        this.addProject(devModeContext, project);
                    }
                }
                appModel = new BootstrapAppModelResolver(MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem).setRepositorySystemSession(this.repoSession).setRemoteRepositories(this.repos).setWorkspace(var7_18.getWorkspace()).build()).setDevMode(true).resolveModel(var7_18.getAppArtifact());
            }
            catch (Exception exception) {
                throw new MojoExecutionException("Failed to resolve Quarkus application model", exception);
            }
            for (AppDependency appDep : appModel.getAllDependencies()) {
                this.addToClassPaths(classPathManifest, devModeContext, appDep.getArtifact().getPath().toFile());
            }
            args.add("-Djava.util.logging.manager=org.jboss.logmanager.LogManager");
            File file = new File(this.buildDir, "wiring-devmode");
            file.mkdirs();
            this.addToClassPaths(classPathManifest, devModeContext, file);
            URL classFile = DevModeMain.class.getClassLoader().getResource(DevModeMain.class.getName().replace('.', '/') + ".class");
            if (classFile.getProtocol().equals("jar")) {
                String jarPath = classFile.getPath().substring(0, classFile.getPath().lastIndexOf(33));
                if (jarPath.startsWith("file:")) {
                    jarPath = jarPath.substring(5);
                }
                path = new File(URLDecoder.decode(jarPath, StandardCharsets.UTF_8.name()));
            } else if (classFile.getProtocol().equals("file")) {
                String filePath = classFile.getPath().substring(0, classFile.getPath().lastIndexOf(DevModeMain.class.getName().replace('.', '/')));
                path = new File(URLDecoder.decode(filePath, StandardCharsets.UTF_8.name()));
            } else {
                throw new MojoFailureException("Unsupported DevModeMain artifact URL:" + classFile);
            }
            this.addToClassPaths(classPathManifest, devModeContext, path);
            File tempFile = new File(this.buildDir, this.project.getArtifactId() + "-dev.jar");
            tempFile.delete();
            if (this.deleteDevJar) {
                tempFile.deleteOnExit();
            }
            this.getLog().debug((CharSequence)("Executable jar: " + tempFile.getAbsolutePath()));
            try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(tempFile));){
                out.putNextEntry(new ZipEntry("META-INF/"));
                Manifest manifest = new Manifest();
                manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
                manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, classPathManifest.toString());
                manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, DevModeMain.class.getName());
                out.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                manifest.write(out);
                out.putNextEntry(new ZipEntry("META-INF/dev-mode-context.dat"));
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                ObjectOutputStream obj = new ObjectOutputStream(new DataOutputStream(bytes));
                obj.writeObject(devModeContext);
                obj.close();
                out.write(bytes.toByteArray());
            }
            this.outputDirectory.mkdirs();
            ApplicationInfoUtil.writeApplicationInfoProperties((AppArtifact)appModel.getAppArtifact(), (Path)this.outputDirectory.toPath());
            args.add("-jar");
            args.add(tempFile.getAbsolutePath());
            args.add(this.outputDirectory.getAbsolutePath());
            args.add(file.getAbsolutePath());
            args.add(new File(this.buildDir, "transformer-cache").getAbsolutePath());
            this.getLog().debug((CharSequence)("Launching JVM with command line: " + ((Object)args).toString()));
            ProcessBuilder pb = new ProcessBuilder(args.toArray(new String[0]));
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
            pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
            pb.directory(this.outputDirectory);
            final Process p = pb.start();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    p.destroy();
                }
            }, "Development Mode Shutdown Hook"));
            try {
                int ret = p.waitFor();
                if (ret != 0) {
                    throw new MojoFailureException("JVM exited with error code: " + ret);
                }
            }
            catch (Exception e) {
                p.destroy();
                throw e;
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to run", (Throwable)e);
        }
    }

    private void addProject(DevModeContext devModeContext, LocalProject localProject) {
        Path resourcesSourcesDir;
        String projectDirectory = null;
        Set<Object> sourcePaths = null;
        String classesPath = null;
        String resourcePath = null;
        MavenProject mavenProject = (MavenProject)this.session.getProjectMap().get(String.format("%s:%s:%s", localProject.getGroupId(), localProject.getArtifactId(), localProject.getVersion()));
        if (mavenProject == null) {
            projectDirectory = localProject.getDir().toAbsolutePath().toString();
            Path sourcePath = localProject.getSourcesSourcesDir().toAbsolutePath();
            sourcePaths = Files.isDirectory(sourcePath, new LinkOption[0]) ? Collections.singleton(sourcePath.toString()) : Collections.emptySet();
        } else {
            projectDirectory = mavenProject.getBasedir().getPath();
            sourcePaths = mavenProject.getCompileSourceRoots().stream().map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(src -> src.toAbsolutePath().toString()).collect(Collectors.toSet());
        }
        Path classesDir = localProject.getClassesDir();
        if (Files.isDirectory(classesDir, new LinkOption[0])) {
            classesPath = classesDir.toAbsolutePath().toString();
        }
        if (Files.isDirectory(resourcesSourcesDir = localProject.getResourcesSourcesDir(), new LinkOption[0])) {
            resourcePath = resourcesSourcesDir.toAbsolutePath().toString();
        }
        DevModeContext.ModuleInfo moduleInfo = new DevModeContext.ModuleInfo(localProject.getArtifactId(), projectDirectory, sourcePaths, classesPath, resourcePath);
        devModeContext.getModules().add(moduleInfo);
    }

    private void addToClassPaths(StringBuilder classPathManifest, DevModeContext classPath, File file) {
        URI uri = file.toPath().toAbsolutePath().toUri();
        try {
            classPath.getClassPath().add(uri.toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String path = uri.getRawPath();
        classPathManifest.append(path);
        if (file.isDirectory()) {
            classPathManifest.append("/");
        }
        classPathManifest.append(" ");
    }
}

