/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.maven.components.MavenVersionEnforcer;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.remotedev.AgentRunner;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;

@Mojo(name="remote-dev", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class RemoteDevMojo
extends AbstractMojo {
    @Parameter(readonly=true, required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private File sourceDir;
    @Parameter(defaultValue="${jvm.args}")
    private String jvmArgs;
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Parameter(defaultValue="TRUE")
    private boolean deleteDevJar;
    @Component
    private MavenVersionEnforcer mavenVersionEnforcer;
    @Component
    private ToolchainManager toolchainManager;

    public ToolchainManager getToolchainManager() {
        return this.toolchainManager;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        Path config;
        this.mavenVersionEnforcer.ensureMavenVersion(this.getLog(), this.session);
        boolean found = MojoUtils.checkProjectForMavenBuildPlugin((MavenProject)this.project);
        if (!found) {
            this.getLog().warn((CharSequence)"The quarkus-maven-plugin build goal was not configured for this project, skipping quarkus:remote-dev as this is assumed to be a support library. If you want to run Quarkus remote-dev on this project make sure the quarkus-maven-plugin is configured with a build goal.");
            return;
        }
        if (!this.sourceDir.isDirectory()) {
            throw new MojoFailureException("The `src/main/java` directory is required, please create it.");
        }
        String resources = null;
        Iterator iterator = this.project.getBuild().getResources().iterator();
        if (iterator.hasNext()) {
            Resource i = (Resource)iterator.next();
            resources = i.getDirectory();
        }
        String classes = this.outputDirectory.getAbsolutePath();
        String sources = this.sourceDir.getAbsolutePath();
        if (resources != null && Files.exists(config = Paths.get(resources, new String[0]).resolve("application.properties"), new LinkOption[0])) {
            try {
                Config built = SmallRyeConfigProviderResolver.instance().getBuilder().addDefaultSources().addDiscoveredConverters().addDiscoveredSources().withSources(new ConfigSource[]{new PropertiesConfigSource(config.toUri().toURL())}).build();
                SmallRyeConfigProviderResolver.instance().registerConfig(built, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Optional url = ConfigProvider.getConfig().getOptionalValue("quarkus.live-reload.url", String.class);
        Optional password = ConfigProvider.getConfig().getOptionalValue("quarkus.live-reload.password", String.class);
        if (!url.isPresent()) {
            throw new MojoFailureException("To use remote-dev you must specify quarkus.live-reload.url");
        }
        if (!password.isPresent()) {
            throw new MojoFailureException("To use remote-dev you must specify quarkus.live-reload.password");
        }
        System.out.println(sources);
        String remotePath = (String)url.get();
        if (remotePath.endsWith("/")) {
            remotePath = remotePath.substring(0, remotePath.length() - 1);
        }
        AgentRunner runner = new AgentRunner(resources, sources, classes, remotePath + "/quarkus/live-reload", (String)password.get());
        runner.run();
        try {
            while (true) {
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

