/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.analytics.dto.segment.TrackEventType;
import io.quarkus.bootstrap.app.ConfiguredClassLoading;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.devmode.DependenciesFilter;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.IncubatingApplicationModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.util.BootstrapUtils;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.DevModeMain;
import io.quarkus.deployment.dev.QuarkusDevModeLauncher;
import io.quarkus.maven.BuildAnalyticsProvider;
import io.quarkus.maven.MavenDevModeLauncher;
import io.quarkus.maven.MojoLogger;
import io.quarkus.maven.QuarkusBootstrapProvider;
import io.quarkus.maven.components.CompilerOptions;
import io.quarkus.maven.components.MavenVersionEnforcer;
import io.quarkus.maven.components.QuarkusWorkspaceProvider;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.LaunchMode;
import io.smallrye.common.expression.Expression;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aesh.readline.terminal.impl.ExecPty;
import org.aesh.readline.terminal.impl.Pty;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.utils.ANSI;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.fusesource.jansi.internal.Kernel32;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="dev", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class DevMojo
extends AbstractMojo {
    private static final Set<String> IGNORED_PHASES = Set.of("pre-clean", "clean", "post-clean");
    private static final List<String> PRE_DEV_MODE_PHASES = List.of("validate", "initialize", "generate-sources", "process-sources", "generate-resources", "process-resources", "compile", "process-classes", "generate-test-sources", "process-test-sources", "generate-test-resources", "process-test-resources", "test-compile");
    private static final String IO_QUARKUS = "io.quarkus";
    private static final String QUARKUS_GENERATE_CODE_GOAL = "generate-code";
    private static final String QUARKUS_GENERATE_CODE_TESTS_GOAL = "generate-code-tests";
    private static final String ORG_APACHE_MAVEN_PLUGINS = "org.apache.maven.plugins";
    private static final String MAVEN_COMPILER_PLUGIN = "maven-compiler-plugin";
    private static final String MAVEN_RESOURCES_PLUGIN = "maven-resources-plugin";
    private static final String MAVEN_TOOLCHAINS_PLUGIN = "maven-toolchains-plugin";
    private static final String ORG_JETBRAINS_KOTLIN = "org.jetbrains.kotlin";
    private static final String KOTLIN_MAVEN_PLUGIN = "kotlin-maven-plugin";
    private static final String BOOTSTRAP_ID = "DevMojo";
    @Parameter(readonly=true, required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${debug}")
    private String debug;
    @Parameter(defaultValue="${open-lang-package}")
    private boolean openJavaLang;
    @Parameter(defaultValue="${add-modules}")
    private List<String> modules;
    @Parameter(defaultValue="${suspend}")
    private String suspend;
    @Parameter(defaultValue="${debugHost}")
    private String debugHost;
    @Parameter(defaultValue="${debugPort}")
    private String debugPort;
    @Parameter(defaultValue="${project.build.directory}")
    private File buildDir;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private File sourceDir;
    @Parameter
    private File workingDir;
    @Parameter(defaultValue="${jvm.args}")
    private String jvmArgs;
    @Parameter(defaultValue="${quarkus.args}")
    private String argsString;
    @Parameter
    private Map<String, String> environmentVariables = Map.of();
    @Parameter
    private Map<String, String> systemProperties = Map.of();
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Parameter(defaultValue="TRUE")
    private boolean deleteDevJar;
    @Component
    private MavenVersionEnforcer mavenVersionEnforcer;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component
    private RepositorySystem repoSystem;
    @Component
    QuarkusWorkspaceProvider workspaceProvider;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true, required=true)
    private List<RemoteRepository> pluginRepos;
    @Parameter(defaultValue="${preventnoverify}")
    private boolean preventnoverify = false;
    @Parameter(defaultValue="${noDeps}")
    private boolean noDeps = false;
    @Parameter
    private List<String> compilerArgs;
    @Parameter
    private List<CompilerOptions> compilerOptions;
    @Parameter(defaultValue="${maven.compiler.release}")
    private String release;
    @Parameter(defaultValue="${maven.compiler.source}")
    private String source;
    @Parameter(defaultValue="${maven.compiler.target}")
    private String target;
    @Parameter(defaultValue="${quarkus.enforceBuildGoal}")
    private boolean enforceBuildGoal = true;
    @Parameter(property="quarkus.warnIfBuildGoalMissing")
    boolean warnIfBuildGoalMissing = true;
    @Component
    private WorkspaceReader wsReader;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private ToolchainManager toolchainManager;
    private Map<ArtifactKey, Plugin> pluginMap;
    @Component
    protected QuarkusBootstrapProvider bootstrapProvider;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    MojoExecution mojoExecution;
    @Component
    BuildAnalyticsProvider analyticsProvider;
    @Parameter(defaultValue="org.codehaus.mojo:flatten-maven-plugin")
    Set<String> skipPlugins;
    private Attributes attributes;
    private int windowsAttributes;
    private boolean windowsAttributesSet;
    private Pty pty;
    private boolean windowsColorSupport;

    protected LaunchMode getLaunchModeClasspath() {
        return LaunchMode.DEVELOPMENT;
    }

    public void setLog(Log log) {
        super.setLog(log);
        MojoLogger.delegate = log;
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        PluginDescriptor pluginDescr;
        Plugin pluginDef;
        if (this.project.getPackaging().equals("pom")) {
            this.getLog().info((CharSequence)"Type of the artifact is POM, skipping dev goal");
            return;
        }
        this.mavenVersionEnforcer.ensureMavenVersion(this.getLog(), this.session);
        this.initToolchain();
        String bootstrapId = this.handleAutoCompile();
        if (this.enforceBuildGoal && !this.isGoalConfigured(pluginDef = this.getConfiguredPluginOrNull((pluginDescr = this.getPluginDescriptor()).getGroupId(), pluginDescr.getArtifactId()), "build")) {
            if (this.warnIfBuildGoalMissing) {
                String currentGoal = this.getCurrentGoal();
                this.getLog().warn((CharSequence)("Skipping " + currentGoal + " as this is assumed to be a support library. To disable this warning set warnIfBuildGoalMissing parameter to false." + System.lineSeparator() + "To enable " + currentGoal + " for this module, make sure the quarkus-maven-plugin configuration includes the build goal or disable the enforceBuildGoal flag (via plugin configuration or via -Dquarkus.enforceBuildGoal=false)."));
            }
            return;
        }
        this.saveTerminalState();
        this.analyticsProvider.buildAnalyticsUserInput(prompt -> {
            System.out.print((String)prompt);
            Scanner scanner = new Scanner(new FilterInputStream(System.in){

                @Override
                public void close() throws IOException {
                }
            });
            try {
                String string = scanner.nextLine();
                scanner.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)"Failed to collect user input for analytics", (Throwable)e);
                    return "";
                }
            }
        });
        try {
            DevModeRunner runner = new DevModeRunner(bootstrapId);
            Map<Path, Long> pomFiles = this.readPomFileTimestamps(runner);
            runner.run();
            long nextCheck = System.currentTimeMillis() + 100L;
            while (true) {
                DevModeRunner newRunner;
                this.suspend = "n";
                long sleep = Math.max(0L, nextCheck - System.currentTimeMillis()) + 1L;
                Thread.sleep(sleep);
                if (System.currentTimeMillis() <= nextCheck) continue;
                nextCheck = System.currentTimeMillis() + 100L;
                if (!runner.alive()) {
                    this.restoreTerminalState();
                    if (!runner.isExpectedExitValue()) {
                        throw new MojoExecutionException("Dev mode process did not complete successfully");
                    }
                    return;
                }
                HashSet<Path> changed = new HashSet<Path>();
                for (Map.Entry<Path, Long> e : pomFiles.entrySet()) {
                    long t = Files.getLastModifiedTime(e.getKey(), new LinkOption[0]).toMillis();
                    if (t <= e.getValue()) continue;
                    changed.add(e.getKey());
                    pomFiles.put(e.getKey(), t);
                }
                if (changed.isEmpty()) continue;
                this.getLog().info((CharSequence)("Changes detected to " + changed + ", restarting dev mode"));
                runner.stop();
                try {
                    bootstrapId = this.handleAutoCompile();
                    newRunner = new DevModeRunner(runner.launcher.getActualDebugPort(), bootstrapId);
                }
                catch (Exception e) {
                    this.getLog().info((CharSequence)"Could not load changed pom.xml file, changes not applied", (Throwable)e);
                    continue;
                }
                newRunner.run();
                runner = newRunner;
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to run", (Throwable)e);
        }
    }

    private void saveTerminalState() {
        try {
            long hConsole;
            if (this.windowsAttributes > 0 && (hConsole = Kernel32.GetStdHandle(Kernel32.STD_INPUT_HANDLE)) != (long)Kernel32.INVALID_HANDLE_VALUE) {
                int[] mode = new int[1];
                this.windowsAttributes = Kernel32.GetConsoleMode(hConsole, mode) == 0 ? -1 : mode[0];
                this.windowsAttributesSet = true;
                int VIRTUAL_TERMINAL_PROCESSING = 4;
                if (Kernel32.SetConsoleMode(hConsole, this.windowsAttributes | 4) != 0) {
                    this.windowsColorSupport = true;
                }
            }
        }
        catch (Throwable t) {
            try {
                Pty pty = ExecPty.current();
                this.attributes = pty.getAttr();
                this.pty = pty;
            }
            catch (Exception e) {
                this.getLog().debug((CharSequence)"Failed to get a local tty", (Throwable)e);
            }
        }
    }

    private void restoreTerminalState() {
        if (this.windowsAttributesSet) {
            long hConsole = Kernel32.GetStdHandle(Kernel32.STD_INPUT_HANDLE);
            if (hConsole != (long)Kernel32.INVALID_HANDLE_VALUE) {
                Kernel32.SetConsoleMode(hConsole, this.windowsAttributes);
            }
        } else {
            if (this.attributes == null || this.pty == null) {
                return;
            }
            Pty finalPty = this.pty;
            try (Pty pty = finalPty;){
                finalPty.setAttr(this.attributes);
                int height = finalPty.getSize().getHeight();
                String sb = ANSI.MAIN_BUFFER + "\u001b[?25h\u001b[0m\u001b[" + height + ";0H";
                finalPty.getSlaveOutput().write(sb.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Error restoring console state", (Throwable)e);
            }
        }
    }

    private String handleAutoCompile() throws MojoExecutionException {
        String goal;
        Object p2;
        String goal2;
        List<String> goals = this.session.getGoals();
        if (goals.isEmpty() && !StringUtils.isEmpty((CharSequence)this.project.getDefaultGoal())) {
            goals = List.of(StringUtils.split((String)this.project.getDefaultGoal()));
        }
        String currentGoal = this.getCurrentGoal();
        int latestHandledPhaseIndex = -1;
        Iterator iterator = goals.iterator();
        while (iterator.hasNext() && !(goal2 = (String)iterator.next()).endsWith(currentGoal)) {
            if (goal2.indexOf(58) >= 0 || IGNORED_PHASES.contains(goal2)) continue;
            int i = PRE_DEV_MODE_PHASES.indexOf(goal2);
            if (i < 0 || i == PRE_DEV_MODE_PHASES.size() - 1) {
                return null;
            }
            if (i <= latestHandledPhaseIndex) continue;
            latestHandledPhaseIndex = i;
        }
        String quarkusPluginId = this.getPluginDescriptor().getId();
        HashMap<String, List> phaseExecutions = new HashMap<String, List>();
        HashMap<String, Object> pluginPrefixes = new HashMap<String, Object>();
        String bootstrapId = BOOTSTRAP_ID;
        for (Object p2 : this.project.getBuildPlugins()) {
            if (p2.getExecutions().isEmpty()) continue;
            if (this.skipPlugins.contains(p2.getKey())) {
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Skipping " + p2.getId() + " execution according to skipPlugins value"));
                continue;
            }
            for (PluginExecution e : p2.getExecutions()) {
                if (e.getPhase() != null && !PRE_DEV_MODE_PHASES.contains(e.getPhase())) {
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)("Skipping " + e.getId() + " of " + p2.getId()));
                    continue;
                }
                String goalPrefix = null;
                if (!e.getGoals().isEmpty()) {
                    goalPrefix = this.getMojoDescriptor((Plugin)p2, (String)e.getGoals().get(0)).getPluginDescriptor().getGoalPrefix();
                    if (this.skipPlugins.contains(goalPrefix)) {
                        if (!this.getLog().isDebugEnabled()) continue;
                        this.getLog().debug((CharSequence)("Skipping " + goalPrefix + " execution according to skipPlugins value"));
                        continue;
                    }
                    pluginPrefixes.put(goalPrefix, p2);
                    pluginPrefixes.put(p2.getId(), p2);
                }
                if (e.getPhase() != null) {
                    phaseExecutions.computeIfAbsent(e.getPhase(), k -> new ArrayList()).add(new PluginExec((Plugin)p2, goalPrefix, e));
                    continue;
                }
                for (String goal3 : e.getGoals()) {
                    PluginExecution clone;
                    if (goal3.equals(QUARKUS_GENERATE_CODE_GOAL) && p2.getId().equals(quarkusPluginId)) {
                        clone = e.clone();
                        clone.setGoals(List.of(QUARKUS_GENERATE_CODE_GOAL));
                        phaseExecutions.computeIfAbsent("compile", k -> new ArrayList()).add(0, new PluginExec((Plugin)p2, goalPrefix, clone));
                        bootstrapId = e.getId();
                        continue;
                    }
                    if (goal3.equals(QUARKUS_GENERATE_CODE_TESTS_GOAL) && p2.getId().equals(quarkusPluginId)) {
                        clone = e.clone();
                        clone.setGoals(List.of(QUARKUS_GENERATE_CODE_TESTS_GOAL));
                        phaseExecutions.computeIfAbsent("test-compile", k -> new ArrayList()).add(0, new PluginExec((Plugin)p2, goalPrefix, clone));
                        continue;
                    }
                    MojoDescriptor mojoDescr = this.getMojoDescriptor((Plugin)p2, goal3);
                    if (mojoDescr.getPhase() != null) {
                        phaseExecutions.computeIfAbsent(mojoDescr.getPhase(), k -> new ArrayList()).add(new PluginExec((Plugin)p2, goalPrefix, e));
                        continue;
                    }
                    this.getLog().warn((CharSequence)("Failed to determine the lifecycle phase for " + p2.getId() + ":" + goal3));
                }
            }
        }
        HashMap executedPluginGoals = new HashMap();
        p2 = goals.iterator();
        while (p2.hasNext() && !(goal = (String)p2.next()).endsWith(currentGoal)) {
            int colon = goal.lastIndexOf(58);
            if (colon < 0) continue;
            Plugin plugin = (Plugin)pluginPrefixes.get(goal.substring(0, colon));
            if (plugin == null) {
                this.getLog().warn((CharSequence)("Failed to locate plugin for " + goal));
                continue;
            }
            executedPluginGoals.computeIfAbsent(plugin.getId(), k -> new ArrayList()).add(goal.substring(colon + 1));
        }
        Map<String, String> quarkusGoalParams = Map.of("mode", LaunchMode.DEVELOPMENT.name(), "closeBootstrappedApp", "false", "bootstrapId", bootstrapId);
        for (int phaseIndex = latestHandledPhaseIndex + 1; phaseIndex < PRE_DEV_MODE_PHASES.size(); ++phaseIndex) {
            List executions = (List)phaseExecutions.get(PRE_DEV_MODE_PHASES.get(phaseIndex));
            if (executions == null) continue;
            for (PluginExec pe : executions) {
                List executedGoals = executedPluginGoals.getOrDefault(pe.plugin.getId(), List.of());
                for (String goal4 : pe.execution.getGoals()) {
                    if (executedGoals.contains(goal4)) continue;
                    try {
                        this.executeGoal(pe, goal4, pe.getPluginId().equals(quarkusPluginId) ? quarkusGoalParams : Map.of());
                    }
                    catch (Throwable t) {
                        if (goal4.equals("testCompile")) {
                            this.getLog().error((CharSequence)"Test compile failed, you will need to fix your tests before you can use continuous testing", t);
                            continue;
                        }
                        throw t;
                    }
                }
            }
        }
        return bootstrapId;
    }

    private String getCurrentGoal() {
        return this.mojoExecution.getMojoDescriptor().getPluginDescriptor().getGoalPrefix() + ":" + this.mojoExecution.getGoal();
    }

    private PluginDescriptor getPluginDescriptor() {
        return this.mojoExecution.getMojoDescriptor().getPluginDescriptor();
    }

    private void initToolchain() throws MojoExecutionException {
        Plugin plugin = this.getConfiguredPluginOrNull(ORG_APACHE_MAVEN_PLUGINS, MAVEN_TOOLCHAINS_PLUGIN);
        if (!this.isGoalConfigured(plugin, "toolchain")) {
            return;
        }
        this.executeGoal(new PluginExec(plugin, null, null), "toolchain", Map.of());
    }

    private void executeGoal(PluginExec pluginExec, String goal, Map<String, String> params) throws MojoExecutionException {
        StringBuilder msg = new StringBuilder();
        msg.append("Invoking ").append(pluginExec.getPrefix()).append(":").append(pluginExec.plugin.getVersion()).append(":").append(goal);
        if (pluginExec.getExecutionId() != null) {
            msg.append(" (").append(pluginExec.getExecutionId()).append(")");
        }
        msg.append(" @ ").append(this.project.getArtifactId());
        this.getLog().info((CharSequence)msg.toString());
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)pluginExec.plugin.getGroupId()), (String)MojoExecutor.artifactId((String)pluginExec.plugin.getArtifactId()), (String)MojoExecutor.version((String)pluginExec.plugin.getVersion()), (List)pluginExec.plugin.getDependencies()), (String)MojoExecutor.goal((String)goal), (Xpp3Dom)this.getPluginConfig(pluginExec.plugin, pluginExec.getExecutionId(), goal, params), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    private List<String> readAnnotationProcessors(Xpp3Dom pluginConfig) {
        if (pluginConfig == null) {
            return List.of();
        }
        Xpp3Dom annotationProcessors = pluginConfig.getChild("annotationProcessors");
        if (annotationProcessors == null) {
            return List.of();
        }
        Xpp3Dom[] processors = annotationProcessors.getChildren("annotationProcessor");
        if (processors.length == 0) {
            return List.of();
        }
        ArrayList<String> ret = new ArrayList<String>(processors.length);
        for (Xpp3Dom processor : processors) {
            ret.add(processor.getValue());
        }
        return ret;
    }

    private Set<File> readAnnotationProcessorPaths(Xpp3Dom pluginConfig) throws MojoExecutionException {
        if (pluginConfig == null) {
            return Set.of();
        }
        Xpp3Dom annotationProcessorPaths = pluginConfig.getChild("annotationProcessorPaths");
        if (annotationProcessorPaths == null) {
            return Set.of();
        }
        List<Dependency> versionConstraints = this.getAnnotationProcessorPathsDepMgmt(pluginConfig);
        Xpp3Dom[] paths = annotationProcessorPaths.getChildren("path");
        LinkedHashSet<File> elements = new LinkedHashSet<File>();
        try {
            List<Dependency> dependencies = this.convertToDependencies(paths);
            CollectRequest collectRequest = new CollectRequest(dependencies, versionConstraints, this.project.getRemoteProjectRepositories());
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setCollectRequest(collectRequest);
            DependencyResult dependencyResult = this.repoSystem.resolveDependencies(this.session.getRepositorySession(), dependencyRequest);
            for (ArtifactResult resolved : dependencyResult.getArtifactResults()) {
                elements.add(resolved.getArtifact().getFile());
            }
            return elements;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Resolution of annotationProcessorPath dependencies failed: " + e.getLocalizedMessage(), e);
        }
    }

    private List<Dependency> getAnnotationProcessorPathsDepMgmt(Xpp3Dom pluginConfig) {
        Xpp3Dom useDepMgmt = pluginConfig.getChild("annotationProcessorPathsUseDepMgmt");
        if (useDepMgmt == null || !Boolean.parseBoolean(useDepMgmt.getValue())) {
            return List.of();
        }
        DependencyManagement dm = this.project.getDependencyManagement();
        if (dm == null) {
            return List.of();
        }
        return this.getProjectAetherDependencyManagement();
    }

    private List<Dependency> convertToDependencies(Xpp3Dom[] paths) throws MojoExecutionException {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (Xpp3Dom path : paths) {
            String type = this.getValue(path, "type", "jar");
            ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(type);
            DefaultArtifact artifact = new DefaultArtifact(this.getValue(path, "groupId", null), this.getValue(path, "artifactId", null), this.getValue(path, "classifier", null), handler.getExtension(), this.getValue(path, "version", null));
            if (this.toNullIfEmpty(artifact.getVersion()) == null) {
                artifact = artifact.setVersion(this.getAnnotationProcessorPathVersion((org.eclipse.aether.artifact.Artifact)artifact));
            }
            Set<Exclusion> exclusions = this.convertToAetherExclusions(path.getChild("exclusions"));
            dependencies.add(new Dependency((org.eclipse.aether.artifact.Artifact)artifact, "runtime", Boolean.valueOf(false), exclusions));
        }
        return dependencies;
    }

    private String getAnnotationProcessorPathVersion(org.eclipse.aether.artifact.Artifact annotationProcessorPath) throws MojoExecutionException {
        List<org.apache.maven.model.Dependency> managedDependencies = this.getProjectManagedDependencies();
        return this.findManagedVersion(annotationProcessorPath, managedDependencies).orElseThrow(() -> new MojoExecutionException(String.format("Cannot find version for annotation processor path '%s'. The version needs to be either provided directly in the plugin configuration or via dependency management.", annotationProcessorPath)));
    }

    private Optional<String> findManagedVersion(org.eclipse.aether.artifact.Artifact artifact, List<org.apache.maven.model.Dependency> managedDependencies) {
        return managedDependencies.stream().filter(dep -> Objects.equals(dep.getGroupId(), artifact.getGroupId()) && Objects.equals(dep.getArtifactId(), artifact.getArtifactId()) && Objects.equals(dep.getClassifier(), this.toNullIfEmpty(artifact.getClassifier())) && Objects.equals(dep.getType(), this.toNullIfEmpty(artifact.getExtension()))).findAny().map(org.apache.maven.model.Dependency::getVersion);
    }

    private String toNullIfEmpty(String value) {
        if (value != null && value.isBlank()) {
            return null;
        }
        return value;
    }

    private List<org.apache.maven.model.Dependency> getProjectManagedDependencies() {
        DependencyManagement dependencyManagement = this.project.getDependencyManagement();
        if (dependencyManagement == null || dependencyManagement.getDependencies() == null) {
            return List.of();
        }
        return dependencyManagement.getDependencies();
    }

    private String getValue(Xpp3Dom path, String element, String defaultValue) {
        Xpp3Dom child = path.getChild(element);
        if (child == null) {
            return defaultValue;
        }
        return child.getValue();
    }

    private Set<Exclusion> convertToAetherExclusions(Xpp3Dom exclusions) {
        if (exclusions == null) {
            return Set.of();
        }
        HashSet<Exclusion> aetherExclusions = new HashSet<Exclusion>();
        for (Xpp3Dom exclusion : exclusions.getChildren("exclusion")) {
            Exclusion aetherExclusion = new Exclusion(this.getValue(exclusion, "groupId", null), this.getValue(exclusion, "artifactId", null), this.getValue(exclusion, "classifier", null), this.getValue(exclusion, "extension", "jar"));
            aetherExclusions.add(aetherExclusion);
        }
        return aetherExclusions;
    }

    private boolean isGoalConfigured(Plugin plugin, String goal) {
        if (plugin == null) {
            return false;
        }
        for (PluginExecution pluginExecution : plugin.getExecutions()) {
            if (!pluginExecution.getGoals().contains(goal)) continue;
            return true;
        }
        return false;
    }

    private Xpp3Dom getPluginConfig(Plugin plugin, String executionId, String goal, Map<String, String> params) throws MojoExecutionException {
        Xpp3Dom mergedConfig = null;
        if (!plugin.getExecutions().isEmpty()) {
            for (PluginExecution exec : plugin.getExecutions()) {
                if (exec.getConfiguration() == null || !exec.getGoals().contains(goal) || !DevMojo.matchesExecution(executionId, exec.getId())) continue;
                mergedConfig = mergedConfig == null ? (Xpp3Dom)exec.getConfiguration() : Xpp3Dom.mergeXpp3Dom((Xpp3Dom)mergedConfig, (Xpp3Dom)((Xpp3Dom)exec.getConfiguration()), (Boolean)true);
            }
        }
        if ((Xpp3Dom)plugin.getConfiguration() != null) {
            mergedConfig = mergedConfig == null ? (Xpp3Dom)plugin.getConfiguration() : Xpp3Dom.mergeXpp3Dom((Xpp3Dom)mergedConfig, (Xpp3Dom)((Xpp3Dom)plugin.getConfiguration()), (Boolean)true);
        }
        Xpp3Dom configuration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]);
        if (mergedConfig != null) {
            Set supportedParams = null;
            for (Xpp3Dom child : mergedConfig.getChildren()) {
                if (child.getName().startsWith("test")) continue;
                if (supportedParams == null) {
                    supportedParams = this.getMojoDescriptor(plugin, goal).getParameterMap().keySet();
                }
                if (!supportedParams.contains(child.getName())) continue;
                configuration.addChild(child);
            }
        }
        for (Map.Entry<String, String> param : params.entrySet()) {
            Xpp3Dom p = new Xpp3Dom(param.getKey());
            p.setValue(param.getValue());
            configuration.addChild(p);
        }
        return configuration;
    }

    private static boolean matchesExecution(String currentExecutionId, String executionId) {
        if (currentExecutionId == null) {
            return true;
        }
        return executionId == null || currentExecutionId.equalsIgnoreCase(executionId);
    }

    private MojoDescriptor getMojoDescriptor(Plugin plugin, String goal) throws MojoExecutionException {
        try {
            return this.pluginManager.getMojoDescriptor(plugin, goal, this.pluginRepos, this.repoSession);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to obtain descriptor for Maven plugin " + plugin.getId() + " goal " + goal, e);
        }
    }

    private Plugin getConfiguredPluginOrNull(String groupId, String artifactId) {
        if (this.pluginMap == null) {
            this.pluginMap = new HashMap<ArtifactKey, Plugin>();
            for (Plugin p : this.project.getBuildPlugins()) {
                this.pluginMap.put(ArtifactKey.ga((String)p.getGroupId(), (String)p.getArtifactId()), p);
            }
        }
        return this.pluginMap.get(ArtifactKey.ga((String)groupId, (String)artifactId));
    }

    private Map<Path, Long> readPomFileTimestamps(DevModeRunner runner) throws IOException {
        HashMap<Path, Long> ret = new HashMap<Path, Long>();
        for (Path i : runner.pomFiles()) {
            ret.put(i, Files.getLastModifiedTime(i, new LinkOption[0]).toMillis());
        }
        return ret;
    }

    private String getSourceEncoding() {
        Object sourceEncodingProperty = this.project.getProperties().get("project.build.sourceEncoding");
        if (sourceEncodingProperty != null) {
            return (String)sourceEncodingProperty;
        }
        return null;
    }

    private void addProject(MavenDevModeLauncher.Builder builder, ResolvedDependency module, boolean root) throws Exception {
        Path sourceParent;
        Set<Path> testSourcePaths;
        Set<Path> sourcePaths;
        String projectDirectory;
        if (!module.isJar()) {
            return;
        }
        String classesPath = null;
        String generatedSourcesPath = null;
        String testClassesPath = null;
        List activeProfiles = List.of();
        Object mavenProject = null;
        if (module.getClassifier().isEmpty()) {
            for (Object p : this.session.getAllProjects()) {
                if (!module.getArtifactId().equals(p.getArtifactId()) || !module.getGroupId().equals(p.getGroupId()) || !module.getVersion().equals(p.getVersion())) continue;
                mavenProject = p;
                break;
            }
        }
        ArtifactSources sources = module.getSources();
        if (mavenProject == null) {
            if (sources == null) {
                this.getLog().debug((CharSequence)("Local dependency " + module.toCompactCoords() + " does not appear to have any sources"));
                return;
            }
            projectDirectory = module.getWorkspaceModule().getModuleDir().getAbsolutePath();
            sourcePaths = new LinkedHashSet();
            for (Object src : sources.getSourceDirs()) {
                for (Iterator p : src.getSourceTree().getRoots()) {
                    sourcePaths.add(p.toAbsolutePath());
                }
            }
            testSourcePaths = new LinkedHashSet();
            ArtifactSources testSources = module.getWorkspaceModule().getTestSources();
            if (testSources != null) {
                for (SourceDir src : testSources.getSourceDirs()) {
                    for (Path p : src.getSourceTree().getRoots()) {
                        testSourcePaths.add(p.toAbsolutePath());
                    }
                }
            }
        } else {
            projectDirectory = mavenProject.getBasedir().getPath();
            sourcePaths = mavenProject.getCompileSourceRoots().stream().map(x$0 -> Path.of(x$0, new String[0])).map(Path::toAbsolutePath).collect(Collectors.toCollection(LinkedHashSet::new));
            testSourcePaths = mavenProject.getTestCompileSourceRoots().stream().map(x$0 -> Path.of(x$0, new String[0])).map(Path::toAbsolutePath).collect(Collectors.toCollection(LinkedHashSet::new));
            activeProfiles = mavenProject.getActiveProfiles();
        }
        if (sourcePaths.isEmpty()) {
            if (sources == null || sources.getResourceDirs() == null) {
                throw new MojoExecutionException("Local dependency " + module.toCompactCoords() + " does not appear to have any sources");
            }
            sourceParent = ((SourceDir)sources.getResourceDirs().iterator().next()).getDir().toAbsolutePath().getParent();
        } else {
            sourceParent = ((Path)sourcePaths.iterator().next()).toAbsolutePath().getParent();
        }
        Path classesDir = null;
        LinkedHashSet<Path> resourcePaths = new LinkedHashSet<Path>();
        if (sources != null) {
            SourceDir firstSourceDir = (SourceDir)sources.getSourceDirs().iterator().next();
            classesDir = firstSourceDir.getOutputDir().toAbsolutePath();
            if (firstSourceDir.getAptSourcesDir() != null) {
                generatedSourcesPath = firstSourceDir.getAptSourcesDir().toAbsolutePath().toString();
            }
            if (Files.isDirectory(classesDir, new LinkOption[0])) {
                classesPath = classesDir.toString();
            }
            for (SourceDir src : sources.getResourceDirs()) {
                for (Path p : src.getSourceTree().getRoots()) {
                    resourcePaths.add(p.toAbsolutePath());
                }
            }
        }
        if (module.getWorkspaceModule().hasTestSources()) {
            Path testClassesDir = ((SourceDir)module.getWorkspaceModule().getTestSources().getSourceDirs().iterator().next()).getOutputDir().toAbsolutePath();
            testClassesPath = testClassesDir.toString();
        }
        LinkedHashSet<Path> testResourcePaths = new LinkedHashSet<Path>();
        ArtifactSources testSources = module.getWorkspaceModule().getTestSources();
        if (testSources != null) {
            for (SourceDir src : testSources.getResourceDirs()) {
                for (Path p : src.getSourceTree().getRoots()) {
                    testResourcePaths.add(p.toAbsolutePath());
                }
            }
        }
        for (Profile profile : activeProfiles) {
            BuildBase build = profile.getBuild();
            if (build == null) continue;
            resourcePaths.addAll(build.getResources().stream().map(FileSet::getDirectory).map(x$0 -> Path.of(x$0, new String[0])).map(Path::toAbsolutePath).collect(Collectors.toList()));
            testResourcePaths.addAll(build.getTestResources().stream().map(FileSet::getDirectory).map(x$0 -> Path.of(x$0, new String[0])).map(Path::toAbsolutePath).collect(Collectors.toList()));
        }
        if (!(classesPath != null || sourcePaths.isEmpty() && resourcePaths.isEmpty())) {
            throw new MojoExecutionException("Hot reloadable dependency " + module.getWorkspaceModule().getId() + " has not been compiled yet (the classes directory " + (Comparable)(classesDir == null ? "" : classesDir) + " does not exist)");
        }
        Path targetDir = Path.of(this.project.getBuild().getDirectory(), new String[0]);
        if (generatedSourcesPath != null && Files.notExists(Path.of(generatedSourcesPath, new String[0]), new LinkOption[0])) {
            Files.createDirectories(Path.of(generatedSourcesPath, new String[0]), new FileAttribute[0]);
        }
        DevModeContext.ModuleInfo moduleInfo = new DevModeContext.ModuleInfo.Builder().setArtifactKey(module.getKey()).setProjectDirectory(projectDirectory).setSourcePaths((PathCollection)PathList.from(sourcePaths)).setClassesPath(classesPath).setGeneratedSourcesPath(generatedSourcesPath).setResourcesOutputPath(classesPath).setResourcePaths((PathCollection)PathList.from(resourcePaths)).setSourceParents((PathCollection)PathList.of((Path[])new Path[]{sourceParent.toAbsolutePath()})).setPreBuildOutputDir(targetDir.resolve("generated-sources").toAbsolutePath().toString()).setTargetDir(targetDir.toAbsolutePath().toString()).setTestSourcePaths((PathCollection)PathList.from(testSourcePaths)).setTestClassesPath(testClassesPath).setTestResourcesOutputPath(testClassesPath).setTestResourcePaths((PathCollection)PathList.from(testResourcePaths)).build();
        if (root) {
            builder.mainModule(moduleInfo);
        } else {
            builder.dependency(moduleInfo);
        }
    }

    private QuarkusDevModeLauncher newLauncher(String actualDebugPort, String bootstrapId) throws Exception {
        BootstrapMavenContextConfig mvnConfig;
        Xpp3Dom compilerPluginArgsConfiguration;
        Toolchain toolchain;
        String java = null;
        if (this.toolchainManager != null && (toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session)) != null) {
            java = toolchain.findTool("java");
            this.getLog().info((CharSequence)("JVM from toolchain: " + java));
        }
        MavenDevModeLauncher.Builder builder = (MavenDevModeLauncher.Builder)((MavenDevModeLauncher.Builder)((MavenDevModeLauncher.Builder)((MavenDevModeLauncher.Builder)((MavenDevModeLauncher.Builder)((MavenDevModeLauncher.Builder)((MavenDevModeLauncher.Builder)((MavenDevModeLauncher.Builder)MavenDevModeLauncher.builder(java, this.getLog()).preventnoverify(this.preventnoverify)).buildDir(this.buildDir)).outputDir(this.outputDirectory)).suspend(this.suspend)).debug(this.debug)).debugHost(this.debugHost)).debugPort(actualDebugPort)).deleteDevJar(this.deleteDevJar);
        this.setJvmArgs(builder);
        if (this.windowsColorSupport) {
            builder.jvmArgs("-Dio.quarkus.force-color-support=true");
        }
        if (this.openJavaLang) {
            builder.jvmArgs("--add-opens");
            builder.jvmArgs("java.base/java.lang=ALL-UNNAMED");
        }
        if (this.modules != null && !this.modules.isEmpty()) {
            String mods = String.join((CharSequence)",", this.modules);
            builder.jvmArgs("--add-modules");
            builder.jvmArgs(mods);
        }
        builder.projectDir(this.project.getFile().getParentFile());
        Properties projectProperties = this.project.getProperties();
        HashMap<Object, String> effectiveProperties = new HashMap<Object, String>();
        for (String string : projectProperties.stringPropertyNames()) {
            if (!string.startsWith("quarkus.")) continue;
            effectiveProperties.put(string, projectProperties.getProperty(string));
        }
        ArrayList effectivePropertyValues = new ArrayList(effectiveProperties.values());
        for (String value : effectivePropertyValues) {
            for (Xpp3Dom[] reference : Expression.compile((String)value, (Expression.Flag[])new Expression.Flag[]{Expression.Flag.LENIENT_SYNTAX, Expression.Flag.NO_TRIM}).getReferencedStrings()) {
                String referenceValue = this.session.getUserProperties().getProperty((String)reference);
                if (referenceValue != null) {
                    effectiveProperties.put(reference, referenceValue);
                    continue;
                }
                referenceValue = projectProperties.getProperty((String)reference);
                if (referenceValue == null) continue;
                effectiveProperties.put(reference, referenceValue);
            }
        }
        builder.buildSystemProperties(effectiveProperties);
        builder.applicationName(this.project.getArtifactId());
        builder.applicationVersion(this.project.getVersion());
        builder.sourceEncoding(this.getSourceEncoding());
        if (this.compilerOptions != null) {
            for (CompilerOptions compilerOption : this.compilerOptions) {
                builder.compilerOptions(compilerOption.getName(), compilerOption.getArgs());
            }
        }
        Optional<Xpp3Dom> optional = this.findCompilerPluginConfiguration();
        if (this.compilerArgs != null) {
            builder.compilerOptions("java", this.compilerArgs);
        } else if (optional.isPresent() && (compilerPluginArgsConfiguration = optional.get().getChild("compilerArgs")) != null) {
            ArrayList<String> compilerPluginArgs = new ArrayList<String>();
            for (Xpp3Dom argConfiguration : compilerPluginArgsConfiguration.getChildren()) {
                compilerPluginArgs.add(argConfiguration.getValue());
            }
            if (compilerPluginArgsConfiguration.getValue() != null && !compilerPluginArgsConfiguration.getValue().isEmpty()) {
                compilerPluginArgs.add(compilerPluginArgsConfiguration.getValue().trim());
            }
            builder.compilerOptions("java", compilerPluginArgs);
        }
        if (this.release != null) {
            builder.releaseJavaVersion(this.release);
        } else if (optional.isPresent()) {
            this.applyCompilerFlag(optional, "release", arg_0 -> ((MavenDevModeLauncher.Builder)builder).releaseJavaVersion(arg_0));
        }
        if (this.source != null) {
            builder.sourceJavaVersion(this.source);
        } else if (optional.isPresent()) {
            this.applyCompilerFlag(optional, "source", arg_0 -> ((MavenDevModeLauncher.Builder)builder).sourceJavaVersion(arg_0));
        }
        if (this.target != null) {
            builder.targetJavaVersion(this.target);
        } else if (optional.isPresent()) {
            this.applyCompilerFlag(optional, "target", arg_0 -> ((MavenDevModeLauncher.Builder)builder).targetJavaVersion(arg_0));
        }
        this.setKotlinSpecificFlags(builder);
        this.setAnnotationProcessorFlags(builder);
        Path appModelLocation = this.resolveSerializedModelLocation();
        ApplicationModel appModel = this.bootstrapProvider.getResolvedApplicationModel(QuarkusBootstrapProvider.getProjectId(this.project), this.getLaunchModeClasspath(), bootstrapId);
        if (appModel != null) {
            this.bootstrapProvider.close();
        } else {
            mvnConfig = BootstrapMavenContext.config().setUserSettings(this.session.getRequest().getUserSettingsFile()).setRemoteRepositories(this.repos).setWorkspaceDiscovery(true).setPreferPomsFromWorkspace(true).setCurrentProject(this.project.getBasedir().toString());
            BootstrapMavenContext mvnCtx = this.workspaceProvider.createMavenContext(mvnConfig);
            appModel = new BootstrapAppModelResolver(new MavenArtifactResolver(mvnCtx)).setDevMode(true).setTest(LaunchMode.TEST.equals((Object)this.getLaunchModeClasspath())).setCollectReloadableDependencies(!this.noDeps).setIncubatingModelResolver(IncubatingApplicationModelResolver.isIncubatingEnabled((Properties)this.project.getProperties())).resolveModel((ArtifactCoords)mvnCtx.getCurrentProject().getAppArtifact());
        }
        BootstrapUtils.serializeAppModel((ApplicationModel)appModel, (Path)appModelLocation);
        builder.jvmArgs("-Dquarkus-internal.serialized-app-model.path=" + appModelLocation);
        if (this.noDeps) {
            this.addProject(builder, appModel.getAppArtifact(), true);
            appModel.getApplicationModule().getBuildFiles().forEach(arg_0 -> ((MavenDevModeLauncher.Builder)builder).watchedBuildFile(arg_0));
            builder.localArtifact(ArtifactKey.of((String)this.project.getGroupId(), (String)this.project.getArtifactId(), null, (String)"jar"));
        } else {
            mvnConfig = DependenciesFilter.getReloadableModules((ApplicationModel)appModel).iterator();
            while (mvnConfig.hasNext()) {
                ResolvedDependency project;
                this.addProject(builder, project, (project = (ResolvedDependency)mvnConfig.next()) == appModel.getAppArtifact());
                project.getWorkspaceModule().getBuildFiles().forEach(arg_0 -> ((MavenDevModeLauncher.Builder)builder).watchedBuildFile(arg_0));
                builder.localArtifact(project.getKey());
            }
        }
        this.addQuarkusDevModeDeps(builder, appModel);
        HashSet<Path> resourceDirs = new HashSet<Path>();
        for (Resource resource : this.project.getResources()) {
            String dir = resource.getDirectory();
            Path path = Paths.get(dir, new String[0]);
            resourceDirs.add(path);
        }
        Collection configuredParentFirst = ConfiguredClassLoading.builder().setApplicationModel(appModel).setApplicationRoot((PathCollection)PathsCollection.from(resourceDirs)).setMode(QuarkusBootstrap.Mode.DEV).build().getParentFirstArtifacts();
        for (Artifact appDep : this.project.getArtifacts()) {
            ArtifactKey key = ArtifactKey.of((String)appDep.getGroupId(), (String)appDep.getArtifactId(), (String)appDep.getClassifier(), (String)appDep.getArtifactHandler().getExtension());
            if (builder.isLocal(key) || !configuredParentFirst.contains(key)) continue;
            builder.classpathEntry(key, appDep.getFile());
        }
        builder.baseName(this.project.getBuild().getFinalName());
        this.modifyDevModeContext(builder);
        if (this.argsString != null) {
            builder.applicationArgs(this.argsString);
        }
        this.analyticsProvider.sendAnalytics(TrackEventType.DEV_MODE, appModel, Collections.emptyMap(), this.buildDir);
        return builder.build();
    }

    private void setJvmArgs(MavenDevModeLauncher.Builder builder) throws Exception {
        String jvmArgs = this.jvmArgs;
        if (!this.systemProperties.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            if (jvmArgs != null) {
                buf.append(jvmArgs);
            }
            for (Map.Entry<String, String> prop : this.systemProperties.entrySet()) {
                buf.append(" -D").append(prop.getKey()).append("=\"").append(prop.getValue()).append("\"");
            }
            jvmArgs = buf.toString();
        }
        if (jvmArgs != null) {
            builder.jvmArgs(Arrays.asList(CommandLineUtils.translateCommandline((String)jvmArgs)));
        }
    }

    private void applyCompilerFlag(Optional<Xpp3Dom> compilerPluginConfiguration, String flagName, Consumer<String> builderCall) {
        compilerPluginConfiguration.map(cfg -> cfg.getChild(flagName)).map(Xpp3Dom::getValue).map(String::trim).filter(Predicate.not(String::isEmpty)).ifPresent(builderCall);
    }

    private void addQuarkusDevModeDeps(MavenDevModeLauncher.Builder builder, ApplicationModel appModel) throws MojoExecutionException, DependencyResolutionException {
        ResolvedDependency coreDeployment = null;
        for (ResolvedDependency d : appModel.getDependencies()) {
            if (!d.isDeploymentCp() || !d.getArtifactId().equals("quarkus-core-deployment") || !d.getGroupId().equals(IO_QUARKUS)) continue;
            coreDeployment = d;
            break;
        }
        if (coreDeployment == null) {
            throw new MojoExecutionException("Failed to locate io.quarkus:quarkus-core-deployment on the application build classpath");
        }
        String pomPropsPath = "META-INF/maven/io.quarkus/quarkus-bootstrap-maven-resolver/pom.properties";
        InputStream devModePomPropsIs = DevModeMain.class.getClassLoader().getResourceAsStream("META-INF/maven/io.quarkus/quarkus-bootstrap-maven-resolver/pom.properties");
        if (devModePomPropsIs == null) {
            throw new MojoExecutionException("Failed to locate META-INF/maven/io.quarkus/quarkus-bootstrap-maven-resolver/pom.properties on the classpath");
        }
        Properties devModeProps = new Properties();
        try (InputStream is = devModePomPropsIs;){
            devModeProps.load(is);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load META-INF/maven/io.quarkus/quarkus-bootstrap-maven-resolver/pom.properties from the classpath", (Exception)e);
        }
        String devModeGroupId = devModeProps.getProperty("groupId");
        if (devModeGroupId == null) {
            throw new MojoExecutionException("Classpath resource META-INF/maven/io.quarkus/quarkus-bootstrap-maven-resolver/pom.properties is missing groupId");
        }
        String devModeArtifactId = devModeProps.getProperty("artifactId");
        if (devModeArtifactId == null) {
            throw new MojoExecutionException("Classpath resource META-INF/maven/io.quarkus/quarkus-bootstrap-maven-resolver/pom.properties is missing artifactId");
        }
        String devModeVersion = devModeProps.getProperty("version");
        if (devModeVersion == null) {
            throw new MojoExecutionException("Classpath resource META-INF/maven/io.quarkus/quarkus-bootstrap-maven-resolver/pom.properties is missing version");
        }
        DefaultArtifact devModeJar = new DefaultArtifact(devModeGroupId, devModeArtifactId, "jar", devModeVersion);
        DependencyResult cpRes = this.repoSystem.resolveDependencies(this.repoSession, new DependencyRequest().setCollectRequest(new CollectRequest().setRootArtifact((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(IO_QUARKUS, "quarkus-devmode-alias", "jar", "1.0")).setManagedDependencies(this.getProjectAetherDependencyManagement()).setDependencies(List.of(new Dependency((org.eclipse.aether.artifact.Artifact)devModeJar, "runtime"), new Dependency((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(coreDeployment.getGroupId(), coreDeployment.getArtifactId(), coreDeployment.getClassifier(), coreDeployment.getType(), coreDeployment.getVersion()), "runtime"))).setRepositories(this.repos)));
        for (ArtifactResult appDep : cpRes.getArtifactResults()) {
            org.eclipse.aether.artifact.Artifact a = appDep.getArtifact();
            if (a.getArtifactId().equals("quarkus-ide-launcher") && a.getGroupId().equals(IO_QUARKUS)) continue;
            if (a.getArtifactId().equals("quarkus-class-change-agent") && a.getGroupId().equals(IO_QUARKUS)) {
                builder.jvmArgs("-javaagent:" + a.getFile().getAbsolutePath());
                continue;
            }
            builder.classpathEntry(ArtifactKey.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension()), a.getFile());
        }
    }

    private List<Dependency> getProjectAetherDependencyManagement() {
        ArrayList<Dependency> managed = new ArrayList<Dependency>(this.project.getDependencyManagement().getDependencies().size());
        this.project.getDependencyManagement().getDependencies().forEach(d -> {
            List exclusions;
            if (!d.getExclusions().isEmpty()) {
                exclusions = new ArrayList(d.getExclusions().size());
                d.getExclusions().forEach(e -> exclusions.add(new Exclusion(e.getGroupId(), e.getArtifactId(), "*", "*")));
            } else {
                exclusions = List.of();
            }
            managed.add(new Dependency((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(d.getGroupId(), d.getArtifactId(), d.getClassifier(), d.getType(), d.getVersion()), d.getScope(), Boolean.valueOf(d.isOptional()), exclusions));
        });
        return managed;
    }

    private void setKotlinSpecificFlags(MavenDevModeLauncher.Builder builder) {
        Xpp3Dom compilerPluginArgsConfiguration;
        Plugin kotlinMavenPlugin = null;
        for (Plugin plugin : this.project.getBuildPlugins()) {
            if (!plugin.getArtifactId().equals(KOTLIN_MAVEN_PLUGIN) || !plugin.getGroupId().equals(ORG_JETBRAINS_KOTLIN)) continue;
            kotlinMavenPlugin = plugin;
            break;
        }
        if (kotlinMavenPlugin == null) {
            return;
        }
        this.getLog().debug((CharSequence)"Kotlin Maven plugin detected");
        ArrayList<String> compilerPluginArtifacts = new ArrayList<String>();
        List dependencies = kotlinMavenPlugin.getDependencies();
        for (org.apache.maven.model.Dependency dependency : dependencies) {
            try {
                ArtifactResult resolvedArtifact = this.repoSystem.resolveArtifact(this.repoSession, new ArtifactRequest().setArtifact((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), dependency.getVersion())).setRepositories(this.repos));
                compilerPluginArtifacts.add(resolvedArtifact.getArtifact().getFile().toPath().toAbsolutePath().toString());
            }
            catch (ArtifactResolutionException e) {
                this.getLog().warn((CharSequence)"Unable to properly setup dev-mode for Kotlin", (Throwable)e);
                return;
            }
        }
        builder.compilerPluginArtifacts(compilerPluginArtifacts);
        ArrayList<String> options = new ArrayList<String>();
        Xpp3Dom compilerPluginConfiguration = (Xpp3Dom)kotlinMavenPlugin.getConfiguration();
        if (compilerPluginConfiguration != null && (compilerPluginArgsConfiguration = compilerPluginConfiguration.getChild("pluginOptions")) != null) {
            for (Xpp3Dom argConfiguration : compilerPluginArgsConfiguration.getChildren()) {
                options.add(argConfiguration.getValue());
            }
        }
        builder.compilerPluginOptions(options);
    }

    private void setAnnotationProcessorFlags(MavenDevModeLauncher.Builder builder) {
        Plugin compilerMavenPlugin = null;
        for (Plugin plugin : this.project.getBuildPlugins()) {
            if (!plugin.getArtifactId().equals(MAVEN_COMPILER_PLUGIN) || !plugin.getGroupId().equals(ORG_APACHE_MAVEN_PLUGINS)) continue;
            compilerMavenPlugin = plugin;
            break;
        }
        if (compilerMavenPlugin == null) {
            return;
        }
        this.getLog().debug((CharSequence)"Maven compiler plugin found, looking for annotation processors");
        ArrayList options = new ArrayList();
        Xpp3Dom compilerPluginConfiguration = (Xpp3Dom)compilerMavenPlugin.getConfiguration();
        try {
            Set<File> processorPaths = this.readAnnotationProcessorPaths(compilerPluginConfiguration);
            this.getLog().debug((CharSequence)("Found processor paths: " + processorPaths));
            if (!processorPaths.isEmpty()) {
                builder.annotationProcessorPaths(processorPaths);
            }
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e);
        }
        List<String> processors = this.readAnnotationProcessors(compilerPluginConfiguration);
        this.getLog().debug((CharSequence)("Found processors: " + processors));
        if (!processors.isEmpty()) {
            builder.annotationProcessors(processors);
        }
        builder.compilerPluginOptions(options);
    }

    protected void modifyDevModeContext(MavenDevModeLauncher.Builder builder) {
    }

    private Optional<Xpp3Dom> findCompilerPluginConfiguration() {
        for (Plugin plugin : this.project.getBuildPlugins()) {
            Xpp3Dom compilerPluginConfiguration;
            if (!plugin.getArtifactId().equals(MAVEN_COMPILER_PLUGIN) || !plugin.getGroupId().equals(ORG_APACHE_MAVEN_PLUGINS) || (compilerPluginConfiguration = (Xpp3Dom)plugin.getConfiguration()) == null) continue;
            return Optional.of(compilerPluginConfiguration);
        }
        return Optional.empty();
    }

    private Path resolveSerializedModelLocation() {
        Path p = BootstrapUtils.resolveSerializedAppModelPath((Path)Paths.get(this.project.getBuild().getDirectory(), new String[0]));
        p.toFile().deleteOnExit();
        return p;
    }

    private class DevModeRunner {
        final QuarkusDevModeLauncher launcher;
        private Process process;

        private DevModeRunner(String bootstrapId) throws Exception {
            this.launcher = DevMojo.this.newLauncher(null, bootstrapId);
        }

        private DevModeRunner(String actualDebugPort, String bootstrapId) throws Exception {
            this.launcher = DevMojo.this.newLauncher(actualDebugPort, bootstrapId);
        }

        Collection<Path> pomFiles() {
            return this.launcher.watchedBuildFiles();
        }

        boolean alive() {
            return this.process != null && this.process.isAlive();
        }

        int exitValue() {
            return this.process == null ? -1 : this.process.exitValue();
        }

        boolean isExpectedExitValue() {
            return this.exitValue() == 0 || this.exitValue() == 130;
        }

        void run() throws Exception {
            if (DevMojo.this.getLog().isDebugEnabled()) {
                DevMojo.this.getLog().debug((CharSequence)("Launching JVM with command line: " + String.join((CharSequence)" ", this.launcher.args())));
            }
            ProcessBuilder processBuilder = new ProcessBuilder(this.launcher.args()).redirectErrorStream(true).inheritIO().directory(DevMojo.this.workingDir == null ? DevMojo.this.project.getBasedir() : DevMojo.this.workingDir);
            if (!DevMojo.this.environmentVariables.isEmpty()) {
                processBuilder.environment().putAll(DevMojo.this.environmentVariables);
            }
            this.process = processBuilder.start();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    DevModeRunner.this.process.destroy();
                    try {
                        DevModeRunner.this.process.waitFor();
                    }
                    catch (InterruptedException e) {
                        DevMojo.this.getLog().warn((CharSequence)"Unable to properly wait for dev-mode end", (Throwable)e);
                    }
                }
            }, "Development Mode Shutdown Hook"));
        }

        void stop() throws InterruptedException {
            this.process.destroy();
            this.process.waitFor();
        }
    }

    private static final class PluginExec {
        final Plugin plugin;
        final String prefix;
        final PluginExecution execution;

        PluginExec(Plugin plugin, String prefix, PluginExecution execution) {
            this.plugin = plugin;
            this.prefix = prefix;
            this.execution = execution;
        }

        String getPluginId() {
            return this.plugin.getId();
        }

        String getPrefix() {
            return this.prefix == null ? this.plugin.getId() : this.prefix;
        }

        String getExecutionId() {
            return this.execution == null ? null : this.execution.getId();
        }
    }
}

