/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingWriter;
import io.quarkus.maven.QuarkusBootstrapMojo;
import io.quarkus.runtime.LaunchMode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="track-config-changes", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class TrackConfigChangesMojo
extends QuarkusBootstrapMojo {
    @Parameter(defaultValue="false", property="quarkus.track-config-changes.skip")
    boolean skip = false;
    @Parameter(property="launchMode")
    String mode;
    @Parameter(property="quarkus.track-config-changes.outputDirectory", defaultValue="${project.build.directory}")
    File outputDirectory;
    @Parameter(property="quarkus.track-config-changes.outputFile", required=false)
    File outputFile;
    @Parameter(property="quarkus.recorded-build-config.directory", defaultValue="${basedir}/.quarkus")
    File recordedBuildConfigDirectory;
    @Parameter(property="quarkus.recorded-build-config.file", required=false)
    File recordedBuildConfigFile;

    @Override
    protected boolean beforeExecute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping config dump");
            return false;
        }
        return true;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        Properties actualProps;
        String lifecyclePhase = this.mojoExecution.getLifecyclePhase();
        if (this.mode == null) {
            this.mode = lifecyclePhase == null ? "NORMAL" : (lifecyclePhase.contains("test") ? "TEST" : "NORMAL");
        }
        LaunchMode launchMode = LaunchMode.valueOf((String)this.mode);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Bootstrapping Quarkus application in mode " + launchMode));
        }
        Path targetFile = this.outputFile == null ? this.outputDirectory.toPath().resolve("quarkus-" + launchMode.getDefaultProfile() + "-config-check") : (this.outputFile.isAbsolute() ? this.outputFile.toPath() : this.outputDirectory.toPath().resolve(this.outputFile.toPath()));
        Path compareFile = this.recordedBuildConfigFile == null ? this.recordedBuildConfigDirectory.toPath().resolve("quarkus-" + launchMode.getDefaultProfile() + "-config-dump") : (this.recordedBuildConfigFile.isAbsolute() ? this.recordedBuildConfigFile.toPath() : this.recordedBuildConfigDirectory.toPath().resolve(this.recordedBuildConfigFile.toPath()));
        if (!Files.exists(compareFile, new LinkOption[0])) {
            this.getLog().info((CharSequence)(compareFile + " not found"));
            return;
        }
        Properties compareProps = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(compareFile);){
            compareProps.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read " + compareFile, e);
        }
        CuratedApplication curatedApplication = null;
        QuarkusClassLoader deploymentClassLoader = null;
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        boolean clearPackageTypeSystemProperty = this.setPackageTypeSystemPropertyIfNativeProfileEnabled();
        try {
            curatedApplication = this.bootstrapApplication(launchMode);
            deploymentClassLoader = curatedApplication.createDeploymentClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)deploymentClassLoader);
            Class codeGenerator = deploymentClassLoader.loadClass("io.quarkus.deployment.CodeGenerator");
            Method dumpConfig = codeGenerator.getMethod("readCurrentConfigValues", ApplicationModel.class, String.class, Properties.class, QuarkusClassLoader.class, Properties.class);
            actualProps = (Properties)dumpConfig.invoke(null, curatedApplication.getApplicationModel(), launchMode.name(), this.getBuildSystemProperties(true), deploymentClassLoader, compareProps);
        }
        catch (Exception any) {
            throw new MojoExecutionException("Failed to bootstrap Quarkus application", any);
        }
        finally {
            if (clearPackageTypeSystemProperty) {
                System.clearProperty("quarkus.package.type");
            }
            Thread.currentThread().setContextClassLoader(originalCl);
            if (deploymentClassLoader != null) {
                deploymentClassLoader.close();
            }
        }
        ArrayList<String> names = new ArrayList<String>(actualProps.stringPropertyNames());
        Collections.sort(names);
        Path outputDir = targetFile.getParent();
        if (outputDir != null && !Files.exists(outputDir, new LinkOption[0])) {
            try {
                Files.createDirectories(outputDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        try (BufferedWriter writer = Files.newBufferedWriter(targetFile, new OpenOption[0]);){
            for (String name : names) {
                ConfigTrackingWriter.write((Writer)writer, (String)name, (String)actualProps.getProperty(name));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

