/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.mqtt.deployment;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.smallrye.reactivemessaging.mqtt.deployment.MqttBuildTimeConfig;
import io.quarkus.smallrye.reactivemessaging.mqtt.deployment.MqttDevServicesBuildTimeConfig;
import java.io.Closeable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.DockerImageName;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={DevServicesConfig.Enabled.class})
public class MqttDevServicesProcessor {
    private static final Logger log = Logger.getLogger(MqttDevServicesProcessor.class);
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-mqtt";
    private static final int MQTT_PORT = 1883;
    private static final ContainerLocator mqttContainerLocator = new ContainerLocator("quarkus-dev-service-mqtt", 1883);
    static volatile DevServicesResultBuildItem.RunningDevService devService;
    static volatile MqttDevServiceCfg cfg;
    static volatile boolean first;

    @BuildStep
    public DevServicesResultBuildItem startMqttDevService(DockerStatusBuildItem dockerStatusBuildItem, LaunchModeBuildItem launchMode, MqttBuildTimeConfig mqttClientBuildTimeConfig, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, DevServicesConfig devServicesConfig) {
        MqttDevServiceCfg configuration = this.getConfiguration(mqttClientBuildTimeConfig);
        if (devService != null) {
            boolean shouldShutdownTheBroker;
            boolean bl = shouldShutdownTheBroker = !configuration.equals(cfg);
            if (!shouldShutdownTheBroker) {
                return devService.toBuildItem();
            }
            this.shutdownBroker();
            cfg = null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "MQTT Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            DevServicesResultBuildItem.RunningDevService newDevService = this.startMqttBroker(dockerStatusBuildItem, configuration, launchMode, devServicesConfig.timeout());
            if (newDevService != null) {
                devService = newDevService;
                Map config = devService.getConfig();
                if (devService.isOwner()) {
                    log.info((Object)"Dev Services for MQTT started.");
                }
            }
            if (devService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (devService == null) {
            return null;
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    this.shutdownBroker();
                    log.info((Object)"Dev Services for MQTT shut down.");
                }
                first = true;
                devService = null;
                cfg = null;
            };
            QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            ((QuarkusClassLoader)cl.parent()).addCloseTask(closeTask);
        }
        cfg = configuration;
        return devService.toBuildItem();
    }

    private void shutdownBroker() {
        if (devService != null) {
            try {
                devService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop the MQTT broker", e);
            }
            finally {
                devService = null;
            }
        }
    }

    private DevServicesResultBuildItem.RunningDevService startMqttBroker(DockerStatusBuildItem dockerStatusBuildItem, MqttDevServiceCfg config, LaunchModeBuildItem launchMode, Optional<Duration> timeout) {
        if (!config.devServicesEnabled) {
            log.debug((Object)"Not starting Dev Services for MQTT, as it has been disabled in the config.");
            return null;
        }
        if (!this.hasMqttChannelWithoutHostAndPort()) {
            log.debug((Object)"Not starting Dev Services for MQTT, all the channels are configured.");
            return null;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            log.warn((Object)"Docker isn't working, please configure the MQTT broker location.");
            return null;
        }
        ConfiguredMqttContainer container = new ConfiguredMqttContainer(DockerImageName.parse((String)config.imageName).asCompatibleSubstituteFor("mqtt"), config.fixedExposedPort, launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT ? config.serviceName : null);
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultMqttBrokerSupplier = () -> {
            timeout.ifPresent(arg_0 -> ((ConfiguredMqttContainer)container).withStartupTimeout(arg_0));
            container.withEnv(config.containerEnv);
            container.start();
            return this.getRunningDevService(container.getContainerId(), () -> ((ConfiguredMqttContainer)container).close(), container.getHost(), container.getPort());
        };
        return mqttContainerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode()).map(containerAddress -> this.getRunningDevService(containerAddress.getId(), null, containerAddress.getHost(), containerAddress.getPort())).orElseGet(defaultMqttBrokerSupplier);
    }

    private DevServicesResultBuildItem.RunningDevService getRunningDevService(String containerId, Closeable closeable, String host, int port) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("mp.messaging.connector.smallrye-mqtt.host", host);
        configMap.put("mp.messaging.connector.smallrye-mqtt.port", String.valueOf(port));
        return new DevServicesResultBuildItem.RunningDevService(Feature.MESSAGING_MQTT.getName(), containerId, closeable, configMap);
    }

    private boolean hasMqttChannelWithoutHostAndPort() {
        Config config = ConfigProvider.getConfig();
        for (String name : config.getPropertyNames()) {
            boolean isConfigured;
            boolean isIncoming = name.startsWith("mp.messaging.incoming.");
            boolean isOutgoing = name.startsWith("mp.messaging.outgoing.");
            boolean isConnector = name.endsWith(".connector");
            if (!isIncoming && !isOutgoing || !isConnector) continue;
            String connectorValue = (String)config.getValue(name, String.class);
            boolean isMqtt = connectorValue.equalsIgnoreCase("smallrye-mqtt");
            boolean hasHost = ConfigUtils.isPropertyNonEmpty((String)name.replace(".connector", ".host"));
            boolean hasPort = ConfigUtils.isPropertyNonEmpty((String)name.replace(".connector", ".port"));
            boolean bl = isConfigured = hasHost || hasPort;
            if (!isMqtt || isConfigured) continue;
            return true;
        }
        return false;
    }

    private MqttDevServiceCfg getConfiguration(MqttBuildTimeConfig cfg) {
        MqttDevServicesBuildTimeConfig devServicesConfig = cfg.devservices;
        return new MqttDevServiceCfg(devServicesConfig);
    }

    static {
        first = true;
    }

    private static final class MqttDevServiceCfg {
        private final boolean devServicesEnabled;
        private final String imageName;
        private final Integer fixedExposedPort;
        private final boolean shared;
        private final String serviceName;
        private final Map<String, String> containerEnv;

        public MqttDevServiceCfg(MqttDevServicesBuildTimeConfig devServicesConfig) {
            this.devServicesEnabled = devServicesConfig.enabled.orElse(true);
            this.imageName = devServicesConfig.imageName;
            this.fixedExposedPort = devServicesConfig.port.orElse(0);
            this.shared = devServicesConfig.shared;
            this.serviceName = devServicesConfig.serviceName;
            this.containerEnv = devServicesConfig.containerEnv;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MqttDevServiceCfg that = (MqttDevServiceCfg)o;
            return this.devServicesEnabled == that.devServicesEnabled && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.fixedExposedPort, that.fixedExposedPort) && Objects.equals(this.containerEnv, that.containerEnv);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.imageName, this.fixedExposedPort, this.containerEnv);
        }
    }

    private static final class ConfiguredMqttContainer
    extends GenericContainer<ConfiguredMqttContainer> {
        private final int port;

        private ConfiguredMqttContainer(DockerImageName dockerImageName, int fixedExposedPort, String serviceName) {
            super(dockerImageName);
            this.port = fixedExposedPort;
            this.withExposedPorts(new Integer[]{1883});
            this.withNetwork(Network.SHARED);
            if (serviceName != null) {
                this.withLabel(MqttDevServicesProcessor.DEV_SERVICE_LABEL, serviceName);
            }
            this.withClasspathResourceMapping("mosquitto.conf", "/mosquitto/config/mosquitto.conf", BindMode.READ_ONLY);
            if (!dockerImageName.getRepository().endsWith("eclipse-mosquitto")) {
                throw new IllegalArgumentException("Only official eclipse-mosquitto images are supported");
            }
        }

        protected void configure() {
            super.configure();
            if (this.port > 0) {
                this.addFixedExposedPort(this.port, 1883);
            }
        }

        public int getPort() {
            return this.getMappedPort(1883);
        }
    }
}

