/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.pulsar.deployment;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.KotlinUtils;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.pulsar.SchemaProviderRecorder;
import io.quarkus.smallrye.reactivemessaging.deployment.ReactiveMessagingDotNames;
import io.quarkus.smallrye.reactivemessaging.deployment.SmallRyeReactiveMessagingProcessor;
import io.quarkus.smallrye.reactivemessaging.deployment.items.ConnectorManagedChannelBuildItem;
import io.quarkus.smallrye.reactivemessaging.pulsar.deployment.DefaultSchemaDiscoveryState;
import io.quarkus.smallrye.reactivemessaging.pulsar.deployment.DotNames;
import io.quarkus.smallrye.reactivemessaging.pulsar.deployment.ReactiveMessagingPulsarBuildTimeConfig;
import io.quarkus.smallrye.reactivemessaging.pulsar.deployment.SyntheticBeanBuilder;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.pulsar.common.schema.SchemaType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class PulsarSchemaDiscoveryProcessor {
    static Logger log = Logger.getLogger(PulsarSchemaDiscoveryProcessor.class);
    private static final Map<DotName, String> KNOWN_SCHEMA = Map.ofEntries(Map.entry(DotName.createSimple((String)"byte"), SchemaType.INT8.name()), Map.entry(DotName.createSimple((String)"short"), SchemaType.INT16.name()), Map.entry(DotName.createSimple((String)"int"), SchemaType.INT32.name()), Map.entry(DotName.createSimple((String)"long"), SchemaType.INT64.name()), Map.entry(DotName.createSimple((String)"float"), SchemaType.FLOAT.name()), Map.entry(DotName.createSimple((String)"double"), SchemaType.DOUBLE.name()), Map.entry(DotName.createSimple((String)"boolean"), SchemaType.BOOLEAN.name()), Map.entry(DotName.createSimple((String)Byte.class.getName()), SchemaType.INT8.name()), Map.entry(DotName.createSimple((String)Short.class.getName()), SchemaType.INT16.name()), Map.entry(DotName.createSimple((String)Integer.class.getName()), SchemaType.INT32.name()), Map.entry(DotName.createSimple((String)Long.class.getName()), SchemaType.INT64.name()), Map.entry(DotName.createSimple((String)Float.class.getName()), SchemaType.FLOAT.name()), Map.entry(DotName.createSimple((String)Double.class.getName()), SchemaType.DOUBLE.name()), Map.entry(DotName.createSimple((String)Boolean.class.getName()), SchemaType.BOOLEAN.name()), Map.entry(DotName.createSimple((String)"[B"), SchemaType.BYTES.name()), Map.entry(DotName.createSimple((String)String.class.getName()), SchemaType.STRING.name()), Map.entry(DotName.createSimple((String)Instant.class.getName()), SchemaType.INSTANT.name()), Map.entry(DotName.createSimple((String)Timestamp.class.getName()), SchemaType.TIMESTAMP.name()), Map.entry(DotName.createSimple((String)LocalDate.class.getName()), SchemaType.LOCAL_DATE.name()), Map.entry(DotName.createSimple((String)LocalTime.class.getName()), SchemaType.LOCAL_TIME.name()), Map.entry(DotName.createSimple((String)LocalDateTime.class.getName()), SchemaType.LOCAL_DATE_TIME.name()), Map.entry(DotNames.PULSAR_GENERIC_RECORD, SchemaType.AUTO_CONSUME.name()));

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void defaultChannelConfiguration(ReactiveMessagingPulsarBuildTimeConfig buildTimeConfig, CombinedIndexBuildItem combinedIndex, List<ConnectorManagedChannelBuildItem> channelsManagedByConnectors, BuildProducer<RunTimeConfigurationDefaultBuildItem> defaultConfigProducer, BuildProducer<SyntheticBeanBuildItem> syntheticBean, RecorderContext recorderContext, SchemaProviderRecorder recorder) {
        if (buildTimeConfig.schemaAutodetectionEnabled()) {
            DefaultSchemaDiscoveryState discoveryState = new DefaultSchemaDiscoveryState(combinedIndex.getIndex());
            this.discoverDefaultSerdeConfig(discoveryState, channelsManagedByConnectors, defaultConfigProducer, buildTimeConfig.schemaGenerationEnabled() ? new SyntheticBeanBuilder(syntheticBean, recorder, recorderContext) : null);
        }
    }

    void discoverDefaultSerdeConfig(DefaultSchemaDiscoveryState discovery, List<ConnectorManagedChannelBuildItem> channelsManagedByConnectors, BuildProducer<RunTimeConfigurationDefaultBuildItem> config, SyntheticBeanBuilder syntheticBean) {
        Type incomingType;
        MethodInfo method;
        String channelName;
        for (AnnotationInstance annotation : discovery.findRepeatableAnnotationsOnMethods(DotNames.INCOMING)) {
            channelName = annotation.value().asString();
            if (!discovery.isPulsarConnector(channelsManagedByConnectors, true, channelName)) continue;
            method = annotation.target().asMethod();
            incomingType = this.getIncomingTypeFromMethod(method);
            this.processIncomingType(discovery, config, incomingType, channelName, syntheticBean);
        }
        for (AnnotationInstance annotation : discovery.findRepeatableAnnotationsOnMethods(DotNames.OUTGOING)) {
            channelName = annotation.value().asString();
            if (!discovery.isPulsarConnector(channelsManagedByConnectors, false, channelName)) continue;
            method = annotation.target().asMethod();
            Type outgoingType = this.getOutgoingTypeFromMethod(method);
            this.processOutgoingType(discovery, config, outgoingType, channelName, syntheticBean);
        }
        for (AnnotationInstance annotation : discovery.findAnnotationsOnInjectionPoints(DotNames.CHANNEL)) {
            Type injectionPointType;
            channelName = annotation.value().asString();
            if (!discovery.isPulsarConnector(channelsManagedByConnectors, false, channelName) && !discovery.isPulsarConnector(channelsManagedByConnectors, true, channelName) || (injectionPointType = this.getInjectionPointType(annotation)) == null) continue;
            incomingType = this.getIncomingTypeFromChannelInjectionPoint(injectionPointType);
            this.processIncomingType(discovery, config, incomingType, channelName, syntheticBean);
            this.processPulsarTransactions(discovery, config, channelName, injectionPointType);
            Type outgoingType = this.getOutgoingTypeFromChannelInjectionPoint(injectionPointType);
            this.processOutgoingType(discovery, config, outgoingType, channelName, syntheticBean);
        }
    }

    private static String outgoingSchemaKey(String channelName) {
        return SmallRyeReactiveMessagingProcessor.getChannelPropertyKey((String)channelName, (String)"schema", (boolean)false);
    }

    private void processPulsarTransactions(DefaultSchemaDiscoveryState discovery, BuildProducer<RunTimeConfigurationDefaultBuildItem> config, String channelName, Type injectionPointType) {
        if (injectionPointType != null && PulsarSchemaDiscoveryProcessor.isPulsarEmitter(injectionPointType)) {
            String enableTransactionKey = SmallRyeReactiveMessagingProcessor.getChannelPropertyKey((String)channelName, (String)"enableTransaction", (boolean)false);
            log.infof("Transactional producer detected for channel '%s', setting following default config values: '" + enableTransactionKey + "=true'", (Object)channelName);
            this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, enableTransactionKey, "true");
        }
    }

    private void processIncomingType(DefaultSchemaDiscoveryState discovery, BuildProducer<RunTimeConfigurationDefaultBuildItem> config, Type incomingType, String channelName, SyntheticBeanBuilder syntheticBean) {
        this.extractValueType(incomingType, (value, isBatch) -> {
            if (discovery.findProvidedSchemaWithIdentifier(channelName).isEmpty()) {
                if (discovery.hasObjectMapperConfigSchema((Type)value, channelName, true)) {
                    this.objectMapperSchemaFor(SyntheticBeanBuilder.objectMapperSchemaId(value), (Type)value, syntheticBean);
                } else {
                    String schema = this.schemaFor(discovery, (Type)value, syntheticBean);
                    this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, PulsarSchemaDiscoveryProcessor.incomingSchemaKey(channelName), schema);
                }
            }
            if (Boolean.TRUE.equals(isBatch)) {
                this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, SmallRyeReactiveMessagingProcessor.getChannelPropertyKey((String)channelName, (String)"batchReceive", (boolean)true), "true");
            }
        });
    }

    private static String incomingSchemaKey(String channelName) {
        return SmallRyeReactiveMessagingProcessor.getChannelPropertyKey((String)channelName, (String)"schema", (boolean)true);
    }

    private Type getInjectionPointType(AnnotationInstance annotation) {
        return switch (annotation.target().kind()) {
            case AnnotationTarget.Kind.FIELD -> this.handleInstanceChannelInjection(annotation.target().asField().type());
            case AnnotationTarget.Kind.METHOD_PARAMETER -> this.handleInstanceChannelInjection(annotation.target().asMethodParameter().type());
            default -> null;
        };
    }

    private Type handleInstanceChannelInjection(Type type) {
        return DotNames.INSTANCE.equals((Object)type.name()) || DotNames.PROVIDER.equals((Object)type.name()) || DotNames.INJECTABLE_INSTANCE.equals((Object)type.name()) ? (Type)type.asParameterizedType().arguments().get(0) : type;
    }

    private void produceRuntimeConfigurationDefaultBuildItem(DefaultSchemaDiscoveryState discovery, BuildProducer<RunTimeConfigurationDefaultBuildItem> config, String key, String value) {
        if (value == null) {
            return;
        }
        if (discovery.shouldNotConfigure(key)) {
            return;
        }
        discovery.ifNotYetConfigured(key, () -> config.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(key, value)));
    }

    private Type getIncomingTypeFromMethod(MethodInfo method) {
        List parameterTypes = method.parameterTypes();
        int parametersCount = parameterTypes.size();
        Type returnType = method.returnType();
        Type incomingType = null;
        if (PulsarSchemaDiscoveryProcessor.isVoid(returnType) && parametersCount >= 1 || PulsarSchemaDiscoveryProcessor.isCompletionStage(returnType) && parametersCount >= 1 || PulsarSchemaDiscoveryProcessor.isUni(returnType) && parametersCount >= 1) {
            incomingType = (Type)parameterTypes.get(0);
        } else if (PulsarSchemaDiscoveryProcessor.isSubscriber(returnType) && parametersCount == 0 || PulsarSchemaDiscoveryProcessor.isSubscriberBuilder(returnType) && parametersCount == 0) {
            incomingType = (Type)returnType.asParameterizedType().arguments().get(0);
        } else if (KotlinUtils.isKotlinSuspendMethod((MethodInfo)method)) {
            incomingType = (Type)parameterTypes.get(0);
        }
        if (method.hasAnnotation(DotNames.OUTGOING) || method.hasAnnotation(DotNames.OUTGOINGS)) {
            if (PulsarSchemaDiscoveryProcessor.isCompletionStage(returnType) && parametersCount >= 1 || PulsarSchemaDiscoveryProcessor.isUni(returnType) && parametersCount >= 1 || PulsarSchemaDiscoveryProcessor.isPublisher(returnType) && parametersCount == 1 || PulsarSchemaDiscoveryProcessor.isPublisherBuilder(returnType) && parametersCount == 1 || PulsarSchemaDiscoveryProcessor.isFlowPublisher(returnType) && parametersCount == 1 || PulsarSchemaDiscoveryProcessor.isMulti(returnType) && parametersCount == 1) {
                incomingType = (Type)parameterTypes.get(0);
            } else if (PulsarSchemaDiscoveryProcessor.isProcessor(returnType) && parametersCount == 0 || PulsarSchemaDiscoveryProcessor.isProcessorBuilder(returnType) && parametersCount == 0) {
                incomingType = (Type)returnType.asParameterizedType().arguments().get(0);
            } else if (parametersCount >= 1) {
                incomingType = (Type)parameterTypes.get(0);
            } else if (KotlinUtils.isKotlinSuspendMethod((MethodInfo)method)) {
                incomingType = (Type)parameterTypes.get(0);
            }
            if (incomingType != null && (PulsarSchemaDiscoveryProcessor.isPublisher(incomingType) || PulsarSchemaDiscoveryProcessor.isPublisherBuilder(incomingType) || PulsarSchemaDiscoveryProcessor.isMulti(incomingType) || PulsarSchemaDiscoveryProcessor.isFlowPublisher(incomingType))) {
                incomingType = (Type)incomingType.asParameterizedType().arguments().get(0);
            }
        }
        return incomingType;
    }

    private Type getIncomingTypeFromChannelInjectionPoint(Type injectionPointType) {
        if (injectionPointType == null) {
            return null;
        }
        if (PulsarSchemaDiscoveryProcessor.isPublisher(injectionPointType) || PulsarSchemaDiscoveryProcessor.isPublisherBuilder(injectionPointType) || PulsarSchemaDiscoveryProcessor.isMulti(injectionPointType) || PulsarSchemaDiscoveryProcessor.isFlowPublisher(injectionPointType)) {
            return (Type)injectionPointType.asParameterizedType().arguments().get(0);
        }
        return null;
    }

    private Type getOutgoingTypeFromMethod(MethodInfo method) {
        List parameterTypes = method.parameterTypes();
        int parametersCount = parameterTypes.size();
        Type returnType = method.returnType();
        Type outgoingType = null;
        if (PulsarSchemaDiscoveryProcessor.isPublisher(returnType) && parametersCount == 0 || PulsarSchemaDiscoveryProcessor.isPublisherBuilder(returnType) && parametersCount == 0 || PulsarSchemaDiscoveryProcessor.isMulti(returnType) && parametersCount == 0 || PulsarSchemaDiscoveryProcessor.isFlowPublisher(returnType) && parametersCount == 0 || PulsarSchemaDiscoveryProcessor.isCompletionStage(returnType) && parametersCount == 0 || PulsarSchemaDiscoveryProcessor.isUni(returnType) && parametersCount == 0) {
            outgoingType = (Type)returnType.asParameterizedType().arguments().get(0);
        } else if (parametersCount == 0) {
            outgoingType = returnType;
        } else if (KotlinUtils.isKotlinSuspendMethod((MethodInfo)method)) {
            outgoingType = PulsarSchemaDiscoveryProcessor.getReturnTypeFromKotlinSuspendMethod(method);
        }
        if ((method.hasAnnotation(DotNames.INCOMING) || method.hasAnnotation(DotNames.INCOMINGS)) && (outgoingType = PulsarSchemaDiscoveryProcessor.isCompletionStage(returnType) || PulsarSchemaDiscoveryProcessor.isUni(returnType) || PulsarSchemaDiscoveryProcessor.isMulti(returnType) ? (Type)returnType.asParameterizedType().arguments().get(0) : (PulsarSchemaDiscoveryProcessor.isPublisher(returnType) && parametersCount == 1 || PulsarSchemaDiscoveryProcessor.isPublisherBuilder(returnType) && parametersCount == 1 || PulsarSchemaDiscoveryProcessor.isFlowPublisher(returnType) && parametersCount == 1 || PulsarSchemaDiscoveryProcessor.isMultiSplitter(returnType) && parametersCount == 1 ? (Type)returnType.asParameterizedType().arguments().get(0) : (PulsarSchemaDiscoveryProcessor.isProcessor(returnType) && parametersCount == 0 || PulsarSchemaDiscoveryProcessor.isProcessorBuilder(returnType) && parametersCount == 0 ? (Type)returnType.asParameterizedType().arguments().get(1) : (KotlinUtils.isKotlinSuspendMethod((MethodInfo)method) ? PulsarSchemaDiscoveryProcessor.getReturnTypeFromKotlinSuspendMethod(method) : returnType)))) != null && (PulsarSchemaDiscoveryProcessor.isPublisher(outgoingType) || PulsarSchemaDiscoveryProcessor.isPublisherBuilder(outgoingType) || PulsarSchemaDiscoveryProcessor.isMulti(outgoingType) || PulsarSchemaDiscoveryProcessor.isFlowPublisher(outgoingType))) {
            outgoingType = (Type)outgoingType.asParameterizedType().arguments().get(0);
        }
        return outgoingType;
    }

    private static Type getReturnTypeFromKotlinSuspendMethod(MethodInfo method) {
        Type firstGenericType;
        Type continuationReturnType = method.parameterType(method.parametersCount() - 1);
        if (continuationReturnType.kind() == Type.Kind.PARAMETERIZED_TYPE && (firstGenericType = (Type)continuationReturnType.asParameterizedType().arguments().get(0)).kind() == Type.Kind.WILDCARD_TYPE) {
            return firstGenericType.asWildcardType().superBound();
        }
        return null;
    }

    private Type getOutgoingTypeFromChannelInjectionPoint(Type injectionPointType) {
        if (injectionPointType == null) {
            return null;
        }
        if (PulsarSchemaDiscoveryProcessor.isEmitter(injectionPointType) || PulsarSchemaDiscoveryProcessor.isMutinyEmitter(injectionPointType) || PulsarSchemaDiscoveryProcessor.isContextualEmitter(injectionPointType) || PulsarSchemaDiscoveryProcessor.isPulsarEmitter(injectionPointType)) {
            return (Type)injectionPointType.asParameterizedType().arguments().get(0);
        }
        return null;
    }

    private void processOutgoingType(DefaultSchemaDiscoveryState discovery, BuildProducer<RunTimeConfigurationDefaultBuildItem> config, Type outgoingType, String channelName, SyntheticBeanBuilder syntheticBean) {
        this.extractValueType(outgoingType, (value, isBatch) -> {
            if (discovery.findProvidedSchemaWithIdentifier(channelName).isEmpty()) {
                if (discovery.hasObjectMapperConfigSchema((Type)value, channelName, false)) {
                    this.objectMapperSchemaFor(SyntheticBeanBuilder.objectMapperSchemaId(value), (Type)value, syntheticBean);
                } else {
                    String schema = this.schemaFor(discovery, (Type)value, syntheticBean);
                    this.produceRuntimeConfigurationDefaultBuildItem(discovery, config, PulsarSchemaDiscoveryProcessor.outgoingSchemaKey(channelName), schema);
                }
            }
        });
    }

    private void extractValueType(Type type, BiConsumer<Type, Boolean> schemaAcceptor) {
        if (type == null) {
            return;
        }
        if (PulsarSchemaDiscoveryProcessor.isTargeted(type)) {
            return;
        }
        if (PulsarSchemaDiscoveryProcessor.isGenericPayload(type)) {
            this.extractValueType((Type)type.asParameterizedType().arguments().get(0), schemaAcceptor);
            return;
        }
        if (PulsarSchemaDiscoveryProcessor.isMessage(type)) {
            List typeArguments = type.asParameterizedType().arguments();
            Type messageTypeParameter = (Type)typeArguments.get(0);
            if (PulsarSchemaDiscoveryProcessor.isList(messageTypeParameter)) {
                List messageListTypeArguments = messageTypeParameter.asParameterizedType().arguments();
                schemaAcceptor.accept((Type)messageListTypeArguments.get(0), true);
            } else {
                schemaAcceptor.accept(messageTypeParameter, false);
            }
        } else if (PulsarSchemaDiscoveryProcessor.isList(type)) {
            List typeArguments = type.asParameterizedType().arguments();
            schemaAcceptor.accept((Type)typeArguments.get(0), true);
        } else if (PulsarSchemaDiscoveryProcessor.isPulsarMessage(type) || PulsarSchemaDiscoveryProcessor.isPulsarApiMessage(type) || PulsarSchemaDiscoveryProcessor.isOutgoingMessage(type)) {
            List typeArguments = type.asParameterizedType().arguments();
            schemaAcceptor.accept((Type)typeArguments.get(0), false);
        } else if (PulsarSchemaDiscoveryProcessor.isPulsarApiMessages(type) || PulsarSchemaDiscoveryProcessor.isPulsarBatchMessage(type)) {
            List typeArguments = type.asParameterizedType().arguments();
            schemaAcceptor.accept((Type)typeArguments.get(0), true);
        } else if (PulsarSchemaDiscoveryProcessor.isKeyedMulti(type)) {
            List typeArguments = type.asParameterizedType().arguments();
            schemaAcceptor.accept((Type)typeArguments.get(1), false);
        } else if (PulsarSchemaDiscoveryProcessor.isRawMessage(type)) {
            schemaAcceptor.accept(type, false);
        }
    }

    private static boolean isVoid(Type type) {
        return type.kind() == Type.Kind.VOID;
    }

    private static boolean isCompletionStage(Type type) {
        return DotNames.COMPLETION_STAGE.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isUni(Type type) {
        return DotNames.UNI.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isMulti(Type type) {
        return DotNames.MULTI.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isMultiSplitter(Type type) {
        return DotNames.MULTI_SPLITTER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isTargeted(Type type) {
        return DotNames.TARGETED.equals((Object)type.name()) || DotNames.TARGETED_MESSAGES.equals((Object)type.name());
    }

    private static boolean isFlowPublisher(Type type) {
        return DotNames.FLOW_PUBLISHER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isSubscriber(Type type) {
        return DotNames.SUBSCRIBER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isSubscriberBuilder(Type type) {
        return DotNames.SUBSCRIBER_BUILDER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isPublisher(Type type) {
        return DotNames.PUBLISHER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isPublisherBuilder(Type type) {
        return DotNames.PUBLISHER_BUILDER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isProcessor(Type type) {
        return DotNames.PROCESSOR.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isProcessorBuilder(Type type) {
        return DotNames.PROCESSOR_BUILDER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isEmitter(Type type) {
        return DotNames.EMITTER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isMutinyEmitter(Type type) {
        return DotNames.MUTINY_EMITTER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isContextualEmitter(Type type) {
        return DotNames.CONTEXTUAL_EMITTER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isPulsarEmitter(Type type) {
        return DotNames.PULSAR_EMITTER.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isMessage(Type type) {
        return DotNames.MESSAGE.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isGenericPayload(Type type) {
        return DotNames.GENERIC_PAYLOAD.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isPulsarMessage(Type type) {
        return DotNames.PULSAR_MESSAGE.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isOutgoingMessage(Type type) {
        return DotNames.OUTGOING_MESSAGE.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isPulsarApiMessage(Type type) {
        return DotNames.PULSAR_API_MESSAGE.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isKeyedMulti(Type type) {
        return ReactiveMessagingDotNames.KEYED_MULTI.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 2;
    }

    private static boolean isList(Type type) {
        return DotNames.LIST.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isPulsarBatchMessage(Type type) {
        return DotNames.PULSAR_BATCH_MESSAGE.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isPulsarApiMessages(Type type) {
        return DotNames.PULSAR_API_MESSAGES.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.asParameterizedType().arguments().size() == 1;
    }

    private static boolean isRawMessage(Type type) {
        switch (type.kind()) {
            case PRIMITIVE: 
            case CLASS: 
            case ARRAY: {
                return true;
            }
        }
        return false;
    }

    private String knownSchemaFor(Type type) {
        if (type == null) {
            return null;
        }
        DotName typeName = type.name();
        if (KNOWN_SCHEMA.containsKey(typeName)) {
            return KNOWN_SCHEMA.get(typeName);
        }
        return null;
    }

    private void objectMapperSchemaFor(String schemaId, Type type, SyntheticBeanBuilder syntheticBean) {
        if (syntheticBean != null) {
            syntheticBean.produceObjectMapperSchemaBean(schemaId, type);
        }
    }

    private String schemaFor(DefaultSchemaDiscoveryState discovery, Type type, SyntheticBeanBuilder syntheticBean) {
        String result = this.knownSchemaFor(type);
        if (result == null && type != null && syntheticBean != null && type.kind() == Type.Kind.CLASS) {
            String schemaId = syntheticBean.produceSchemaBean(discovery, type);
            if (schemaId != null) {
                log.infof("Generating Schema for type %s %s", (Object)type.name().toString(), (Object)schemaId);
            }
            result = schemaId;
        }
        return result;
    }
}

