/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.pulsar.schema;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class JsonObjectSchema
extends AbstractSchema<JsonObject> {
    public static final JsonObjectSchema INSTANCE = new JsonObjectSchema();
    private static final SchemaInfo SCHEMA_INFO = SchemaInfoImpl.builder().name("JsonObject").type(SchemaType.NONE).schema(new byte[0]).build();

    public JsonObject decode(ByteBuf byteBuf) {
        if (byteBuf == null) {
            return null;
        }
        Buffer buffer = Buffer.buffer((ByteBuf)byteBuf);
        return buffer.toJsonObject();
    }

    public byte[] encode(JsonObject message) {
        if (message == null) {
            return null;
        }
        return message.encode().getBytes();
    }

    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }
}

