/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.pulsar.runtime.graal;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.pulsar.client.api.url.URL;
import org.apache.pulsar.client.impl.auth.oauth2.KeyFile;

@TargetClass(className="org.apache.pulsar.client.impl.auth.oauth2.ClientCredentialsFlow")
final class Target_org_apache_pulsaR_client_impl_auth_oauth2_ClientCredentialsFlow {
    Target_org_apache_pulsaR_client_impl_auth_oauth2_ClientCredentialsFlow() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    private static KeyFile loadPrivateKey(String privateKeyURL) throws IOException {
        KeyFile keyFile;
        URLConnection urlConnection = new URL(privateKeyURL).openConnection();
        try {
            KeyFile privateKey;
            String protocol = urlConnection.getURL().getProtocol();
            if ("data".equals(protocol) && !"application/json".equals(urlConnection.getContentType())) {
                throw new IllegalArgumentException("Unsupported media type or encoding format: " + urlConnection.getContentType());
            }
            try (InputStreamReader r = new InputStreamReader(urlConnection.getInputStream(), StandardCharsets.UTF_8);){
                privateKey = KeyFile.fromJson((Reader)r);
            }
            keyFile = privateKey;
        }
        catch (Throwable throwable) {
            try {
                IOUtils.close((URLConnection)urlConnection);
                throw throwable;
            }
            catch (IllegalAccessException | InstantiationException | URISyntaxException e) {
                throw new IOException("Invalid privateKey format", e);
            }
        }
        IOUtils.close((URLConnection)urlConnection);
        return keyFile;
    }
}

