/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.rabbitmq.runtime;

import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.tls.runtime.config.TlsConfigUtils;
import io.smallrye.reactive.messaging.ClientCustomizer;
import io.vertx.core.net.NetClientOptions;
import io.vertx.rabbitmq.RabbitMQOptions;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;

@ApplicationScoped
public class RabbitmqClientConfigCustomizer
implements ClientCustomizer<RabbitMQOptions> {
    private static final Logger log = Logger.getLogger(RabbitmqClientConfigCustomizer.class);
    @Inject
    TlsConfigurationRegistry tlsRegistry;

    public RabbitMQOptions customize(String channel, Config channelConfig, RabbitMQOptions options) {
        String tlsConfig;
        Optional maybeTlsConfig;
        Optional tlsConfigName = channelConfig.getOptionalValue("tls-configuration-name", String.class);
        if (tlsConfigName.isPresent() && (maybeTlsConfig = this.tlsRegistry.get(tlsConfig = (String)tlsConfigName.get())).isPresent()) {
            TlsConfigUtils.configure((NetClientOptions)options, (TlsConfiguration)((TlsConfiguration)maybeTlsConfig.get()));
            log.debugf("Configured RabbitMQOptions for channel %s with TLS configuration %s", (Object)channel, (Object)tlsConfig);
        }
        return options;
    }
}

