/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.runtime.devui;

import io.quarkus.runtime.StartupEvent;
import io.quarkus.smallrye.reactivemessaging.runtime.devui.DevReactiveMessagingInfos;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.config.Config;

@Singleton
public class Connectors {
    final Map<String, DevReactiveMessagingInfos.Component> incomingConnectors = new HashMap<String, DevReactiveMessagingInfos.Component>();
    final Map<String, DevReactiveMessagingInfos.Component> outgoingConnectors = new HashMap<String, DevReactiveMessagingInfos.Component>();

    void collect(@Observes StartupEvent event, Config config) {
        StringBuilder desc;
        String channel;
        String connector;
        String outgoingPrefix = "mp.messaging.outgoing.";
        String incomingPrefix = "mp.messaging.incoming.";
        String connectorSuffix = ".connector";
        ArrayList<String> sourceConnectorsProperties = new ArrayList<String>();
        ArrayList<String> sinkConnectorsProperties = new ArrayList<String>();
        for (String propertyName : config.getPropertyNames()) {
            if (propertyName.startsWith(outgoingPrefix) && propertyName.endsWith(connectorSuffix)) {
                sinkConnectorsProperties.add(propertyName);
                continue;
            }
            if (!propertyName.startsWith(incomingPrefix) || !propertyName.endsWith(connectorSuffix)) continue;
            sourceConnectorsProperties.add(propertyName);
        }
        for (String sink : sinkConnectorsProperties) {
            connector = (String)config.getValue(sink, String.class);
            channel = sink.substring(outgoingPrefix.length(), sink.length() - connectorSuffix.length());
            desc = new StringBuilder();
            desc.append(connector);
            desc.append("<ul>");
            desc.append("<li>Config property: ");
            desc.append(DevReactiveMessagingInfos.asCode(sink.substring(0, sink.length() - connectorSuffix.length())));
            desc.append("</li>");
            for (Map.Entry<String, String> entry : this.getProperties(config, connectorSuffix, sink).entrySet()) {
                desc.append("<li>");
                desc.append(entry.getKey());
                desc.append("=");
                desc.append(entry.getValue());
                desc.append("</li>");
            }
            desc.append("</ul>");
            this.incomingConnectors.put(channel, new DevReactiveMessagingInfos.Component(DevReactiveMessagingInfos.ComponentType.CONNECTOR, desc.toString()));
        }
        for (String source : sourceConnectorsProperties) {
            connector = (String)config.getValue(source, String.class);
            channel = source.substring(incomingPrefix.length(), source.length() - connectorSuffix.length());
            desc = new StringBuilder();
            desc.append(connector);
            desc.append("<ul>");
            desc.append("<li>Config property: ");
            desc.append(DevReactiveMessagingInfos.asCode(source.substring(0, source.length() - connectorSuffix.length())));
            desc.append("</li>");
            for (Map.Entry<String, String> entry : this.getProperties(config, connectorSuffix, source).entrySet()) {
                desc.append("<li>");
                desc.append(entry.getKey());
                desc.append("=");
                desc.append(entry.getValue());
                desc.append("</li>");
            }
            desc.append("</ul>");
            this.outgoingConnectors.put(channel, new DevReactiveMessagingInfos.Component(DevReactiveMessagingInfos.ComponentType.CONNECTOR, desc.toString()));
        }
    }

    private Map<String, String> getProperties(Config config, String connectorSuffix, String connectorPropertyName) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String prefix = connectorPropertyName.substring(0, connectorPropertyName.length() - connectorSuffix.length());
        for (String propertyName : config.getPropertyNames()) {
            if (!propertyName.startsWith(prefix) || propertyName.equals(connectorPropertyName)) continue;
            properties.put(propertyName.substring(prefix.length() + 1), config.getOptionalValue(propertyName, String.class).orElse(""));
        }
        return properties;
    }
}

