/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.smallrye.common.vertx.VertxContext;
import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.PublisherDecorator;
import io.smallrye.reactive.messaging.providers.locals.LocalContextMetadata;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class RequestScopedDecorator
implements PublisherDecorator {
    public Multi<? extends Message<?>> decorate(Multi<? extends Message<?>> publisher, List<String> channelName, boolean isConnector) {
        if (isConnector) {
            return publisher.map(message -> {
                Optional localContextMetadata = message.getMetadata(LocalContextMetadata.class);
                if (localContextMetadata.isPresent() && VertxContext.isOnDuplicatedContext()) {
                    ManagedContext requestContext = Arc.container().requestContext();
                    if (!requestContext.isActive()) {
                        requestContext.activate();
                        InjectableContext.ContextState state = requestContext.getState();
                        Message withAck = message.withAckWithMetadata(m -> message.ack(m).thenAccept(x -> {
                            requestContext.destroy(state);
                            requestContext.deactivate();
                        }));
                        return withAck.withNackWithMetadata((m, t) -> withAck.nack(m, t).thenAccept(x -> {
                            requestContext.destroy(state);
                            requestContext.deactivate();
                        }));
                    }
                    return message;
                }
                return message;
            });
        }
        return publisher;
    }

    public int getPriority() {
        return 100;
    }
}

