/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.export;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.micrometer.deployment.MicrometerRegistryProviderBuildItem;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import io.quarkus.micrometer.runtime.export.StackdriverMeterRegistryProvider;
import java.util.function.BooleanSupplier;
import org.jboss.logging.Logger;

public class StackdriverRegistryProcessor {
    private static final Logger log = Logger.getLogger(StackdriverRegistryProcessor.class);
    static final String REGISTRY_CLASS_NAME = "io.micrometer.stackdriver.StackdriverMeterRegistry";
    static final Class<?> REGISTRY_CLASS = MicrometerRecorder.getClassForName((String)"io.micrometer.stackdriver.StackdriverMeterRegistry");

    @BuildStep(onlyIf={NativeBuild.class, StackdriverEnabled.class})
    MicrometerRegistryProviderBuildItem nativeModeNotSupported() {
        log.info((Object)"The Stackdriver meter registry does not support running in native mode.");
        return null;
    }

    @BuildStep(onlyIf={StackdriverEnabled.class}, onlyIfNot={NativeBuild.class})
    MicrometerRegistryProviderBuildItem createStackdriverRegistry(CombinedIndexBuildItem index, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(StackdriverMeterRegistryProvider.class).setUnremovable().build());
        return new MicrometerRegistryProviderBuildItem(REGISTRY_CLASS);
    }

    static class StackdriverEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        StackdriverEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return REGISTRY_CLASS != null && this.mConfig.checkRegistryEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.export.stackdriver);
        }
    }
}

