/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.export;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.micrometer.deployment.MicrometerRegistryProviderBuildItem;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import io.quarkus.micrometer.runtime.export.StatsdMeterRegistryProvider;
import java.util.function.BooleanSupplier;
import org.jboss.logging.Logger;

public class StatsdRegistryProcessor {
    private static final Logger log = Logger.getLogger(StatsdRegistryProcessor.class);
    static final String REGISTRY_CLASS_NAME = "io.micrometer.statsd.StatsdMeterRegistry";
    static final Class<?> REGISTRY_CLASS = MicrometerRecorder.getClassForName((String)"io.micrometer.statsd.StatsdMeterRegistry");

    @BuildStep(onlyIf={NativeBuild.class, StatsdRegistryEnabled.class})
    MicrometerRegistryProviderBuildItem nativeModeNotSupported() {
        log.info((Object)"The StatsD meter registry does not support running in native mode.");
        return null;
    }

    @BuildStep(onlyIf={StatsdRegistryEnabled.class}, onlyIfNot={NativeBuild.class})
    MicrometerRegistryProviderBuildItem createStatsdRegistry(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(StatsdMeterRegistryProvider.class).setUnremovable().build());
        return new MicrometerRegistryProviderBuildItem(REGISTRY_CLASS);
    }

    public static class StatsdRegistryEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        @Override
        public boolean getAsBoolean() {
            return REGISTRY_CLASS != null && this.mConfig.checkRegistryEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.export.statsd);
        }
    }
}

