/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.binder;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;

public class HttpClientProcessor {
    private static final String REST_CLIENT_LISTENER_CLASS_NAME = "org.eclipse.microprofile.rest.client.spi.RestClientListener";
    private static final Class<?> REST_CLIENT_LISTENER_CLASS = MicrometerRecorder.getClassForName((String)"org.eclipse.microprofile.rest.client.spi.RestClientListener");
    private static final String REST_CLIENT_METRICS_LISTENER = "io.quarkus.micrometer.runtime.binder.RestClientMetrics";
    private static final String REST_CLIENT_HTTP_CONFIG = "io.quarkus.micrometer.runtime.config.runtime.HttpClientConfig";

    @BuildStep(onlyIf={HttpClientEnabled.class})
    UnremovableBeanBuildItem registerRestClientListener(BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.eclipse.microprofile.rest.client.spi.RestClientListener"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{REST_CLIENT_METRICS_LISTENER}));
        return new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion(REST_CLIENT_HTTP_CONFIG));
    }

    static class HttpClientEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        HttpClientEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return REST_CLIENT_LISTENER_CLASS != null && this.mConfig.checkBinderEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.binder.httpClient);
        }
    }
}

