/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.binder;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.binder.vertx.VertxMeterBinderAdapter;
import io.quarkus.micrometer.runtime.binder.vertx.VertxMeterBinderRecorder;
import io.quarkus.micrometer.runtime.binder.vertx.VertxMeterFilter;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import io.quarkus.micrometer.runtime.config.runtime.VertxConfig;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.reactive.spi.ContainerRequestFilterBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomContainerRequestFilterBuildItem;
import io.quarkus.vertx.core.deployment.VertxOptionsConsumerBuildItem;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.vertx.core.Handler;
import java.util.function.BooleanSupplier;

public class VertxBinderProcessor {
    static final String METRIC_OPTIONS_CLASS_NAME = "io.vertx.core.metrics.MetricsOptions";
    static final Class<?> METRIC_OPTIONS_CLASS = MicrometerRecorder.getClassForName((String)"io.vertx.core.metrics.MetricsOptions");
    static final String RESTEASY_CONTAINER_FILTER_CLASS_NAME = "io.quarkus.micrometer.runtime.binder.vertx.VertxMeterBinderRestEasyContainerFilter";
    static final String QUARKUS_REST_CONTAINER_FILTER_CLASS_NAME = "io.quarkus.micrometer.runtime.binder.vertx.VertxMeterBinderQuarkusRestContainerFilter";

    @BuildStep(onlyIf={VertxBinderEnabled.class})
    void enableJaxRsSupport(Capabilities capabilities, BuildProducer<ResteasyJaxrsProviderBuildItem> resteasyJaxrsProviders, BuildProducer<ContainerRequestFilterBuildItem> containerRequestFilter, BuildProducer<CustomContainerRequestFilterBuildItem> customContainerRequestFilter, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        if (capabilities.isPresent(Capability.RESTEASY)) {
            resteasyJaxrsProviders.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(RESTEASY_CONTAINER_FILTER_CLASS_NAME));
            this.turnVertxBinderFilterIntoBean(additionalBeans, RESTEASY_CONTAINER_FILTER_CLASS_NAME);
        } else if (capabilities.isPresent(Capability.RESTEASY_REACTIVE)) {
            customContainerRequestFilter.produce((BuildItem)new CustomContainerRequestFilterBuildItem(QUARKUS_REST_CONTAINER_FILTER_CLASS_NAME));
            this.turnVertxBinderFilterIntoBean(additionalBeans, QUARKUS_REST_CONTAINER_FILTER_CLASS_NAME);
        }
    }

    private void turnVertxBinderFilterIntoBean(BuildProducer<AdditionalBeanBuildItem> additionalBeans, String className) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(className).setUnremovable().build());
    }

    @BuildStep(onlyIf={VertxBinderEnabled.class})
    AdditionalBeanBuildItem createVertxAdapters() {
        return AdditionalBeanBuildItem.builder().addBeanClass(VertxMeterBinderAdapter.class).setUnremovable().build();
    }

    @BuildStep(onlyIf={VertxBinderEnabled.class})
    FilterBuildItem addVertxMeterFilter() {
        return new FilterBuildItem((Handler)new VertxMeterFilter(), Integer.MAX_VALUE);
    }

    @BuildStep(onlyIf={VertxBinderEnabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    VertxOptionsConsumerBuildItem build(VertxMeterBinderRecorder recorder) {
        return new VertxOptionsConsumerBuildItem(recorder.configureMetricsAdapter(), 3000);
    }

    @BuildStep(onlyIf={VertxBinderEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setVertxConfig(VertxMeterBinderRecorder recorder, VertxConfig config) {
        recorder.setVertxConfig(config);
    }

    static class VertxBinderEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        VertxBinderEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return METRIC_OPTIONS_CLASS != null && this.mConfig.checkBinderEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.binder.vertx);
        }
    }
}

