/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.binder;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.binder.vertx.VertxMeterBinderAdapter;
import io.quarkus.micrometer.runtime.binder.vertx.VertxMeterBinderRecorder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import io.quarkus.micrometer.runtime.config.runtime.VertxConfig;
import io.quarkus.vertx.core.deployment.VertxOptionsConsumerBuildItem;
import java.util.function.BooleanSupplier;

public class VertxBinderProcessor {
    static final String METRIC_OPTIONS_CLASS_NAME = "io.vertx.core.metrics.MetricsOptions";
    static final Class<?> METRIC_OPTIONS_CLASS = MicrometerRecorder.getClassForName((String)"io.vertx.core.metrics.MetricsOptions");

    @BuildStep(onlyIf={VertxBinderEnabled.class})
    AdditionalBeanBuildItem createVertxAdapters() {
        return AdditionalBeanBuildItem.builder().addBeanClass(VertxMeterBinderAdapter.class).setUnremovable().build();
    }

    @BuildStep(onlyIf={VertxBinderEnabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    VertxOptionsConsumerBuildItem build(VertxMeterBinderRecorder recorder) {
        return new VertxOptionsConsumerBuildItem(recorder.configureMetricsAdapter(), 3000);
    }

    @BuildStep(onlyIf={VertxBinderEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    void setVertxConfig(VertxMeterBinderRecorder recorder, VertxConfig config) {
        recorder.setVertxConfig(config);
    }

    static class VertxBinderEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        VertxBinderEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return METRIC_OPTIONS_CLASS != null && this.mConfig.checkBinderEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.binder.vertx);
        }
    }
}

