/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.export;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.micrometer.deployment.MicrometerRegistryProviderBuildItem;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import io.quarkus.micrometer.runtime.export.DatadogMeterRegistryProvider;
import java.util.function.BooleanSupplier;

public class DatadogRegistryProcessor {
    static final String REGISTRY_CLASS_NAME = "io.micrometer.datadog.DatadogMeterRegistry";
    static final Class<?> REGISTRY_CLASS = MicrometerRecorder.getClassForName((String)"io.micrometer.datadog.DatadogMeterRegistry");

    @BuildStep(onlyIf={DatadogEnabled.class})
    MicrometerRegistryProviderBuildItem createDatadogRegistry(CombinedIndexBuildItem index, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(DatadogMeterRegistryProvider.class).setUnremovable().build());
        return new MicrometerRegistryProviderBuildItem(REGISTRY_CLASS);
    }

    static class DatadogEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        DatadogEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return REGISTRY_CLASS != null && this.mConfig.checkRegistryEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.export.datadog);
        }
    }
}

