/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.export;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.micrometer.deployment.MicrometerRegistryProviderBuildItem;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import io.quarkus.micrometer.runtime.config.PrometheusConfigGroup;
import io.quarkus.micrometer.runtime.export.PrometheusMeterRegistryProvider;
import io.quarkus.micrometer.runtime.export.PrometheusRecorder;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.vertx.core.Handler;
import java.util.function.BooleanSupplier;
import org.jboss.logging.Logger;

public class PrometheusRegistryProcessor {
    private static final Logger log = Logger.getLogger(PrometheusRegistryProcessor.class);
    static final String REGISTRY_CLASS_NAME = "io.micrometer.prometheus.PrometheusMeterRegistry";
    static final Class<?> REGISTRY_CLASS = MicrometerRecorder.getClassForName((String)"io.micrometer.prometheus.PrometheusMeterRegistry");

    @BuildStep(onlyIf={PrometheusEnabled.class})
    MicrometerRegistryProviderBuildItem createPrometheusRegistry(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(PrometheusMeterRegistryProvider.class).setUnremovable().build());
        return new MicrometerRegistryProviderBuildItem(REGISTRY_CLASS);
    }

    @BuildStep(onlyIf={PrometheusEnabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void createPrometheusRoute(BuildProducer<RouteBuildItem> routes, MicrometerConfig mConfig, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, PrometheusRecorder recorder) {
        PrometheusConfigGroup pConfig = mConfig.export.prometheus;
        log.debug((Object)("PROMETHEUS CONFIG: " + pConfig));
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().routeFunction(pConfig.path, recorder.route()).handler((Handler)recorder.getHandler()).displayOnNotFoundPage("Metrics").build());
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().routeFunction(pConfig.path + (pConfig.path.endsWith("/") ? "*" : "/*"), recorder.route()).handler((Handler)recorder.getHandler()).build());
    }

    public static class PrometheusEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        @Override
        public boolean getAsBoolean() {
            return REGISTRY_CLASS != null && this.mConfig.checkRegistryEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.export.prometheus);
        }
    }
}

