/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment;

import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.InterceptorBindingRegistrarBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InterceptorBindingRegistrar;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.metrics.MetricsFactoryConsumerBuildItem;
import io.quarkus.micrometer.deployment.MicrometerRegistryProviderBuildItem;
import io.quarkus.micrometer.deployment.RootMeterRegistryBuildItem;
import io.quarkus.micrometer.deployment.export.PrometheusRegistryProcessor;
import io.quarkus.micrometer.runtime.ClockProvider;
import io.quarkus.micrometer.runtime.CompositeRegistryCreator;
import io.quarkus.micrometer.runtime.MeterFilterConstraint;
import io.quarkus.micrometer.runtime.MeterFilterConstraints;
import io.quarkus.micrometer.runtime.MicrometerCounted;
import io.quarkus.micrometer.runtime.MicrometerCountedInterceptor;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.MicrometerTimedInterceptor;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

public class MicrometerProcessor {
    private static final DotName METER_REGISTRY = DotName.createSimple((String)MeterRegistry.class.getName());
    private static final DotName METER_BINDER = DotName.createSimple((String)MeterBinder.class.getName());
    private static final DotName METER_FILTER = DotName.createSimple((String)MeterFilter.class.getName());
    private static final DotName NAMING_CONVENTION = DotName.createSimple((String)NamingConvention.class.getName());
    private static final DotName COUNTED_ANNOTATION = DotName.createSimple((String)Counted.class.getName());
    private static final DotName COUNTED_BINDING = DotName.createSimple((String)MicrometerCounted.class.getName());
    private static final DotName COUNTED_INTERCEPTOR = DotName.createSimple((String)MicrometerCountedInterceptor.class.getName());
    private static final DotName TIMED_ANNOTATION = DotName.createSimple((String)Timed.class.getName());
    private static final DotName TIMED_INTERCEPTOR = DotName.createSimple((String)MicrometerTimedInterceptor.class.getName());
    MicrometerConfig mConfig;

    @BuildStep(onlyIf={MicrometerEnabled.class})
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.MICROMETER);
    }

    @BuildStep(onlyIf={MicrometerEnabled.class}, onlyIfNot={PrometheusRegistryProcessor.PrometheusEnabled.class})
    MetricsCapabilityBuildItem metricsCapabilityBuildItem() {
        return new MetricsCapabilityBuildItem("micrometer"::equals, null);
    }

    @BuildStep(onlyIf={MicrometerEnabled.class, PrometheusRegistryProcessor.PrometheusEnabled.class})
    MetricsCapabilityBuildItem metricsCapabilityPrometheusBuildItem(NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        return new MetricsCapabilityBuildItem("micrometer"::equals, nonApplicationRootPathBuildItem.resolvePath(this.mConfig.export.prometheus.path));
    }

    @BuildStep(onlyIf={MicrometerEnabled.class})
    UnremovableBeanBuildItem registerAdditionalBeans(CombinedIndexBuildItem indexBuildItem, BuildProducer<MicrometerRegistryProviderBuildItem> providerClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<InterceptorBindingRegistrarBuildItem> interceptorBindings) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(ClockProvider.class).addBeanClass(CompositeRegistryCreator.class).build());
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(MeterFilterConstraint.class).addBeanClass(MeterFilterConstraints.class).addBeanClass(TIMED_ANNOTATION.toString()).addBeanClass(TIMED_INTERCEPTOR.toString()).addBeanClass(COUNTED_ANNOTATION.toString()).addBeanClass(COUNTED_BINDING.toString()).addBeanClass(COUNTED_INTERCEPTOR.toString()).build());
        interceptorBindings.produce((BuildItem)new InterceptorBindingRegistrarBuildItem(new InterceptorBindingRegistrar(){

            public List<InterceptorBindingRegistrar.InterceptorBinding> getAdditionalBindings() {
                return List.of(InterceptorBindingRegistrar.InterceptorBinding.of(Timed.class, m -> true));
            }
        }));
        IndexView index = indexBuildItem.getIndex();
        HashSet<String> knownRegistries = new HashSet<String>();
        this.collectNames(index.getAllKnownSubclasses(METER_REGISTRY), knownRegistries);
        HashSet<String> knownClasses = new HashSet<String>();
        knownClasses.add(METER_BINDER.toString());
        this.collectNames(index.getAllKnownImplementors(METER_BINDER), knownClasses);
        knownClasses.add(METER_FILTER.toString());
        this.collectNames(index.getAllKnownImplementors(METER_FILTER), knownClasses);
        knownClasses.add(NAMING_CONVENTION.toString());
        this.collectNames(index.getAllKnownImplementors(NAMING_CONVENTION), knownClasses);
        HashSet<String> keepMe = new HashSet<String>();
        for (AnnotationInstance annotation : index.getAnnotations(DotNames.PRODUCES)) {
            AnnotationTarget target = annotation.target();
            switch (target.kind()) {
                case METHOD: {
                    MethodInfo method = target.asMethod();
                    String returnType = method.returnType().name().toString();
                    if (knownRegistries.contains(returnType)) {
                        providerClasses.produce((BuildItem)new MicrometerRegistryProviderBuildItem(returnType));
                        keepMe.add(method.declaringClass().name().toString());
                        break;
                    }
                    if (!knownClasses.contains(returnType)) break;
                    keepMe.add(method.declaringClass().name().toString());
                    break;
                }
                case FIELD: {
                    FieldInfo field = target.asField();
                    String fieldType = field.type().name().toString();
                    if (knownRegistries.contains(fieldType)) {
                        providerClasses.produce((BuildItem)new MicrometerRegistryProviderBuildItem(fieldType));
                        keepMe.add(field.declaringClass().name().toString());
                        break;
                    }
                    if (!knownClasses.contains(fieldType)) break;
                    keepMe.add(field.declaringClass().name().toString());
                    break;
                }
            }
        }
        reflectiveClasses.produce((BuildItem)this.createReflectiveBuildItem(COUNTED_ANNOTATION, index));
        reflectiveClasses.produce((BuildItem)this.createReflectiveBuildItem(TIMED_ANNOTATION, index));
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.HdrHistogram.Histogram", "org.HdrHistogram.DoubleHistogram", "org.HdrHistogram.ConcurrentHistogram"}).constructors(true).build());
        return new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNamesExclusion(keepMe));
    }

    void collectNames(Collection<ClassInfo> classes, Collection<String> names) {
        for (ClassInfo info : classes) {
            names.add(info.name().toString());
        }
    }

    @BuildStep(onlyIf={MicrometerEnabled.class})
    AnnotationsTransformerBuildItem processAnnotatedMetrics(BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformers) {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.METHOD;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                Collection annotations = ctx.getAnnotations();
                AnnotationInstance counted = Annotations.find((Collection)annotations, (DotName)COUNTED_ANNOTATION);
                if (counted == null) {
                    return;
                }
                ((Transformation)ctx.transform().add(COUNTED_BINDING, counted.values().toArray(new AnnotationValue[0]))).done();
            }
        });
    }

    @BuildStep(onlyIf={MicrometerEnabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    RootMeterRegistryBuildItem createRootRegistry(MicrometerRecorder recorder, MicrometerConfig config, BeanContainerBuildItem beanContainerBuildItem) {
        RuntimeValue registry = recorder.createRootRegistry(config);
        return new RootMeterRegistryBuildItem((RuntimeValue<MeterRegistry>)registry);
    }

    @BuildStep(onlyIf={MicrometerEnabled.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerExtensionMetrics(MicrometerRecorder recorder, RootMeterRegistryBuildItem rootMeterRegistryBuildItem, List<MetricsFactoryConsumerBuildItem> metricsFactoryConsumerBuildItems) {
        for (MetricsFactoryConsumerBuildItem item : metricsFactoryConsumerBuildItems) {
            if (item == null || item.executionTime() != ExecutionTime.STATIC_INIT) continue;
            recorder.registerMetrics(item.getConsumer());
        }
    }

    @BuildStep(onlyIf={MicrometerEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void configureRegistry(MicrometerRecorder recorder, MicrometerConfig config, RootMeterRegistryBuildItem rootMeterRegistryBuildItem, List<MicrometerRegistryProviderBuildItem> providerClassItems, List<MetricsFactoryConsumerBuildItem> metricsFactoryConsumerBuildItems, List<MicrometerRegistryProviderBuildItem> providerClasses, ShutdownContextBuildItem shutdownContextBuildItem) {
        HashSet<Class<? extends MeterRegistry>> typeClasses = new HashSet<Class<? extends MeterRegistry>>();
        for (MicrometerRegistryProviderBuildItem micrometerRegistryProviderBuildItem : providerClassItems) {
            typeClasses.add(micrometerRegistryProviderBuildItem.getRegistryClass());
        }
        recorder.configureRegistries(config, typeClasses, (ShutdownContext)shutdownContextBuildItem);
        for (MetricsFactoryConsumerBuildItem metricsFactoryConsumerBuildItem : metricsFactoryConsumerBuildItems) {
            if (metricsFactoryConsumerBuildItem == null || metricsFactoryConsumerBuildItem.executionTime() != ExecutionTime.RUNTIME_INIT) continue;
            recorder.registerMetrics(metricsFactoryConsumerBuildItem.getConsumer());
        }
    }

    ReflectiveClassBuildItem createReflectiveBuildItem(DotName sourceAnnotation, IndexView index) {
        HashSet<String> classes = new HashSet<String>();
        for (AnnotationInstance annotation : index.getAnnotations(sourceAnnotation)) {
            AnnotationTarget target = annotation.target();
            switch (target.kind()) {
                case METHOD: {
                    MethodInfo method = target.asMethod();
                    classes.add(method.declaringClass().name().toString());
                    break;
                }
                case TYPE: {
                    classes.add(target.asClass().name().toString());
                    break;
                }
            }
        }
        return ReflectiveClassBuildItem.builder((String[])classes.toArray(new String[0])).build();
    }

    public static class MicrometerEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        @Override
        public boolean getAsBoolean() {
            return this.mConfig.enabled;
        }
    }
}

