/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.binder;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.micrometer.deployment.MicrometerProcessor;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import io.quarkus.micrometer.runtime.config.runtime.HttpClientConfig;
import io.quarkus.micrometer.runtime.config.runtime.HttpServerConfig;
import io.quarkus.micrometer.runtime.config.runtime.VertxConfig;
import io.quarkus.undertow.deployment.FilterBuildItem;
import java.util.function.BooleanSupplier;
import javax.inject.Singleton;
import javax.servlet.DispatcherType;

public class HttpBinderProcessor {
    static final String HTTP_METER_FILTER_CONFIGURATION = "io.quarkus.micrometer.runtime.binder.HttpMeterFilterProvider";
    static final String RESTEASY_CONTAINER_FILTER_CLASS_NAME = "io.quarkus.micrometer.runtime.binder.vertx.VertxMeterBinderRestEasyContainerFilter";
    static final String RESTEASY_REACTIVE_CONTAINER_FILTER_CLASS_NAME = "io.quarkus.micrometer.runtime.binder.vertx.VertxMeterBinderRestEasyReactiveContainerFilter";
    static final String UNDERTOW_SERVLET_FILTER_CLASS_NAME = "io.quarkus.micrometer.runtime.binder.vertx.VertxMeterBinderUndertowServletFilter";
    private static final String REST_CLIENT_LISTENER_CLASS_NAME = "org.eclipse.microprofile.rest.client.spi.RestClientListener";
    private static final Class<?> REST_CLIENT_LISTENER_CLASS = MicrometerRecorder.getClassForName((String)"org.eclipse.microprofile.rest.client.spi.RestClientListener");
    private static final String REST_CLIENT_METRICS_LISTENER = "io.quarkus.micrometer.runtime.binder.RestClientMetricsListener";

    @BuildStep(onlyIf={MicrometerProcessor.MicrometerEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    SyntheticBeanBuildItem enableHttpBinders(MicrometerRecorder recorder, MicrometerConfig buildTimeConfig, HttpServerConfig serverConfig, HttpClientConfig clientConfig, VertxConfig vertxConfig, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        boolean clientEnabled = buildTimeConfig.checkBinderEnabledWithDefault((MicrometerConfig.CapabilityEnabled)buildTimeConfig.binder.httpClient);
        boolean serverEnabled = buildTimeConfig.checkBinderEnabledWithDefault((MicrometerConfig.CapabilityEnabled)buildTimeConfig.binder.httpServer);
        if (clientEnabled || serverEnabled) {
            this.createAdditionalBean(additionalBeans, HTTP_METER_FILTER_CONFIGURATION);
        }
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(HttpBinderConfiguration.class).scope(Singleton.class)).setRuntimeInit().unremovable()).runtimeValue(recorder.configureHttpMetrics(serverEnabled, clientEnabled, serverConfig, clientConfig, vertxConfig)).done();
    }

    @BuildStep(onlyIf={HttpServerBinderEnabled.class})
    void enableHttpServerSupport(Capabilities capabilities, BuildProducer<FilterBuildItem> servletFilters, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        if (capabilities.isPresent("io.quarkus.servlet")) {
            servletFilters.produce((BuildItem)FilterBuildItem.builder((String)"metricsFilter", (String)UNDERTOW_SERVLET_FILTER_CLASS_NAME).setAsyncSupported(true).addFilterUrlMapping("*", DispatcherType.FORWARD).addFilterUrlMapping("*", DispatcherType.INCLUDE).addFilterUrlMapping("*", DispatcherType.REQUEST).addFilterUrlMapping("*", DispatcherType.ASYNC).addFilterUrlMapping("*", DispatcherType.ERROR).build());
            this.createAdditionalBean(additionalBeans, UNDERTOW_SERVLET_FILTER_CLASS_NAME);
        }
    }

    @BuildStep(onlyIf={HttpClientBinderEnabled.class})
    void registerRestClientListener(BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.eclipse.microprofile.rest.client.spi.RestClientListener"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{REST_CLIENT_METRICS_LISTENER}));
    }

    private void createAdditionalBean(BuildProducer<AdditionalBeanBuildItem> additionalBeans, String className) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(className).setUnremovable().build());
    }

    static class HttpClientBinderEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        HttpClientBinderEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return REST_CLIENT_LISTENER_CLASS != null && this.mConfig.checkBinderEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.binder.httpClient);
        }
    }

    static class HttpServerBinderEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        HttpServerBinderEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.mConfig.checkBinderEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.binder.vertx) && this.mConfig.checkBinderEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.binder.httpServer);
        }
    }
}

