/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.MeterRegistry;
import io.quarkus.micrometer.runtime.binder.vertx.VertxHttpServerMetrics;
import io.quarkus.micrometer.runtime.config.runtime.VertxConfig;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class VertxMeterBinderAdapter
extends MetricsOptions
implements VertxMetricsFactory,
VertxMetrics {
    private static final Logger log = Logger.getLogger(VertxMeterBinderAdapter.class);
    private static final AtomicReference<MeterRegistry> meterRegistryRef = new AtomicReference();
    private VertxConfig config;

    public void setVertxConfig(VertxConfig config) {
        this.config = config;
    }

    public static void setMeterRegistry(MeterRegistry meterRegistry) {
        meterRegistryRef.set(meterRegistry);
    }

    public boolean isEnabled() {
        return true;
    }

    public VertxMetricsFactory getFactory() {
        return this;
    }

    public VertxMetrics metrics(VertxOptions vertxOptions) {
        return this;
    }

    public MetricsOptions newOptions() {
        return this;
    }

    public HttpServerMetrics<?, ?, ?> createHttpServerMetrics(HttpServerOptions options, SocketAddress localAddress) {
        log.debugf("Create HttpServerMetrics with options %s and address %s", (Object)options, (Object)localAddress);
        log.debugf("Bind registry %s to Vertx Metrics", (Object)meterRegistryRef.get());
        MeterRegistry registry = meterRegistryRef.get();
        if (registry == null) {
            throw new IllegalStateException("MeterRegistry was not resolved");
        }
        if (this.config == null) {
            throw new IllegalStateException("VertxConfig was not found");
        }
        return new VertxHttpServerMetrics(registry, this.config);
    }
}

