/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.http.Outcome;
import io.quarkus.micrometer.runtime.binder.vertx.RequestMetric;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class VertxMetricsTags {
    private static final Logger log = Logger.getLogger(VertxMetricsTags.class);
    static final Tag URI_NOT_FOUND = Tag.of((String)"uri", (String)"NOT_FOUND");
    static final Tag URI_REDIRECTION = Tag.of((String)"uri", (String)"REDIRECTION");
    static final Tag URI_ROOT = Tag.of((String)"uri", (String)"root");
    static final Tag URI_UNKNOWN = Tag.of((String)"uri", (String)"UNKNOWN");
    static final Tag STATUS_UNKNOWN = Tag.of((String)"status", (String)"UNKNOWN");
    static final Tag STATUS_RESET = Tag.of((String)"status", (String)"RESET");
    static final Tag METHOD_UNKNOWN = Tag.of((String)"method", (String)"UNKNOWN");
    private static final Pattern TRAILING_SLASH_PATTERN = Pattern.compile("/$");
    private static final Pattern MULTIPLE_SLASH_PATTERN = Pattern.compile("//+");

    public static Tag method(HttpMethod method) {
        return method != null ? Tag.of((String)"method", (String)method.toString()) : METHOD_UNKNOWN;
    }

    public static Tag status(int statusCode) {
        return statusCode > 0 ? Tag.of((String)"status", (String)Integer.toString(statusCode)) : STATUS_UNKNOWN;
    }

    public static Tag outcome(HttpServerResponse response) {
        if (response != null) {
            return Outcome.forStatus((int)response.getStatusCode()).asTag();
        }
        return Outcome.UNKNOWN.asTag();
    }

    public static Tag outcome(HttpClientResponse response) {
        if (response != null) {
            return Outcome.forStatus((int)response.statusCode()).asTag();
        }
        return Outcome.UNKNOWN.asTag();
    }

    public static Tag uri(String pathInfo, int code) {
        if (code > 0) {
            if (code / 100 == 3) {
                return URI_REDIRECTION;
            }
            if (code == 404) {
                return URI_NOT_FOUND;
            }
        }
        if (pathInfo == null) {
            return URI_UNKNOWN;
        }
        if (pathInfo.isEmpty() || "/".equals(pathInfo)) {
            return URI_ROOT;
        }
        return Tag.of((String)"uri", (String)pathInfo);
    }

    static void parseUriPath(RequestMetric requestMetric, Map<Pattern, String> matchPattern, List<Pattern> ignorePatterns, String uri) {
        if (uri == null) {
            return;
        }
        String path = "/" + VertxMetricsTags.extractPath(uri);
        path = MULTIPLE_SLASH_PATTERN.matcher(path).replaceAll("/");
        if ((path = TRAILING_SLASH_PATTERN.matcher(path).replaceAll("")).isEmpty()) {
            path = "/";
        }
        requestMetric.path = path;
        for (Map.Entry<Pattern, String> mp : matchPattern.entrySet()) {
            requestMetric.path = mp.getKey().matcher(requestMetric.path).replaceAll(mp.getValue());
        }
        requestMetric.pathMatched = !path.equals(requestMetric.path);
        for (Pattern p : ignorePatterns) {
            if (!p.matcher(path).matches()) continue;
            log.debugf("Path %s ignored; matches pattern %s", (Object)uri, (Object)p.pattern());
            return;
        }
        requestMetric.measure = true;
    }

    private static String extractPath(String uri) {
        int i;
        if (uri.isEmpty()) {
            return uri;
        }
        if (uri.charAt(0) == '/') {
            i = 0;
        } else {
            i = uri.indexOf("://");
            if (i == -1) {
                i = 0;
            } else if ((i = uri.indexOf(47, i + 3)) == -1) {
                return "/";
            }
        }
        int queryStart = uri.indexOf(63, i);
        if (queryStart == -1) {
            queryStart = uri.length();
        }
        return uri.substring(i, queryStart);
    }
}

