/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.export;

import io.micrometer.core.instrument.Clock;
import io.micrometer.statsd.StatsdConfig;
import io.micrometer.statsd.StatsdMeterRegistry;
import io.quarkus.arc.DefaultBean;
import io.quarkus.micrometer.runtime.export.ConfigAdapter;
import java.util.Map;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;

@Singleton
public class StatsdMeterRegistryProvider {
    private static final Logger log = Logger.getLogger(StatsdMeterRegistryProvider.class);
    static final String PREFIX = "quarkus.micrometer.export.statsd.";
    static final String PUBLISH = "statsd.publish";
    static final String ENABLED = "statsd.enabled";

    @Produces
    @Singleton
    @DefaultBean
    public StatsdConfig configure(Config config) {
        final Map<String, String> properties = ConfigAdapter.captureProperties(config, PREFIX);
        if (properties.containsKey(PUBLISH)) {
            properties.put(ENABLED, properties.get(PUBLISH));
        }
        return ConfigAdapter.validate(new StatsdConfig(){

            public String get(String key) {
                return (String)properties.get(key);
            }
        });
    }

    @Produces
    @Singleton
    public StatsdMeterRegistry registry(StatsdConfig config, Clock clock) {
        return new StatsdMeterRegistry(config, clock);
    }
}

