/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.registry.json;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.quarkus.micrometer.runtime.registry.json.JsonDistributionSummary;
import io.quarkus.micrometer.runtime.registry.json.JsonMeterRegistry;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.spi.JsonProvider;

public class JsonExporter {
    private static final Map<String, ?> JSON_CONFIG = Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true);
    private static final JsonProvider JSON_PROVIDER = JsonProvider.provider();

    public StringBuilder exportEverything(JsonMeterRegistry meterRegistry) {
        JsonObjectBuilder root = JSON_PROVIDER.createObjectBuilder();
        ArrayList<Gauge> gauges = new ArrayList<Gauge>();
        ArrayList<Counter> counters = new ArrayList<Counter>();
        ArrayList<TimeGauge> timeGauges = new ArrayList<TimeGauge>();
        ArrayList<FunctionCounter> functionCounters = new ArrayList<FunctionCounter>();
        ArrayList<Timer> timers = new ArrayList<Timer>();
        ArrayList<LongTaskTimer> longTaskTimers = new ArrayList<LongTaskTimer>();
        ArrayList<FunctionTimer> functionTimers = new ArrayList<FunctionTimer>();
        ArrayList<DistributionSummary> distributionSummaries = new ArrayList<DistributionSummary>();
        ArrayList meters = new ArrayList();
        meterRegistry.getMeters().forEach(meter -> {
            Boolean cfr_ignored_0 = (Boolean)meter.match(gauges::add, counters::add, timers::add, distributionSummaries::add, longTaskTimers::add, timeGauges::add, functionCounters::add, functionTimers::add, meters::add);
        });
        this.exportCounters(counters).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)root).add(arg_0, arg_1));
        this.exportGauges(gauges).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)root).add(arg_0, arg_1));
        this.exportTimeGauges(timeGauges).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)root).add(arg_0, arg_1));
        this.exportFunctionCounters(functionCounters).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)root).add(arg_0, arg_1));
        this.exportTimers(timers).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)root).add(arg_0, arg_1));
        this.exportLongTaskTimers(longTaskTimers).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)root).add(arg_0, arg_1));
        this.exportFunctionTimers(functionTimers).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)root).add(arg_0, arg_1));
        this.exportDistributionSummaries(distributionSummaries).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)root).add(arg_0, arg_1));
        return this.stringify(root.build());
    }

    private Map<String, JsonValue> exportGauges(Collection<Gauge> gauges) {
        return gauges.stream().collect(Collectors.toMap(gauge -> this.createExportKey(gauge.getId()), gauge -> JSON_PROVIDER.createValue(gauge.value())));
    }

    private Map<String, JsonValue> exportTimeGauges(Collection<TimeGauge> timeGauges) {
        return timeGauges.stream().collect(Collectors.toMap(gauge -> this.createExportKey(gauge.getId()), gauge -> JSON_PROVIDER.createValue(gauge.value())));
    }

    private Map<String, JsonValue> exportCounters(Collection<Counter> counters) {
        return counters.stream().collect(Collectors.toMap(counter -> this.createExportKey(counter.getId()), counter -> JSON_PROVIDER.createValue(counter.count())));
    }

    private Map<String, JsonValue> exportFunctionCounters(Collection<FunctionCounter> counters) {
        return counters.stream().collect(Collectors.toMap(counter -> this.createExportKey(counter.getId()), counter -> JSON_PROVIDER.createValue(counter.count())));
    }

    private Map<String, JsonValue> exportTimers(Collection<Timer> timers) {
        Map<String, List<Timer>> groups = timers.stream().collect(Collectors.groupingBy(timer -> timer.getId().getName()));
        HashMap<String, JsonValue> result = new HashMap<String, JsonValue>();
        for (Map.Entry<String, List<Timer>> group : groups.entrySet()) {
            JsonObjectBuilder builder = JSON_PROVIDER.createObjectBuilder();
            for (Timer timer2 : group.getValue()) {
                builder.add(this.createExportKey("count", timer2.getId()), timer2.count());
                builder.add(this.createExportKey("elapsedTime", timer2.getId()), timer2.totalTime(timer2.baseTimeUnit()));
            }
            result.put(group.getKey(), (JsonValue)builder.build());
        }
        return result;
    }

    private Map<String, JsonValue> exportLongTaskTimers(Collection<LongTaskTimer> timers) {
        Map<String, List<LongTaskTimer>> groups = timers.stream().collect(Collectors.groupingBy(timer -> timer.getId().getName()));
        HashMap<String, JsonValue> result = new HashMap<String, JsonValue>();
        for (Map.Entry<String, List<LongTaskTimer>> group : groups.entrySet()) {
            JsonObjectBuilder builder = JSON_PROVIDER.createObjectBuilder();
            for (LongTaskTimer timer2 : group.getValue()) {
                builder.add(this.createExportKey("activeTasks", timer2.getId()), timer2.activeTasks());
                builder.add(this.createExportKey("duration", timer2.getId()), timer2.duration(timer2.baseTimeUnit()));
                builder.add(this.createExportKey("max", timer2.getId()), timer2.max(timer2.baseTimeUnit()));
                builder.add(this.createExportKey("mean", timer2.getId()), timer2.mean(timer2.baseTimeUnit()));
            }
            result.put(group.getKey(), (JsonValue)builder.build());
        }
        return result;
    }

    private Map<String, JsonValue> exportFunctionTimers(Collection<FunctionTimer> timers) {
        Map<String, List<FunctionTimer>> groups = timers.stream().collect(Collectors.groupingBy(timer -> timer.getId().getName()));
        HashMap<String, JsonValue> result = new HashMap<String, JsonValue>();
        for (Map.Entry<String, List<FunctionTimer>> group : groups.entrySet()) {
            JsonObjectBuilder builder = JSON_PROVIDER.createObjectBuilder();
            for (FunctionTimer timer2 : group.getValue()) {
                builder.add(this.createExportKey("count", timer2.getId()), timer2.count());
                builder.add(this.createExportKey("elapsedTime", timer2.getId()), timer2.totalTime(timer2.baseTimeUnit()));
            }
            result.put(group.getKey(), (JsonValue)builder.build());
        }
        return result;
    }

    private Map<String, JsonValue> exportDistributionSummaries(Collection<DistributionSummary> distributionSummaries) {
        Map<String, List<DistributionSummary>> groups = distributionSummaries.stream().collect(Collectors.groupingBy(summary -> summary.getId().getName()));
        HashMap<String, JsonValue> result = new HashMap<String, JsonValue>();
        for (Map.Entry<String, List<DistributionSummary>> group : groups.entrySet()) {
            JsonObjectBuilder builder = JSON_PROVIDER.createObjectBuilder();
            for (DistributionSummary summary2 : group.getValue()) {
                HistogramSnapshot snapshot = summary2.takeSnapshot();
                if (summary2 instanceof JsonDistributionSummary) {
                    double min = ((JsonDistributionSummary)summary2).min();
                    builder.add(this.createExportKey("min", summary2.getId()), !Double.isNaN(min) ? min : 0.0);
                }
                builder.add(this.createExportKey("count", summary2.getId()), snapshot.count());
                builder.add(this.createExportKey("max", summary2.getId()), snapshot.max());
                builder.add(this.createExportKey("mean", summary2.getId()), snapshot.mean());
                for (ValueAtPercentile valueAtPercentile : snapshot.percentileValues()) {
                    if (Math.abs(valueAtPercentile.percentile() - 0.999) < 1.0E-6) {
                        builder.add(this.createExportKey("p999", summary2.getId()), valueAtPercentile.value());
                        continue;
                    }
                    builder.add(this.createExportKey("p" + (int)Math.floor(valueAtPercentile.percentile() * 100.0), summary2.getId()), valueAtPercentile.value());
                }
            }
            result.put(group.getKey(), (JsonValue)builder.build());
        }
        return result;
    }

    private StringBuilder stringify(JsonObject obj) {
        StringWriter out = new StringWriter();
        try (JsonWriter writer = JSON_PROVIDER.createWriterFactory(JSON_CONFIG).createWriter((Writer)out);){
            writer.writeObject(obj);
        }
        return new StringBuilder(out.toString());
    }

    private String createExportKey(Meter.Id id) {
        return id.getName() + this.createTagsString(id.getTags());
    }

    private String createExportKey(String componentKey, Meter.Id id) {
        return componentKey + this.createTagsString(id.getTags());
    }

    private String createTagsString(List<Tag> tags) {
        if (tags == null || tags.isEmpty()) {
            return "";
        }
        return ";" + tags.stream().map(tag -> tag.getKey() + "=" + tag.getValue().replaceAll(";", "_")).collect(Collectors.joining(";"));
    }
}

