/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime;

import io.micrometer.core.annotation.Counted;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.quarkus.micrometer.runtime.MicrometerCounted;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import java.lang.reflect.Method;
import java.util.concurrent.CompletionStage;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@MicrometerCounted
@Priority(value=1010)
public class MicrometerCountedInterceptor {
    public final String RESULT_TAG_FAILURE_VALUE = "failure";
    public final String RESULT_TAG_SUCCESS_VALUE = "success";
    private final MeterRegistry meterRegistry;

    public MicrometerCountedInterceptor(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @AroundInvoke
    Object countedMethod(InvocationContext context) throws Exception {
        Method method = context.getMethod();
        Counted counted = method.getAnnotation(Counted.class);
        if (counted == null) {
            return context.proceed();
        }
        Tags commonTags = this.getCommonTags(method.getDeclaringClass().getName(), method.getName());
        boolean stopWhenCompleted = CompletionStage.class.isAssignableFrom(method.getReturnType());
        if (stopWhenCompleted) {
            try {
                return ((CompletionStage)context.proceed()).whenComplete((result, throwable) -> this.recordCompletionResult(counted, commonTags, (Throwable)throwable));
            }
            catch (Throwable e) {
                this.record(counted, commonTags, e);
            }
        }
        try {
            Object result2 = context.proceed();
            if (!counted.recordFailuresOnly()) {
                this.record(counted, commonTags, null);
            }
            return result2;
        }
        catch (Throwable e) {
            this.record(counted, commonTags, e);
            throw e;
        }
    }

    private void recordCompletionResult(Counted counted, Tags commonTags, Throwable throwable) {
        if (throwable != null) {
            this.record(counted, commonTags, throwable);
        } else if (!counted.recordFailuresOnly()) {
            this.record(counted, commonTags, null);
        }
    }

    private void record(Counted counted, Tags commonTags, Throwable throwable) {
        Counter.Builder builder = Counter.builder((String)counted.value()).tags((Iterable)commonTags).tags(counted.extraTags()).tag("exception", MicrometerRecorder.getExceptionTag(throwable)).tag("result", throwable == null ? "success" : "failure");
        String description = counted.description();
        if (!description.isEmpty()) {
            builder.description(description);
        }
        builder.register(this.meterRegistry).increment();
    }

    private Tags getCommonTags(String className, String methodName) {
        return Tags.of((String[])new String[]{"class", className, "method", methodName});
    }
}

