/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.mpmetrics;

import io.quarkus.micrometer.runtime.binder.mpmetrics.ConcurrentGaugeImpl;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MetricRegistryAdapter;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MpMetadata;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MpMetricsRegistryProducer;
import javax.annotation.Priority;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;

@ConcurrentGauge
@Interceptor
@Priority(value=1010)
class ConcurrentGaugeInterceptor {
    final MetricRegistryAdapter mpRegistry;

    ConcurrentGaugeInterceptor(MetricRegistryAdapter mpRegistry) {
        this.mpRegistry = mpRegistry;
    }

    @AroundConstruct
    Object cGaugeConstructor(InvocationContext context) throws Exception {
        return this.cGauge(context, context.getConstructor().getDeclaringClass().getSimpleName());
    }

    @AroundInvoke
    Object cGaugeMethod(InvocationContext context) throws Exception {
        return this.cGauge(context, context.getMethod().getName());
    }

    @AroundTimeout
    Object cGaugeTimeout(InvocationContext context) throws Exception {
        return this.cGauge(context, context.getMethod().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object cGauge(InvocationContext context, String methodName) throws Exception {
        ConcurrentGauge annotation = MpMetricsRegistryProducer.getAnnotation(context, ConcurrentGauge.class);
        if (annotation != null) {
            MpMetadata metadata = new MpMetadata(annotation.name().replace("<method>", methodName), annotation.description().replace("<method>", methodName), annotation.unit(), MetricType.CONCURRENT_GAUGE);
            ConcurrentGaugeImpl impl = this.mpRegistry.interceptorConcurrentGauge(metadata, annotation.tags());
            try {
                impl.inc();
                Object object = context.proceed();
                return object;
            }
            finally {
                impl.dec();
            }
        }
        return context.proceed();
    }
}

