/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.http.Outcome;
import io.quarkus.micrometer.runtime.binder.vertx.RequestMetric;
import io.quarkus.micrometer.runtime.binder.vertx.VertxMetricsTags;
import io.quarkus.micrometer.runtime.binder.vertx.VertxTcpMetrics;
import io.quarkus.micrometer.runtime.config.runtime.VertxConfig;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jboss.logging.Logger;

public class VertxHttpServerMetrics
extends VertxTcpMetrics
implements HttpServerMetrics<RequestMetric, LongTaskTimer.Sample, Map<String, Object>> {
    static final Logger log = Logger.getLogger(VertxHttpServerMetrics.class);
    final List<Pattern> ignorePatterns;
    final Map<Pattern, String> matchPatterns;
    final String nameWebsocketConnections;
    final String nameHttpServerPush;
    final String nameHttpServerRequests;

    VertxHttpServerMetrics(MeterRegistry registry, VertxConfig config) {
        super(registry, "http.server");
        List<String> stringPatterns;
        this.nameWebsocketConnections = "http.server.websocket.connections";
        this.nameHttpServerPush = "http.server.push";
        this.nameHttpServerRequests = "http.server.requests";
        if (config.ignorePatterns.isPresent()) {
            stringPatterns = config.ignorePatterns.get();
            this.ignorePatterns = new ArrayList<Pattern>(stringPatterns.size());
            for (String s : stringPatterns) {
                this.ignorePatterns.add(Pattern.compile(s));
            }
        } else {
            this.ignorePatterns = Collections.emptyList();
        }
        if (config.matchPatterns.isPresent()) {
            stringPatterns = config.matchPatterns.get();
            this.matchPatterns = new HashMap<Pattern, String>(stringPatterns.size());
            for (String s : stringPatterns) {
                int pos = s.indexOf("=");
                if (pos > 0 && s.length() > 2) {
                    String pattern = s.substring(0, pos);
                    String replacement = s.substring(pos + 1);
                    try {
                        this.matchPatterns.put(Pattern.compile(pattern), replacement);
                    }
                    catch (PatternSyntaxException pse) {
                        log.errorf("Invalid pattern in replacement string (%s=%s): %s", (Object)pattern, (Object)replacement, (Object)pse);
                    }
                    continue;
                }
                log.errorf("Invalid pattern in replacement string (%s). Should be pattern=replacement", (Object)s);
            }
        } else {
            this.matchPatterns = Collections.emptyMap();
        }
    }

    public RequestMetric responsePushed(Map<String, Object> socketMetric, HttpMethod method, String uri, HttpServerResponse response) {
        RequestMetric requestMetric = new RequestMetric();
        VertxMetricsTags.parseUriPath(requestMetric, this.matchPatterns, this.ignorePatterns, uri);
        if (requestMetric.measure) {
            this.registry.counter(this.nameHttpServerPush, (Iterable)Tags.of((Tag[])new Tag[]{VertxMetricsTags.uri(requestMetric.path, response.getStatusCode()), VertxMetricsTags.method(method), VertxMetricsTags.outcome(response), VertxMetricsTags.status(response.getStatusCode())})).increment();
        }
        log.debugf("responsePushed %s: %s, %s", (Object)uri, socketMetric, (Object)requestMetric);
        return requestMetric;
    }

    public RequestMetric requestBegin(Map<String, Object> socketMetric, HttpServerRequest request) {
        RequestMetric requestMetric = new RequestMetric();
        RequestMetric.setRequestMetric(Vertx.currentContext(), requestMetric);
        VertxMetricsTags.parseUriPath(requestMetric, this.matchPatterns, this.ignorePatterns, request.path());
        if (requestMetric.measure) {
            requestMetric.sample = Timer.start((MeterRegistry)this.registry).tags((Iterable)Tags.of((Tag[])new Tag[]{VertxMetricsTags.method(request.method())}));
            log.debugf("requestBegin %s: %s, %s", (Object)requestMetric.path, socketMetric, (Object)requestMetric);
        }
        return requestMetric;
    }

    public void requestReset(RequestMetric requestMetric) {
        log.debugf("requestReset: %s", (Object)requestMetric);
        Timer.Sample sample = this.getRequestSample(requestMetric);
        if (sample != null) {
            String requestPath = this.getServerRequestPath(requestMetric);
            sample.stop(this.registry, Timer.builder((String)this.nameHttpServerRequests).tags((Iterable)Tags.of((Tag[])new Tag[]{VertxMetricsTags.uri(requestPath, 0), Outcome.CLIENT_ERROR.asTag(), VertxMetricsTags.STATUS_RESET})));
        }
    }

    public void responseEnd(RequestMetric requestMetric, HttpServerResponse response) {
        log.debugf("responseEnd: %s, %s", (Object)requestMetric, (Object)response);
        Timer.Sample sample = this.getRequestSample(requestMetric);
        if (sample != null) {
            String requestPath = this.getServerRequestPath(requestMetric);
            sample.stop(this.registry, Timer.builder((String)this.nameHttpServerRequests).tags((Iterable)Tags.of((Tag[])new Tag[]{VertxMetricsTags.uri(requestPath, response.getStatusCode()), VertxMetricsTags.outcome(response), VertxMetricsTags.status(response.getStatusCode())})));
        }
    }

    public LongTaskTimer.Sample connected(Map<String, Object> socketMetric, RequestMetric requestMetric, ServerWebSocket serverWebSocket) {
        log.debugf("websocket connected: %s, %s, %s", socketMetric, (Object)requestMetric, (Object)serverWebSocket);
        String path = this.getServerRequestPath(requestMetric);
        if (path != null) {
            return LongTaskTimer.builder((String)this.nameWebsocketConnections).tags((Iterable)Tags.of((Tag[])new Tag[]{VertxMetricsTags.uri(path, 0)})).register(this.registry).start();
        }
        return null;
    }

    public void disconnected(LongTaskTimer.Sample websocketMetric) {
        log.debugf("websocket disconnected: %s", (Object)websocketMetric);
        if (websocketMetric != null) {
            websocketMetric.stop();
        }
    }

    private Timer.Sample getRequestSample(RequestMetric metricsContext) {
        if (metricsContext == null) {
            return null;
        }
        return metricsContext.sample;
    }

    private String getServerRequestPath(RequestMetric metricsContext) {
        if (metricsContext == null) {
            return null;
        }
        return metricsContext.getHttpRequestPath();
    }
}

