/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.export;

import io.micrometer.core.instrument.Clock;
import io.micrometer.datadog.DatadogConfig;
import io.micrometer.datadog.DatadogMeterRegistry;
import io.micrometer.datadog.DatadogNamingConvention;
import io.quarkus.arc.DefaultBean;
import io.quarkus.micrometer.runtime.export.ConfigAdapter;
import java.util.Map;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;

@Singleton
public class DatadogMeterRegistryProvider {
    private static final Logger log = Logger.getLogger(DatadogMeterRegistryProvider.class);
    static final String PREFIX = "quarkus.micrometer.export.datadog.";
    static final String PUBLISH = "datadog.publish";
    static final String ENABLED = "datadog.enabled";

    @Produces
    @Singleton
    @DefaultBean
    public DatadogConfig configure(Config config) {
        final Map<String, String> properties = ConfigAdapter.captureProperties(config, PREFIX);
        if (properties.containsKey(PUBLISH)) {
            properties.put(ENABLED, properties.get(PUBLISH));
        }
        return ConfigAdapter.validate(new DatadogConfig(){

            public String get(String key) {
                return (String)properties.get(key);
            }
        });
    }

    @Produces
    @DefaultBean
    public DatadogNamingConvention namingConvention() {
        return new DatadogNamingConvention();
    }

    @Produces
    @Singleton
    public DatadogMeterRegistry registry(DatadogConfig config, Clock clock) {
        return DatadogMeterRegistry.builder((DatadogConfig)config).clock(clock).build();
    }
}

