/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.export;

import io.micrometer.core.instrument.Clock;
import io.micrometer.stackdriver.StackdriverConfig;
import io.micrometer.stackdriver.StackdriverMeterRegistry;
import io.micrometer.stackdriver.StackdriverNamingConvention;
import io.quarkus.arc.DefaultBean;
import io.quarkus.micrometer.runtime.export.ConfigAdapter;
import java.util.Map;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;

@Singleton
public class StackdriverMeterRegistryProvider {
    private static final Logger log = Logger.getLogger(StackdriverMeterRegistryProvider.class);
    static final String PREFIX = "quarkus.micrometer.export.stackdriver.";
    static final String PUBLISH = "stackdriver.publish";
    static final String ENABLED = "stackdriver.enabled";

    @Produces
    @Singleton
    @DefaultBean
    public StackdriverConfig configure(Config config) throws Throwable {
        final Map<String, String> properties = ConfigAdapter.captureProperties(config, PREFIX);
        if (properties.containsKey(PUBLISH)) {
            properties.put(ENABLED, properties.get(PUBLISH));
        }
        return ConfigAdapter.validate(new StackdriverConfig(){

            public String get(String key) {
                return (String)properties.get(key);
            }
        });
    }

    @Produces
    @DefaultBean
    public StackdriverNamingConvention namingConvention() {
        return new StackdriverNamingConvention();
    }

    @Produces
    @Singleton
    public StackdriverMeterRegistry registry(StackdriverConfig config, Clock clock) {
        return StackdriverMeterRegistry.builder((StackdriverConfig)config).clock(clock).build();
    }
}

