/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.mpmetrics;

import io.micrometer.core.instrument.Timer;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MetricRegistryAdapter;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MpMetadata;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MpMetricsRegistryProducer;
import io.quarkus.micrometer.runtime.binder.mpmetrics.TimerAdapter;
import javax.annotation.Priority;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.annotation.Timed;

@Timed
@Interceptor
@Priority(value=1010)
class TimedInterceptor {
    final MetricRegistryAdapter mpRegistry;

    TimedInterceptor(MetricRegistryAdapter mpRegistry) {
        this.mpRegistry = mpRegistry;
    }

    @AroundConstruct
    Object timedConstructor(InvocationContext context) throws Exception {
        return this.time(context, context.getConstructor().getDeclaringClass().getSimpleName());
    }

    @AroundInvoke
    Object timedMethod(InvocationContext context) throws Exception {
        return this.time(context, context.getMethod().getName());
    }

    @AroundTimeout
    Object timedTimeout(InvocationContext context) throws Exception {
        return this.time(context, context.getMethod().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object time(InvocationContext context, String methodName) throws Exception {
        Timed annotation = MpMetricsRegistryProducer.getAnnotation(context, Timed.class);
        if (annotation != null) {
            MpMetadata metadata = new MpMetadata(annotation.name().replace("<method>", methodName), annotation.description().replace("<method>", methodName), annotation.unit(), MetricType.TIMER);
            TimerAdapter impl = this.mpRegistry.interceptorTimer(metadata, annotation.tags());
            Timer.Sample sample = impl.start();
            try {
                Object object = context.proceed();
                return object;
            }
            finally {
                try {
                    impl.stop(sample);
                }
                catch (Exception exception) {}
            }
        }
        return context.proceed();
    }
}

