/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.quarkus.arc.Arc;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import io.quarkus.micrometer.runtime.binder.HttpMetricsCommon;
import io.quarkus.micrometer.runtime.binder.HttpRequestMetric;
import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.spi.RestClientListener;

public class RestClientMetrics
implements RestClientListener {
    private static final String HTTP_CLIENT_METRIC_NAME = "http.client.requests";
    private static final String REQUEST_METRIC_PROPERTY = "restClientMetrics";
    final MeterRegistry registry = Metrics.globalRegistry;
    MetricsClientRequestFilter clientRequestFilter;
    MetricsClientResponseFilter clientResponseFilter;

    public void onNewClient(Class<?> serviceInterface, RestClientBuilder builder) {
        builder.register((Object)this.getClientRequestFilter());
        builder.register((Object)this.getClientResponseFilter());
    }

    MetricsClientRequestFilter getClientRequestFilter() {
        MetricsClientRequestFilter clientFilter = this.clientRequestFilter;
        if (clientFilter == null) {
            HttpBinderConfiguration httpMetricsConfig = (HttpBinderConfiguration)Arc.container().instance(HttpBinderConfiguration.class, new Annotation[0]).get();
            clientFilter = this.clientRequestFilter = new MetricsClientRequestFilter(httpMetricsConfig);
        }
        return clientFilter;
    }

    MetricsClientResponseFilter getClientResponseFilter() {
        MetricsClientResponseFilter clientFilter = this.clientResponseFilter;
        if (clientFilter == null) {
            clientFilter = this.clientResponseFilter = new MetricsClientResponseFilter();
        }
        return clientFilter;
    }

    class MetricsClientResponseFilter
    implements ClientResponseFilter {
        MetricsClientResponseFilter() {
        }

        public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
            HttpRequestMetric requestMetric = this.getRequestMetric(requestContext);
            if (requestMetric != null) {
                Timer.Sample sample = requestMetric.sample;
                String requestPath = requestMetric.getHttpRequestPath();
                int statusCode = responseContext.getStatus();
                Timer.Builder builder = Timer.builder((String)RestClientMetrics.HTTP_CLIENT_METRIC_NAME).tags((Iterable)Tags.of((Tag[])new Tag[]{HttpMetricsCommon.method(requestContext.getMethod()), HttpMetricsCommon.uri(requestPath, statusCode), HttpMetricsCommon.outcome(statusCode), HttpMetricsCommon.status(statusCode), this.clientName(requestContext)}));
                sample.stop(builder.register(RestClientMetrics.this.registry));
            }
        }

        private HttpRequestMetric getRequestMetric(ClientRequestContext requestContext) {
            return (HttpRequestMetric)requestContext.getProperty(RestClientMetrics.REQUEST_METRIC_PROPERTY);
        }

        private Tag clientName(ClientRequestContext requestContext) {
            String host = requestContext.getUri().getHost();
            if (host == null) {
                host = "none";
            }
            return Tag.of((String)"clientName", (String)host);
        }
    }

    class MetricsClientRequestFilter
    implements ClientRequestFilter {
        HttpBinderConfiguration binderConfiguration;

        MetricsClientRequestFilter(HttpBinderConfiguration binderConfiguration) {
            this.binderConfiguration = binderConfiguration;
        }

        public void filter(ClientRequestContext requestContext) throws IOException {
            HttpRequestMetric requestMetric = new HttpRequestMetric(this.binderConfiguration.getClientMatchPatterns(), this.binderConfiguration.getClientIgnorePatterns(), requestContext.getUri().getPath());
            if (requestMetric.isMeasure()) {
                requestMetric.setSample(Timer.start((MeterRegistry)RestClientMetrics.this.registry));
                requestContext.setProperty(RestClientMetrics.REQUEST_METRIC_PROPERTY, (Object)requestMetric);
            }
        }
    }
}

