/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.config;

import io.quarkus.micrometer.runtime.config.HttpClientConfigGroup;
import io.quarkus.micrometer.runtime.config.HttpServerConfigGroup;
import io.quarkus.micrometer.runtime.config.JsonConfigGroup;
import io.quarkus.micrometer.runtime.config.KafkaConfigGroup;
import io.quarkus.micrometer.runtime.config.MPMetricsConfigGroup;
import io.quarkus.micrometer.runtime.config.PrometheusConfigGroup;
import io.quarkus.micrometer.runtime.config.VertxConfigGroup;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.Optional;

@ConfigRoot(name="micrometer", phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public final class MicrometerConfig {
    @ConfigItem(defaultValue="true")
    public boolean enabled;
    @ConfigItem(defaultValue="true")
    public boolean registryEnabledDefault;
    @ConfigItem(defaultValue="true")
    public boolean binderEnabledDefault;
    public BinderConfig binder;
    public ExportConfig export;

    public boolean checkRegistryEnabledWithDefault(CapabilityEnabled config) {
        if (this.enabled) {
            Optional<Boolean> configValue = config.getEnabled();
            if (configValue.isPresent()) {
                return configValue.get();
            }
            return this.registryEnabledDefault;
        }
        return false;
    }

    public boolean checkBinderEnabledWithDefault(CapabilityEnabled config) {
        if (this.enabled) {
            Optional<Boolean> configValue = config.getEnabled();
            if (configValue.isPresent()) {
                return configValue.get();
            }
            return this.binderEnabledDefault;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{enabled=" + this.enabled + ",binderEnabledDefault=" + this.binderEnabledDefault + ",registryEnabledDefault=" + this.registryEnabledDefault + '}';
    }

    public static interface CapabilityEnabled {
        public Optional<Boolean> getEnabled();
    }

    @ConfigGroup
    public static class ExportConfig {
        public JsonConfigGroup json;
        public PrometheusConfigGroup prometheus;
    }

    @ConfigGroup
    public static class BinderConfig {
        public HttpClientConfigGroup httpClient;
        public HttpServerConfigGroup httpServer;
        @ConfigItem(defaultValue="true")
        public boolean jvm;
        public KafkaConfigGroup kafka;
        public MPMetricsConfigGroup mpMetrics;
        @ConfigItem(defaultValue="true")
        public boolean system;
        public VertxConfigGroup vertx;
    }
}

