/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.http.Outcome;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import io.quarkus.micrometer.runtime.binder.HttpMetricsCommon;
import io.quarkus.micrometer.runtime.binder.HttpRequestMetric;
import io.quarkus.micrometer.runtime.binder.vertx.VertxMetricsTags;
import io.quarkus.micrometer.runtime.binder.vertx.VertxTcpMetrics;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class VertxHttpServerMetrics
extends VertxTcpMetrics
implements HttpServerMetrics<HttpRequestMetric, LongTaskTimer.Sample, Map<String, Object>> {
    static final Logger log = Logger.getLogger(VertxHttpServerMetrics.class);
    static final String METRICS_CONTEXT = "HTTP_REQUEST_METRICS_CONTEXT";
    final List<Pattern> ignorePatterns;
    final Map<Pattern, String> matchPatterns;
    final String nameWebsocketConnections;
    final String nameHttpServerPush;
    final String nameHttpServerRequests;

    VertxHttpServerMetrics(MeterRegistry registry, HttpBinderConfiguration config) {
        super(registry, "http.server");
        this.nameWebsocketConnections = "http.server.websocket.connections";
        this.nameHttpServerPush = "http.server.push";
        this.nameHttpServerRequests = "http.server.requests";
        this.ignorePatterns = config.getServerIgnorePatterns();
        this.matchPatterns = config.getServerMatchPatterns();
    }

    public static void setRequestMetric(Context context, HttpRequestMetric requestMetric) {
        if (context != null) {
            context.put(METRICS_CONTEXT, (Object)requestMetric);
        }
    }

    public static HttpRequestMetric retrieveRequestMetric(Context context) {
        if (context != null) {
            HttpRequestMetric requestMetric = (HttpRequestMetric)context.get(METRICS_CONTEXT);
            context.remove(METRICS_CONTEXT);
            return requestMetric;
        }
        return null;
    }

    public HttpRequestMetric responsePushed(Map<String, Object> socketMetric, HttpMethod method, String uri, HttpServerResponse response) {
        HttpRequestMetric requestMetric = new HttpRequestMetric(this.matchPatterns, this.ignorePatterns, uri);
        if (requestMetric.isMeasure()) {
            this.registry.counter(this.nameHttpServerPush, (Iterable)Tags.of((Tag[])new Tag[]{HttpMetricsCommon.uri(requestMetric.getPath(), response.getStatusCode()), VertxMetricsTags.method(method), VertxMetricsTags.outcome(response), HttpMetricsCommon.status(response.getStatusCode())})).increment();
        }
        log.debugf("responsePushed %s: %s, %s", (Object)uri, socketMetric, (Object)requestMetric);
        return requestMetric;
    }

    public HttpRequestMetric requestBegin(Map<String, Object> socketMetric, HttpServerRequest request) {
        HttpRequestMetric requestMetric = new HttpRequestMetric(this.matchPatterns, this.ignorePatterns, request.path());
        VertxHttpServerMetrics.setRequestMetric(Vertx.currentContext(), requestMetric);
        if (requestMetric.isMeasure()) {
            requestMetric.setSample(Timer.start((MeterRegistry)this.registry));
            requestMetric.setTags(Tags.of((Tag[])new Tag[]{VertxMetricsTags.method(request.method())}));
            log.debugf("requestBegin %s: %s, %s", (Object)requestMetric.getPath(), socketMetric, (Object)requestMetric);
        }
        return requestMetric;
    }

    public void requestReset(HttpRequestMetric requestMetric) {
        log.debugf("requestReset: %s", (Object)requestMetric);
        Timer.Sample sample = this.getRequestSample(requestMetric);
        if (sample != null) {
            String requestPath = this.getServerRequestPath(requestMetric);
            Timer.Builder builder = Timer.builder((String)this.nameHttpServerRequests).tags((Iterable)requestMetric.getTags()).tags((Iterable)Tags.of((Tag[])new Tag[]{HttpMetricsCommon.uri(requestPath, 0), Outcome.CLIENT_ERROR.asTag(), HttpMetricsCommon.STATUS_RESET}));
            sample.stop(builder.register(this.registry));
        }
    }

    public void responseEnd(HttpRequestMetric requestMetric, HttpServerResponse response) {
        log.debugf("responseEnd: %s, %s", (Object)requestMetric, (Object)response);
        Timer.Sample sample = this.getRequestSample(requestMetric);
        if (sample != null) {
            String requestPath = this.getServerRequestPath(requestMetric);
            Timer.Builder builder = Timer.builder((String)this.nameHttpServerRequests).tags((Iterable)requestMetric.getTags()).tags((Iterable)Tags.of((Tag[])new Tag[]{HttpMetricsCommon.uri(requestPath, response.getStatusCode()), VertxMetricsTags.outcome(response), HttpMetricsCommon.status(response.getStatusCode())}));
            sample.stop(builder.register(this.registry));
        }
    }

    public LongTaskTimer.Sample connected(Map<String, Object> socketMetric, HttpRequestMetric requestMetric, ServerWebSocket serverWebSocket) {
        log.debugf("websocket connected: %s, %s, %s", socketMetric, (Object)requestMetric, (Object)serverWebSocket);
        String path = this.getServerRequestPath(requestMetric);
        if (path != null) {
            return LongTaskTimer.builder((String)this.nameWebsocketConnections).tags((Iterable)Tags.of((Tag[])new Tag[]{HttpMetricsCommon.uri(path, 0)})).register(this.registry).start();
        }
        return null;
    }

    public void disconnected(LongTaskTimer.Sample websocketMetric) {
        log.debugf("websocket disconnected: %s", (Object)websocketMetric);
        if (websocketMetric != null) {
            websocketMetric.stop();
        }
    }

    private Timer.Sample getRequestSample(HttpRequestMetric metricsContext) {
        if (metricsContext == null) {
            return null;
        }
        return metricsContext.getSample();
    }

    private String getServerRequestPath(HttpRequestMetric metricsContext) {
        if (metricsContext == null) {
            return null;
        }
        return metricsContext.getHttpRequestPath();
    }
}

