/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.core.instrument.config.MeterFilter;
import io.quarkus.arc.Arc;
import io.quarkus.micrometer.runtime.CompositeRegistryCreator;
import io.quarkus.micrometer.runtime.MeterFilterConstraint;
import io.quarkus.micrometer.runtime.MicrometerMetricsFactory;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import io.quarkus.micrometer.runtime.binder.JVMInfoBinder;
import io.quarkus.micrometer.runtime.binder.vertx.VertxMeterBinderAdapter;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import io.quarkus.micrometer.runtime.config.runtime.HttpClientConfig;
import io.quarkus.micrometer.runtime.config.runtime.HttpServerConfig;
import io.quarkus.micrometer.runtime.config.runtime.VertxConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.metrics.MetricsFactory;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logging.Logger;

@Recorder
public class MicrometerRecorder {
    private static final Logger log = Logger.getLogger(MicrometerRecorder.class);
    static final String DEFAULT_EXCEPTION_TAG_VALUE = "none";
    static MicrometerMetricsFactory factory;

    public RuntimeValue<MeterRegistry> createRootRegistry(MicrometerConfig config) {
        VertxMeterBinderAdapter.setMeterRegistry((MeterRegistry)Metrics.globalRegistry);
        factory = new MicrometerMetricsFactory(config, (MeterRegistry)Metrics.globalRegistry);
        return new RuntimeValue((Object)Metrics.globalRegistry);
    }

    public void configureRegistries(MicrometerConfig config, Set<Class<? extends MeterRegistry>> registryClasses, ShutdownContext context) {
        BeanManager beanManager = Arc.container().beanManager();
        ArrayList<MeterRegistry> allRegistries = new ArrayList<MeterRegistry>();
        HashMap<Class, List> classMeterFilters = new HashMap<Class, List>(registryClasses.size());
        ArrayList<MeterFilter> globalFilters = new ArrayList<MeterFilter>();
        Instance globalFilterInstance = beanManager.createInstance().select(MeterFilter.class, new Annotation[]{Default.Literal.INSTANCE});
        this.populateListWithMeterFilters((Instance<MeterFilter>)globalFilterInstance, globalFilters);
        log.debugf("Configuring Micrometer registries : %s", registryClasses);
        for (Class<? extends MeterRegistry> clazz : registryClasses) {
            Instance classFilterInstance = beanManager.createInstance().select(MeterFilter.class, new Annotation[]{new MeterFilterConstraint.Literal(clazz)});
            List classFilters = classMeterFilters.computeIfAbsent(clazz, k -> new ArrayList());
            this.populateListWithMeterFilters((Instance<MeterFilter>)classFilterInstance, classFilters);
        }
        HashSet<Bean> beans = new HashSet<Bean>(beanManager.getBeans(MeterRegistry.class, new Annotation[]{Any.Literal.INSTANCE}));
        beans.removeIf(bean -> bean.getBeanClass().equals(CompositeRegistryCreator.class));
        this.applyMeterFilters((MeterRegistry)Metrics.globalRegistry, globalFilters);
        for (Bean i : beans) {
            MeterRegistry registry = (MeterRegistry)beanManager.getReference(i, MeterRegistry.class, beanManager.createCreationalContext((Contextual)i));
            if (registry == Metrics.globalRegistry) continue;
            this.applyMeterFilters(registry, globalFilters);
            this.applyMeterFilters(registry, (List)classMeterFilters.get(registry.getClass()));
            log.debugf("Adding configured registry %s", registry.getClass(), (Object)registry);
            Metrics.globalRegistry.add(registry);
            allRegistries.add(registry);
        }
        if (config.binder.jvm) {
            new ClassLoaderMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            new JvmHeapPressureMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            new JvmMemoryMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            new JvmThreadMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            new JVMInfoBinder().bindTo((MeterRegistry)Metrics.globalRegistry);
            if (!ImageInfo.inImageCode()) {
                new JvmGcMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            }
        }
        if (config.binder.system) {
            new UptimeMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            new ProcessorMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            new FileDescriptorMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        }
        Instance instance = beanManager.createInstance().select(MeterBinder.class, new Annotation[]{Any.Literal.INSTANCE});
        instance.forEach(x -> x.bindTo((MeterRegistry)Metrics.globalRegistry));
        context.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                ArrayList cleanup = new ArrayList(Metrics.globalRegistry.getRegistries());
                cleanup.forEach(x -> {
                    x.close();
                    Metrics.removeRegistry((MeterRegistry)x);
                });
            }
        });
    }

    void populateListWithMeterFilters(Instance<MeterFilter> filterInstance, List<MeterFilter> meterFilters) {
        if (!filterInstance.isUnsatisfied()) {
            for (MeterFilter filter : filterInstance) {
                if (filter == null) continue;
                meterFilters.add(filter);
            }
        }
    }

    void applyMeterFilters(MeterRegistry registry, List<MeterFilter> filters) {
        if (filters != null) {
            for (MeterFilter meterFilter : filters) {
                registry.config().meterFilter(meterFilter);
            }
        }
    }

    public void registerMetrics(Consumer<MetricsFactory> consumer) {
        consumer.accept(factory);
    }

    public static Class<?> getClassForName(String classname) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(classname, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        log.debugf("getClass: TCCL: %s ## %s : %s", (Object)Thread.currentThread().getContextClassLoader(), (Object)classname, (Object)(clazz != null ? 1 : 0));
        return clazz;
    }

    static String getExceptionTag(Throwable throwable) {
        if (throwable == null) {
            return DEFAULT_EXCEPTION_TAG_VALUE;
        }
        if (throwable.getCause() == null) {
            return throwable.getClass().getSimpleName();
        }
        return throwable.getCause().getClass().getSimpleName();
    }

    public RuntimeValue<HttpBinderConfiguration> configureHttpMetrics(boolean httpServerMetricsEnabled, boolean httpClientMetricsEnabled, HttpServerConfig serverConfig, HttpClientConfig clientConfig, VertxConfig vertxConfig) {
        return new RuntimeValue((Object)new HttpBinderConfiguration(httpServerMetricsEnabled, httpClientMetricsEnabled, serverConfig, clientConfig, vertxConfig));
    }
}

