/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.quarkus.micrometer.runtime.binder.RequestMetricInfo;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class HttpRequestMetric
extends RequestMetricInfo {
    public static final Pattern VERTX_ROUTE_PARAM = Pattern.compile("^:(.*)$");
    static final ConcurrentHashMap<String, String> templatePath = new ConcurrentHashMap();
    volatile RoutingContext routingContext;

    public HttpRequestMetric(Map<Pattern, String> matchPattern, List<Pattern> ignorePatterns, String uri) {
        super(matchPattern, ignorePatterns, uri);
    }

    @Override
    public String getHttpRequestPath() {
        if (this.pathMatched) {
            return this.path;
        }
        if (this.routingContext != null) {
            String rcPath = (String)this.routingContext.get("HTTP_REQUEST_PATH");
            if (rcPath != null) {
                return rcPath;
            }
            String matchedPath = this.routingContext.currentRoute().getPath();
            if (matchedPath != null) {
                if (matchedPath.contains(":")) {
                    matchedPath = templatePath.computeIfAbsent(matchedPath, k -> {
                        CharSequence[] segments = k.split("/");
                        for (int i = 0; i < segments.length; ++i) {
                            segments[i] = VERTX_ROUTE_PARAM.matcher(segments[i]).replaceAll("{$1}");
                        }
                        return String.join((CharSequence)"/", segments);
                    });
                }
                return matchedPath;
            }
        }
        return this.path;
    }

    public RoutingContext getRoutingContext() {
        return this.routingContext;
    }

    public void setRoutingContext(RoutingContext routingContext) {
        this.routingContext = routingContext;
    }
}

