/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder;

import io.quarkus.micrometer.runtime.config.runtime.HttpClientConfig;
import io.quarkus.micrometer.runtime.config.runtime.HttpServerConfig;
import io.quarkus.micrometer.runtime.config.runtime.VertxConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jboss.logging.Logger;

public class HttpBinderConfiguration {
    private static final Logger log = Logger.getLogger(HttpBinderConfiguration.class);
    boolean serverEnabled = true;
    boolean clientEnabled = true;
    List<Pattern> serverIgnorePatterns = Collections.emptyList();
    Map<Pattern, String> serverMatchPatterns = Collections.emptyMap();
    List<Pattern> clientIgnorePatterns = Collections.emptyList();
    Map<Pattern, String> clientMatchPatterns = Collections.emptyMap();

    private HttpBinderConfiguration() {
    }

    public HttpBinderConfiguration(boolean httpServerMetrics, boolean httpClientMetrics, HttpServerConfig serverConfig, HttpClientConfig clientConfig, VertxConfig vertxConfig) {
        this.serverEnabled = httpServerMetrics;
        this.clientEnabled = httpClientMetrics;
        if (this.serverEnabled) {
            this.serverIgnorePatterns = this.getIgnorePatterns(serverConfig.ignorePatterns.isPresent() ? serverConfig.ignorePatterns : vertxConfig.ignorePatterns);
            this.serverMatchPatterns = this.getMatchPatterns(serverConfig.matchPatterns.isPresent() ? serverConfig.matchPatterns : vertxConfig.matchPatterns);
        }
        if (this.clientEnabled) {
            this.clientIgnorePatterns = this.getIgnorePatterns(clientConfig.ignorePatterns);
            this.clientMatchPatterns = this.getMatchPatterns(clientConfig.matchPatterns);
        }
    }

    public boolean isServerEnabled() {
        return this.serverEnabled;
    }

    public List<Pattern> getServerIgnorePatterns() {
        return this.serverIgnorePatterns;
    }

    public Map<Pattern, String> getServerMatchPatterns() {
        return this.serverMatchPatterns;
    }

    public boolean isClientEnabled() {
        return this.clientEnabled;
    }

    public List<Pattern> getClientIgnorePatterns() {
        return this.clientIgnorePatterns;
    }

    public Map<Pattern, String> getClientMatchPatterns() {
        return this.clientMatchPatterns;
    }

    List<Pattern> getIgnorePatterns(Optional<List<String>> configInput) {
        if (configInput.isPresent()) {
            List<String> input = configInput.get();
            ArrayList<Pattern> ignorePatterns = new ArrayList<Pattern>(input.size());
            for (String s : input) {
                ignorePatterns.add(Pattern.compile(s.trim()));
            }
            return Collections.unmodifiableList(ignorePatterns);
        }
        return Collections.emptyList();
    }

    Map<Pattern, String> getMatchPatterns(Optional<List<String>> configInput) {
        if (configInput.isPresent()) {
            List<String> input = configInput.get();
            LinkedHashMap<Pattern, String> matchPatterns = new LinkedHashMap<Pattern, String>(input.size());
            for (String s : input) {
                int pos = s.indexOf("=");
                if (pos > 0 && s.length() > 2) {
                    String pattern = s.substring(0, pos).trim();
                    String replacement = s.substring(pos + 1).trim();
                    try {
                        matchPatterns.put(Pattern.compile(pattern), replacement);
                    }
                    catch (PatternSyntaxException pse) {
                        log.errorf("Invalid pattern in replacement string (%s=%s): %s", (Object)pattern, (Object)replacement, (Object)pse);
                    }
                    continue;
                }
                log.errorf("Invalid pattern in replacement string (%s). Should be pattern=replacement", (Object)s);
            }
            return Collections.unmodifiableMap(matchPatterns);
        }
        return Collections.emptyMap();
    }

    public String getHttpServerRequestsName() {
        return "http.server.requests";
    }

    public String getHttpServerPushName() {
        return "http.server.push";
    }

    public String getHttpServerWebSocketConnectionsName() {
        return "http.server.websocket.connections";
    }

    public String getHttpClientRequestsName() {
        return "http.client.requests";
    }

    public HttpBinderConfiguration unwrap() {
        HttpBinderConfiguration result = new HttpBinderConfiguration();
        result.clientEnabled = this.clientEnabled;
        result.serverEnabled = this.serverEnabled;
        return result.update(this);
    }

    public HttpBinderConfiguration update(HttpBinderConfiguration httpConfig) {
        this.clientMatchPatterns = httpConfig.clientMatchPatterns;
        this.serverMatchPatterns = httpConfig.serverMatchPatterns;
        this.clientIgnorePatterns = httpConfig.clientIgnorePatterns;
        this.serverIgnorePatterns = httpConfig.serverIgnorePatterns;
        return this;
    }
}

