/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.quarkus.micrometer.runtime.binder.RequestMetricInfo;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class HttpRequestMetric
extends RequestMetricInfo {
    public static final Pattern VERTX_ROUTE_PARAM = Pattern.compile("^:(.*)$");
    static final ConcurrentHashMap<String, String> vertxWebToUriTemplate = new ConcurrentHashMap();
    protected HttpServerRequest request;
    protected String initialPath;
    protected String templatePath;
    protected RoutingContext routingContext;

    public HttpRequestMetric(String uri) {
        this.initialPath = uri;
    }

    public HttpRequestMetric(HttpServerRequest request) {
        this.request = request;
        this.initialPath = this.request.path();
    }

    public String getNormalizedUriPath(Map<Pattern, String> matchPatterns, List<Pattern> ignorePatterns) {
        if (this.isCORSPreflightRequest()) {
            return HttpRequestMetric.filterIgnored("/cors-preflight", ignorePatterns);
        }
        return super.getNormalizedUriPath(matchPatterns, ignorePatterns, this.initialPath);
    }

    @Override
    public String applyTemplateMatching(String path) {
        String currentRoutePath = this.getCurrentRoute();
        if (this.templatePath != null) {
            return HttpRequestMetric.normalizePath(this.templatePath);
        }
        if (currentRoutePath != null && currentRoutePath.contains(":")) {
            return vertxWebToUriTemplate.computeIfAbsent(currentRoutePath, k -> {
                CharSequence[] segments = k.split("/");
                for (int i = 0; i < segments.length; ++i) {
                    segments[i] = VERTX_ROUTE_PARAM.matcher(segments[i]).replaceAll("{$1}");
                }
                return HttpRequestMetric.normalizePath(String.join((CharSequence)"/", segments));
            });
        }
        return path;
    }

    public HttpServerRequest request() {
        return this.request;
    }

    public void setTemplatePath(String path) {
        if (this.templatePath == null) {
            this.templatePath = path;
        }
    }

    String getCurrentRoute() {
        return this.routingContext == null ? null : this.routingContext.currentRoute().getPath();
    }

    public void setRoutingContext(RoutingContext routingContext) {
        this.routingContext = routingContext;
    }

    public static HttpRequestMetric getRequestMetric(RoutingContext context) {
        HttpRequestMetric metric = (HttpRequestMetric)context.get("HTTP_REQUEST_METRICS_CONTEXT");
        return metric;
    }

    public String toString() {
        return "HttpRequestMetric [initialPath=" + this.initialPath + ", currentRoutePath=" + this.getCurrentRoute() + ", templatePath=" + this.templatePath + ", request=" + this.request + "]";
    }

    private boolean isCORSPreflightRequest() {
        return this.request.method() == HttpMethod.OPTIONS && this.request.getHeader("Origin") != null && this.request.getHeader("Access-Control-Request-Method") != null && this.request.getHeader("Access-Control-Request-Headers") != null;
    }
}

