/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.http.Outcome;
import io.quarkus.micrometer.runtime.binder.vertx.RequestMetric;
import io.quarkus.micrometer.runtime.binder.vertx.VertxMetricsTags;
import io.quarkus.micrometer.runtime.binder.vertx.VertxTcpMetrics;
import io.quarkus.micrometer.runtime.config.runtime.VertxConfig;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class VertxHttpServerMetrics
extends VertxTcpMetrics
implements HttpServerMetrics<RequestMetric, LongTaskTimer.Sample, Map<String, Object>> {
    static final Logger log = Logger.getLogger(VertxHttpServerMetrics.class);
    final List<Pattern> ignorePatterns;
    final List<Pattern> matchPatterns;
    final String nameWebsocketConnections;
    final String nameHttpServerPush;
    final String nameHttpServerRequests;

    VertxHttpServerMetrics(MeterRegistry registry, VertxConfig config) {
        super(registry, "http.server");
        List<String> stringPatterns;
        this.nameWebsocketConnections = "http.server.websocket.connections";
        this.nameHttpServerPush = "http.server.push";
        this.nameHttpServerRequests = "http.server.requests";
        if (config.ignorePatterns.isPresent()) {
            stringPatterns = config.ignorePatterns.get();
            this.ignorePatterns = new ArrayList<Pattern>(stringPatterns.size());
            for (String s : stringPatterns) {
                this.ignorePatterns.add(Pattern.compile(s));
            }
        } else {
            this.ignorePatterns = Collections.emptyList();
        }
        if (config.matchPatterns.isPresent()) {
            stringPatterns = config.matchPatterns.get();
            this.matchPatterns = new ArrayList<Pattern>(stringPatterns.size());
            for (String s : stringPatterns) {
                this.matchPatterns.add(Pattern.compile(s));
            }
        } else {
            this.matchPatterns = Collections.emptyList();
        }
    }

    public RequestMetric responsePushed(Map<String, Object> socketMetric, HttpMethod method, String uri, HttpServerResponse response) {
        RequestMetric requestMetric = new RequestMetric();
        String path = VertxMetricsTags.parseUriPath(this.matchPatterns, this.ignorePatterns, uri);
        if (path != null) {
            this.registry.counter(this.nameHttpServerPush, (Iterable)Tags.of((Tag[])new Tag[]{VertxMetricsTags.uri(path, response.getStatusCode()), VertxMetricsTags.method(method), VertxMetricsTags.outcome(response), VertxMetricsTags.status(response.getStatusCode())})).increment();
        }
        log.debugf("responsePushed %s: %s, %s", (Object)uri, socketMetric, (Object)requestMetric);
        return requestMetric;
    }

    public RequestMetric requestBegin(Map<String, Object> socketMetric, HttpServerRequest request) {
        RequestMetric requestMetric = new RequestMetric();
        RequestMetric.setRequestMetric(Vertx.currentContext(), requestMetric);
        String path = VertxMetricsTags.parseUriPath(this.matchPatterns, this.ignorePatterns, request.uri());
        if (path != null) {
            requestMetric.put("HTTP_REQUEST_SAMPLE", Timer.start((MeterRegistry)this.registry).tags((Iterable)Tags.of((Tag[])new Tag[]{VertxMetricsTags.method(request.method())})));
            requestMetric.put("HTTP_REQUEST_PATH", path);
        }
        log.debugf("requestBegin %s: %s, %s, %s", new Object[]{request.uri(), socketMetric, requestMetric, request.headers()});
        return requestMetric;
    }

    public void requestReset(RequestMetric requestMetric) {
        log.debugf("requestReset: %s", (Object)requestMetric);
        Timer.Sample sample = this.getRequestSample(requestMetric);
        if (sample != null) {
            String requestPath = this.getServerRequestPath(requestMetric);
            sample.stop(this.registry, Timer.builder((String)this.nameHttpServerRequests).tags((Iterable)Tags.of((Tag[])new Tag[]{VertxMetricsTags.uri(requestPath, 0), Outcome.CLIENT_ERROR.asTag(), VertxMetricsTags.STATUS_RESET})));
        }
    }

    public void responseEnd(RequestMetric requestMetric, HttpServerResponse response) {
        log.debugf("responseEnd: %s, %s", (Object)requestMetric, (Object)response);
        Timer.Sample sample = this.getRequestSample(requestMetric);
        if (sample != null) {
            String requestPath = this.getServerRequestPath(requestMetric);
            sample.stop(this.registry, Timer.builder((String)this.nameHttpServerRequests).tags((Iterable)Tags.of((Tag[])new Tag[]{VertxMetricsTags.uri(requestPath, response.getStatusCode()), VertxMetricsTags.outcome(response), VertxMetricsTags.status(response.getStatusCode())})));
        }
    }

    public LongTaskTimer.Sample connected(Map<String, Object> socketMetric, RequestMetric requestMetric, ServerWebSocket serverWebSocket) {
        log.debugf("websocket connected: %s, %s, %s", socketMetric, (Object)requestMetric, (Object)serverWebSocket);
        String path = this.getServerRequestPath(requestMetric);
        if (path != null) {
            return LongTaskTimer.builder((String)this.nameWebsocketConnections).tags((Iterable)Tags.of((Tag[])new Tag[]{VertxMetricsTags.uri(path, 0)})).register(this.registry).start();
        }
        return null;
    }

    public void disconnected(LongTaskTimer.Sample websocketMetric) {
        log.debugf("websocket disconnected: %s", (Object)websocketMetric);
        if (websocketMetric != null) {
            websocketMetric.stop();
        }
    }

    private Timer.Sample getRequestSample(RequestMetric metricsContext) {
        if (metricsContext == null) {
            return null;
        }
        return (Timer.Sample)metricsContext.getValue("HTTP_REQUEST_SAMPLE");
    }

    private String getServerRequestPath(RequestMetric metricsContext) {
        if (metricsContext == null) {
            return null;
        }
        String path = (String)metricsContext.getFromRoutingContext("HTTP_REQUEST_PATH");
        if (path != null) {
            log.debugf("Using path from routing context %s", (Object)path);
            return path;
        }
        return (String)metricsContext.getValue("HTTP_REQUEST_PATH");
    }
}

