/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.export;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.stackdriver.StackdriverConfig;
import io.micrometer.stackdriver.StackdriverMeterRegistry;
import io.quarkus.arc.DefaultBean;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;

@Singleton
public class StackdriverMeterRegistryProvider {
    private static final Logger log = Logger.getLogger(StackdriverMeterRegistryProvider.class);
    static final String PREFIX = "quarkus.micrometer.export.stackdriver.";
    static final String PUBLISH = "stackdriver.publish";
    static final String ENABLED = "stackdriver.enabled";

    @Produces
    @Singleton
    @DefaultBean
    public StackdriverConfig configure(Config config) throws Throwable {
        final Map<String, String> properties = MicrometerRecorder.captureProperties(config, PREFIX);
        if (properties.containsKey(PUBLISH)) {
            properties.put(ENABLED, properties.get(PUBLISH));
        }
        StackdriverConfig sdConfig = new StackdriverConfig(){

            public String get(String key) {
                return (String)properties.get(key);
            }
        };
        Validated validated = sdConfig.validate();
        List errors = validated.failures();
        if (validated.isInvalid()) {
            errors.stream().forEach(x -> log.error((Object)x.getMessage(), x.getException()));
        }
        return sdConfig;
    }

    @Produces
    @Singleton
    public StackdriverMeterRegistry registry(StackdriverConfig config, Clock clock) {
        return new StackdriverMeterRegistry(config, clock);
    }
}

