/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.Timer;
import io.vertx.core.Context;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class RequestMetric {
    static final String METRICS_CONTEXT = "HTTP_REQUEST_METRICS_CONTEXT";
    static final String HTTP_REQUEST_PATH = "HTTP_REQUEST_PATH";
    static final String HTTP_REQUEST_PATH_MATCHED = "HTTP_REQUEST_MATCHED_PATH";
    static final Pattern VERTX_ROUTE_PARAM = Pattern.compile("^:(.*)$");
    static final ConcurrentHashMap<String, String> vertxRoutePath = new ConcurrentHashMap();
    volatile RoutingContext routingContext;
    boolean measure = false;
    String path;
    boolean pathMatched = false;
    Timer.Sample sample;

    public static void setRequestMetric(Context context, RequestMetric requestMetric) {
        if (context != null) {
            context.put(METRICS_CONTEXT, (Object)requestMetric);
        }
    }

    public static RequestMetric retrieveRequestMetric(Context context) {
        if (context != null) {
            RequestMetric requestMetric = (RequestMetric)context.get(METRICS_CONTEXT);
            context.remove(METRICS_CONTEXT);
            return requestMetric;
        }
        return null;
    }

    String getHttpRequestPath() {
        if (this.pathMatched) {
            return this.path;
        }
        if (this.routingContext != null) {
            String rcPath = (String)this.routingContext.get(HTTP_REQUEST_PATH);
            if (rcPath != null) {
                return rcPath;
            }
            String matchedPath = this.routingContext.currentRoute().getPath();
            if (matchedPath != null) {
                if (matchedPath.contains(":")) {
                    matchedPath = vertxRoutePath.computeIfAbsent(matchedPath, k -> {
                        CharSequence[] segments = k.split("/");
                        for (int i = 0; i < segments.length; ++i) {
                            segments[i] = VERTX_ROUTE_PARAM.matcher(segments[i]).replaceAll("{$1}");
                        }
                        return String.join((CharSequence)"/", segments);
                    });
                }
                return matchedPath;
            }
        }
        return this.path;
    }
}

