/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.MicrometerTimed;
import java.lang.reflect.Method;
import java.util.concurrent.CompletionStage;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.logging.Logger;

@Interceptor
@MicrometerTimed
@Priority(value=1010)
public class MicrometerTimedInterceptor {
    private static final Logger log = Logger.getLogger(MicrometerTimedInterceptor.class);
    public static final String DEFAULT_METRIC_NAME = "method.timed";
    private final MeterRegistry meterRegistry;

    public MicrometerTimedInterceptor(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @AroundInvoke
    Object timedMethod(InvocationContext context) throws Exception {
        Method method = context.getMethod();
        Timed timed = method.getAnnotation(Timed.class);
        if (timed == null) {
            return context.proceed();
        }
        Tags commonTags = this.getCommonTags(method.getDeclaringClass().getName(), method.getName());
        boolean stopWhenCompleted = CompletionStage.class.isAssignableFrom(method.getReturnType());
        return this.time(context, timed, commonTags, stopWhenCompleted);
    }

    Object time(InvocationContext context, Timed timed, Tags commonTags, boolean stopWhenCompleted) throws Exception {
        String metricName;
        String string = metricName = timed.value().isEmpty() ? DEFAULT_METRIC_NAME : timed.value();
        if (timed.longTask()) {
            return this.processWithLongTaskTimer(context, timed, commonTags, metricName, stopWhenCompleted);
        }
        return this.processWithTimer(context, timed, commonTags, metricName, stopWhenCompleted);
    }

    private Object processWithTimer(InvocationContext context, Timed timed, Tags commonTags, String metricName, boolean stopWhenCompleted) throws Exception {
        Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry).tags((Iterable)commonTags).tags(timed.extraTags());
        if (stopWhenCompleted) {
            try {
                return ((CompletionStage)context.proceed()).whenComplete((result, throwable) -> this.record(timed, metricName, sample, MicrometerRecorder.getExceptionTag(throwable)));
            }
            catch (Exception ex) {
                this.record(timed, metricName, sample, MicrometerRecorder.getExceptionTag(ex));
                throw ex;
            }
        }
        String exceptionClass = MicrometerRecorder.getExceptionTag(null);
        try {
            Object object = context.proceed();
            return object;
        }
        catch (Exception ex) {
            exceptionClass = MicrometerRecorder.getExceptionTag(ex);
            throw ex;
        }
        finally {
            this.record(timed, metricName, sample, exceptionClass);
        }
    }

    private void record(Timed timed, String metricName, Timer.Sample sample, String exceptionClass) {
        try {
            Timer.Builder builder = Timer.builder((String)metricName).description(timed.description().isEmpty() ? null : timed.description()).tag("exception", exceptionClass).publishPercentileHistogram(Boolean.valueOf(timed.histogram())).publishPercentiles(timed.percentiles().length == 0 ? null : timed.percentiles());
            sample.stop(this.meterRegistry, builder);
        }
        catch (Exception e) {
            log.warnf((Throwable)e, "Unable to record observed timer value for %s with exceptionClass %s", (Object)metricName, (Object)exceptionClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processWithLongTaskTimer(InvocationContext context, Timed timed, Tags commonTags, String metricName, boolean stopWhenCompleted) throws Exception {
        LongTaskTimer.Sample sample = this.startLongTaskTimer(timed, commonTags, metricName);
        if (sample == null) {
            return context.proceed();
        }
        if (stopWhenCompleted) {
            try {
                return ((CompletionStage)context.proceed()).whenComplete((result, throwable) -> this.stopLongTaskTimer(metricName, sample));
            }
            catch (Exception ex) {
                this.stopLongTaskTimer(metricName, sample);
                throw ex;
            }
        }
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            this.stopLongTaskTimer(metricName, sample);
        }
    }

    LongTaskTimer.Sample startLongTaskTimer(Timed timed, Tags commonTags, String metricName) {
        try {
            return LongTaskTimer.builder((String)metricName).description(timed.description().isEmpty() ? null : timed.description()).tags((Iterable)commonTags).tags(timed.extraTags()).register(this.meterRegistry).start();
        }
        catch (Exception e) {
            log.warnf((Throwable)e, "Unable to create long task timer named %s", (Object)metricName);
            return null;
        }
    }

    private void stopLongTaskTimer(String metricName, LongTaskTimer.Sample sample) {
        try {
            sample.stop();
        }
        catch (Exception e) {
            log.warnf((Throwable)e, "Unable to update long task timer named %s", (Object)metricName);
        }
    }

    private Tags getCommonTags(String className, String methodName) {
        return Tags.of((String[])new String[]{"class", className, "method", methodName});
    }
}

